/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.Code93Reader;
import oz.util.barcode.oned.OneDimensionalCodeWriter;

public class Code93Writer
extends OneDimensionalCodeWriter {
    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.CODE_93) {
            throw new IllegalArgumentException("Can only encode CODE_93, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2 = string.length();
        if (n2 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n2);
        }
        int[] nArray = new int[9];
        int n3 = (string.length() + 2 + 2) * 9 + 1;
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[47], nArray);
        boolean[] blArray = new boolean[n3];
        int n4 = Code93Writer.appendPattern(blArray, 0, nArray);
        int n5 = 0;
        while (n5 < n2) {
            n = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(string.charAt(n5));
            Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[n], nArray);
            n4 += Code93Writer.appendPattern(blArray, n4, nArray);
            ++n5;
        }
        n5 = Code93Writer.computeChecksumIndex(string, 20);
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[n5], nArray);
        n4 += Code93Writer.appendPattern(blArray, n4, nArray);
        string = String.valueOf(string) + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".charAt(n5);
        n = Code93Writer.computeChecksumIndex(string, 15);
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[n], nArray);
        n4 += Code93Writer.appendPattern(blArray, n4, nArray);
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[47], nArray);
        n4 += Code93Writer.appendPattern(blArray, n4, nArray);
        blArray[n4] = true;
        return blArray;
    }

    private static void toIntArray(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < 9) {
            int n3 = n & 1 << 8 - n2;
            nArray[n2] = n3 == 0 ? 0 : 1;
            ++n2;
        }
    }

    protected static int appendPattern(boolean[] blArray, int n, int[] nArray, boolean bl) {
        return Code93Writer.appendPattern(blArray, n, nArray);
    }

    private static int appendPattern(boolean[] blArray, int n, int[] nArray) {
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            blArray[n++] = n4 != 0;
            ++n3;
        }
        return 9;
    }

    private static int computeChecksumIndex(String string, int n) {
        int n2 = 1;
        int n3 = 0;
        int n4 = string.length() - 1;
        while (n4 >= 0) {
            int n5 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(string.charAt(n4));
            n3 += n5 * n2;
            if (++n2 > n) {
                n2 = 1;
            }
            --n4;
        }
        return n3 % 47;
    }
}

