/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.FormatException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.EAN13Reader;
import oz.util.barcode.oned.UPCEANReader;
import oz.util.barcode.oned.UPCEANWriter;

public final class EAN13Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 95;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.EAN_13) {
            throw new IllegalArgumentException("Can only encode EAN_13, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2;
        int n3 = string.length();
        switch (n3) {
            case 12: {
                try {
                    n2 = UPCEANReader.getStandardUPCEANChecksum(string);
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException(formatException);
                }
                string = String.valueOf(string) + n2;
                break;
            }
            case 13: {
                try {
                    if (UPCEANReader.checkStandardUPCEANChecksum(string)) break;
                    throw new IllegalArgumentException("Contents do not pass checksum");
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException("Illegal contents");
                }
            }
            default: {
                throw new IllegalArgumentException("Requested contents should be 12 or 13 digits long, but got " + n3);
            }
        }
        n2 = Character.digit(string.charAt(0), 10);
        int n4 = EAN13Reader.FIRST_DIGIT_ENCODINGS[n2];
        boolean[] blArray = new boolean[95];
        int n5 = 0;
        n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.START_END_PATTERN, true);
        int n6 = 1;
        while (n6 <= 6) {
            n = Character.digit(string.charAt(n6), 10);
            if ((n4 >> 6 - n6 & 1) == 1) {
                n += 10;
            }
            n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.L_AND_G_PATTERNS[n], false);
            ++n6;
        }
        n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.MIDDLE_PATTERN, false);
        n6 = 7;
        while (n6 <= 12) {
            n = Character.digit(string.charAt(n6), 10);
            n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.L_PATTERNS[n], true);
            ++n6;
        }
        EAN13Writer.appendPattern(blArray, n5, UPCEANReader.START_END_PATTERN, true);
        return blArray;
    }
}

