/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.FormatException;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.OneDReader;

public final class ITFReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.38f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.5f;
    private static final int W = 3;
    private static final int w = 2;
    private static final int N = 1;
    private static final int[] DEFAULT_ALLOWED_LENGTHS = new int[]{6, 8, 10, 12, 14};
    private int narrowLineWidth = -1;
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[][] END_PATTERN_REVERSED = new int[][]{{1, 1, 2}, {1, 1, 3}};
    private static final int[][] PATTERNS = new int[][]{{1, 1, 2, 2, 1}, {2, 1, 1, 1, 2}, {1, 2, 1, 1, 2}, {2, 2, 1, 1, 1}, {1, 1, 2, 1, 2}, {2, 1, 2, 1, 1}, {1, 2, 2, 1, 1}, {1, 1, 1, 2, 2}, {2, 1, 1, 2, 1}, {1, 2, 1, 2, 1}, {1, 1, 3, 3, 1}, {3, 1, 1, 1, 3}, {1, 3, 1, 1, 3}, {3, 3, 1, 1, 1}, {1, 1, 3, 1, 3}, {3, 1, 3, 1, 1}, {1, 3, 3, 1, 1}, {1, 1, 1, 3, 3}, {3, 1, 1, 3, 1}, {1, 3, 1, 3, 1}};

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        int[] nArray = this.decodeStart(bitArray);
        int[] nArray2 = this.decodeEnd(bitArray);
        StringBuilder stringBuilder = new StringBuilder(20);
        ITFReader.decodeMiddle(bitArray, nArray[1], nArray2[0], stringBuilder);
        String string = stringBuilder.toString();
        int[] nArray3 = null;
        if (map != null) {
            nArray3 = (int[])map.get((Object)DecodeHintType.ALLOWED_LENGTHS);
        }
        if (nArray3 == null) {
            nArray3 = DEFAULT_ALLOWED_LENGTHS;
        }
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        int[] nArray4 = nArray3;
        int n4 = nArray3.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray4[n5];
            if (n2 == n6) {
                bl = true;
                break;
            }
            if (n6 > n3) {
                n3 = n6;
            }
            ++n5;
        }
        if (!bl && n2 > n3) {
            bl = true;
        }
        if (!bl) {
            throw FormatException.getFormatInstance();
        }
        return new Result(string, null, new ResultPoint[]{new ResultPoint(nArray[1], n), new ResultPoint(nArray2[0], n)}, BarcodeFormat.ITF);
    }

    private static void decodeMiddle(BitArray bitArray, int n, int n2, StringBuilder stringBuilder) {
        int[] nArray = new int[10];
        int[] nArray2 = new int[5];
        int[] nArray3 = new int[5];
        while (n < n2) {
            int n3;
            ITFReader.recordPattern(bitArray, n, nArray);
            int n4 = 0;
            while (n4 < 5) {
                n3 = 2 * n4;
                nArray2[n4] = nArray[n3];
                nArray3[n4] = nArray[n3 + 1];
                ++n4;
            }
            n4 = ITFReader.decodeDigit(nArray2);
            stringBuilder.append((char)(48 + n4));
            n4 = ITFReader.decodeDigit(nArray3);
            stringBuilder.append((char)(48 + n4));
            int[] nArray4 = nArray;
            int n5 = nArray.length;
            int n6 = 0;
            while (n6 < n5) {
                n3 = nArray4[n6];
                n += n3;
                ++n6;
            }
        }
    }

    private int[] decodeStart(BitArray bitArray) {
        int n = ITFReader.skipWhiteSpace(bitArray);
        int[] nArray = ITFReader.findGuardPattern(bitArray, n, START_PATTERN);
        this.narrowLineWidth = (nArray[1] - nArray[0]) / 4;
        this.validateQuietZone(bitArray, nArray[0]);
        return nArray;
    }

    private void validateQuietZone(BitArray bitArray, int n) {
        int n2 = this.narrowLineWidth * 10;
        n2 = n2 < n ? n2 : n;
        int n3 = n - 1;
        while (n2 > 0 && n3 >= 0) {
            if (bitArray.get(n3)) break;
            --n2;
            --n3;
        }
        if (n2 != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static int skipWhiteSpace(BitArray bitArray) {
        int n = bitArray.getSize();
        int n2 = bitArray.getNextSet(0);
        if (n2 == n) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n2;
    }

    private int[] decodeEnd(BitArray bitArray) {
        bitArray.reverse();
        try {
            int[] nArray;
            int n = ITFReader.skipWhiteSpace(bitArray);
            try {
                nArray = ITFReader.findGuardPattern(bitArray, n, END_PATTERN_REVERSED[0]);
            }
            catch (NotFoundException notFoundException) {
                nArray = ITFReader.findGuardPattern(bitArray, n, END_PATTERN_REVERSED[1]);
            }
            this.validateQuietZone(bitArray, nArray[0]);
            int n2 = nArray[0];
            nArray[0] = bitArray.getSize() - nArray[1];
            nArray[1] = bitArray.getSize() - n2;
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            bitArray.reverse();
        }
    }

    private static int[] findGuardPattern(BitArray bitArray, int n, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = bitArray.getSize();
        boolean bl = false;
        int n4 = 0;
        int n5 = n;
        int n6 = n;
        while (n6 < n3) {
            if (bitArray.get(n6) != bl) {
                int n7 = n4;
                nArray2[n7] = nArray2[n7] + 1;
            } else {
                if (n4 == n2 - 1) {
                    if (ITFReader.patternMatchVariance(nArray2, nArray, 0.5f) < 0.38f) {
                        return new int[]{n5, n6};
                    }
                    n5 += nArray2[0] + nArray2[1];
                    System.arraycopy(nArray2, 2, nArray2, 0, n4 - 1);
                    nArray2[n4 - 1] = 0;
                    nArray2[n4] = 0;
                    --n4;
                } else {
                    ++n4;
                }
                nArray2[n4] = 1;
                bl = !bl;
            }
            ++n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeDigit(int[] nArray) {
        float f2 = 0.38f;
        int n = -1;
        int n2 = PATTERNS.length;
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray2 = PATTERNS[n3];
            float f3 = ITFReader.patternMatchVariance(nArray, nArray2, 0.5f);
            if (f3 < f2) {
                f2 = f3;
                n = n3;
            } else if (f3 == f2) {
                n = -1;
            }
            ++n3;
        }
        if (n >= 0) {
            return n % 10;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

