/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.EncodeHintType;
import oz.util.barcode.Writer;
import oz.util.barcode.common.BitMatrix;

public abstract class OneDimensionalCodeWriter
implements Writer {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Negative size is not allowed. Input: " + n + 'x' + n2);
        }
        int n3 = this.getDefaultMargin();
        if (map != null && map.containsKey((Object)EncodeHintType.MARGIN)) {
            n3 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
        }
        boolean[] blArray = this.encode(string);
        return OneDimensionalCodeWriter.renderResult(blArray, n, n2, n3);
    }

    private static BitMatrix renderResult(boolean[] blArray, int n, int n2, int n3) {
        int n4 = blArray.length;
        int n5 = n4 + n3;
        int n6 = Math.max(n, n5);
        int n7 = Math.max(1, n2);
        int n8 = n6 / n5;
        int n9 = (n6 - n4 * n8) / 2;
        BitMatrix bitMatrix = new BitMatrix(n6, n7);
        int n10 = 0;
        int n11 = n9;
        while (n10 < n4) {
            if (blArray[n10]) {
                bitMatrix.setRegion(n11, 0, n8, n7);
            }
            ++n10;
            n11 += n8;
        }
        return bitMatrix;
    }

    protected static int appendPattern(boolean[] blArray, int n, int[] nArray, boolean bl) {
        boolean bl2 = bl;
        int n2 = 0;
        int[] nArray2 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray2[n4];
            int n6 = 0;
            while (n6 < n5) {
                blArray[n++] = bl2;
                ++n6;
            }
            n2 += n5;
            bl2 = !bl2;
            ++n4;
        }
        return n2;
    }

    public int getDefaultMargin() {
        return 10;
    }

    public abstract boolean[] encode(String var1);
}

