/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.FormatException;
import oz.util.barcode.Result;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.EAN13Reader;
import oz.util.barcode.oned.UPCEANReader;

public final class UPCAReader
extends UPCEANReader {
    private final UPCEANReader ean13Reader = new EAN13Reader();

    @Override
    public Result decodeRow(int n, BitArray bitArray, int[] nArray, Map map) {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(n, bitArray, nArray, map));
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(n, bitArray, map));
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(binaryBitmap));
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map map) {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(binaryBitmap, map));
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.UPC_A;
    }

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) {
        return this.ean13Reader.decodeMiddle(bitArray, nArray, stringBuilder);
    }

    private static Result maybeReturnResult(Result result) {
        String string = result.getText();
        if (string.charAt(0) == '0') {
            Result result2 = new Result(string.substring(1), null, result.getResultPoints(), BarcodeFormat.UPC_A);
            if (result.getResultMetadata() != null) {
                result2.putAllMetadata(result.getResultMetadata());
            }
            return result2;
        }
        throw FormatException.getFormatInstance();
    }
}

