/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417;

import java.util.ArrayList;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.ChecksumException;
import oz.util.barcode.FormatException;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Reader;
import oz.util.barcode.Result;
import oz.util.barcode.ResultMetadataType;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.multi.MultipleBarcodeReader;
import oz.util.barcode.pdf417.PDF417ResultMetadata;
import oz.util.barcode.pdf417.decoder.PDF417ScanningDecoder;
import oz.util.barcode.pdf417.detector.Detector;
import oz.util.barcode.pdf417.detector.PDF417DetectorResult;

public final class PDF417Reader
implements Reader,
MultipleBarcodeReader {
    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map map) {
        Result[] resultArray = PDF417Reader.decode(binaryBitmap, map, false);
        if (resultArray == null || resultArray.length == 0 || resultArray[0] == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        return resultArray[0];
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) {
        return this.decodeMultiple(binaryBitmap, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap, Map map) {
        try {
            return PDF417Reader.decode(binaryBitmap, map, true);
        }
        catch (ChecksumException | FormatException readerException) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static Result[] decode(BinaryBitmap binaryBitmap, Map map, boolean bl) {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        PDF417DetectorResult pDF417DetectorResult = Detector.detect(binaryBitmap, map, bl);
        for (ResultPoint[] resultPointArray : pDF417DetectorResult.getPoints()) {
            DecoderResult decoderResult = PDF417ScanningDecoder.decode(pDF417DetectorResult.getBits(), resultPointArray[4], resultPointArray[5], resultPointArray[6], resultPointArray[7], PDF417Reader.getMinCodewordWidth(resultPointArray), PDF417Reader.getMaxCodewordWidth(resultPointArray));
            Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.PDF_417);
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel());
            PDF417ResultMetadata pDF417ResultMetadata = (PDF417ResultMetadata)decoderResult.getOther();
            if (pDF417ResultMetadata != null) {
                result.putMetadata(ResultMetadataType.PDF417_EXTRA_METADATA, pDF417ResultMetadata);
            }
            arrayList.add(result);
        }
        return arrayList.toArray(new Result[arrayList.size()]);
    }

    private static int getMaxWidth(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint == null || resultPoint2 == null) {
            return 0;
        }
        return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
    }

    private static int getMinWidth(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint == null || resultPoint2 == null) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
    }

    private static int getMaxCodewordWidth(ResultPoint[] resultPointArray) {
        return Math.max(Math.max(PDF417Reader.getMaxWidth(resultPointArray[0], resultPointArray[4]), PDF417Reader.getMaxWidth(resultPointArray[6], resultPointArray[2]) * 17 / 18), Math.max(PDF417Reader.getMaxWidth(resultPointArray[1], resultPointArray[5]), PDF417Reader.getMaxWidth(resultPointArray[7], resultPointArray[3]) * 17 / 18));
    }

    private static int getMinCodewordWidth(ResultPoint[] resultPointArray) {
        return Math.min(Math.min(PDF417Reader.getMinWidth(resultPointArray[0], resultPointArray[4]), PDF417Reader.getMinWidth(resultPointArray[6], resultPointArray[2]) * 17 / 18), Math.min(PDF417Reader.getMinWidth(resultPointArray[1], resultPointArray[5]), PDF417Reader.getMinWidth(resultPointArray[7], resultPointArray[3]) * 17 / 18));
    }

    @Override
    public void reset() {
    }
}

