/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417;

import java.nio.charset.Charset;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.EncodeHintType;
import oz.util.barcode.Writer;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.pdf417.encoder.Compaction;
import oz.util.barcode.pdf417.encoder.Dimensions;
import oz.util.barcode.pdf417.encoder.PDF417;

public final class PDF417Writer
implements Writer {
    private static final int WHITE_SPACE = 30;
    private static final int DEFAULT_ERROR_CORRECTION_LEVEL = 2;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.PDF_417) {
            throw new IllegalArgumentException("Can only encode PDF_417, but got " + (Object)((Object)barcodeFormat));
        }
        PDF417 pDF417 = new PDF417();
        int n3 = 30;
        int n4 = 2;
        int n5 = 1;
        int n6 = 1;
        if (map != null) {
            Object object;
            if (map.containsKey((Object)EncodeHintType.PDF417_COMPACT)) {
                pDF417.setCompact(Boolean.valueOf(map.get((Object)EncodeHintType.PDF417_COMPACT).toString()));
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_COMPACTION)) {
                pDF417.setCompaction(Compaction.valueOf(map.get((Object)EncodeHintType.PDF417_COMPACTION).toString()));
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_DIMENSIONS)) {
                object = (Dimensions)map.get((Object)EncodeHintType.PDF417_DIMENSIONS);
                pDF417.setDimensions(((Dimensions)object).getMaxCols(), ((Dimensions)object).getMinCols(), ((Dimensions)object).getMaxRows(), ((Dimensions)object).getMinRows());
            }
            if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                n3 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
            }
            if (map.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                n4 = Integer.parseInt(map.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (map.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                object = Charset.forName(map.get((Object)EncodeHintType.CHARACTER_SET).toString());
                pDF417.setEncoding((Charset)object);
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_SCALEX)) {
                n5 = Integer.parseInt(map.get((Object)EncodeHintType.PDF417_SCALEX).toString());
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_SCALEY)) {
                n6 = Integer.parseInt(map.get((Object)EncodeHintType.PDF417_SCALEY).toString());
            }
        }
        return PDF417Writer.bitMatrixFromEncoder(pDF417, string, n4, n, n2, n3, n5, n6);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    private static BitMatrix bitMatrixFromEncoder(PDF417 pDF417, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        pDF417.generateBarcodeLogic(string, n);
        int n7 = 1;
        int n8 = 2;
        byte[][] byArray = pDF417.getBarcodeMatrix().getScaledMatrix(n7, n8 * n7);
        boolean bl = false;
        if (n2 == 0) {
            n2 = 30;
        }
        if (n3 == 0) {
            n3 = 30;
        }
        if (n3 > n2 ^ byArray[0].length < byArray.length) {
            byArray = PDF417Writer.rotateArray(byArray);
            bl = true;
        }
        int n9 = n5;
        int n10 = n5 + (n6 - 1);
        if (n9 <= 0) {
            n9 = 1;
        }
        if (n10 <= 0) {
            n10 = 1;
        }
        if (n9 > 1 || n10 > 1) {
            byte[][] byArray2 = pDF417.getBarcodeMatrix().getScaledMatrix(n9, n10 * n8);
            if (bl) {
                byArray2 = PDF417Writer.rotateArray(byArray2);
            }
            return PDF417Writer.bitMatrixFrombitArray(byArray2, n4);
        }
        return PDF417Writer.bitMatrixFrombitArray(byArray, n4);
    }

    private static BitMatrix bitMatrixFrombitArray(byte[][] byArray, int n) {
        BitMatrix bitMatrix = new BitMatrix(byArray[0].length + 2 * n, byArray.length + 2 * n);
        bitMatrix.clear();
        int n2 = 0;
        int n3 = bitMatrix.getHeight() - n - 1;
        while (n2 < byArray.length) {
            byte[] byArray2 = byArray[n2];
            int n4 = 0;
            while (n4 < byArray[0].length) {
                if (byArray2[n4] == 1) {
                    bitMatrix.set(n4 + n, n3);
                }
                ++n4;
            }
            ++n2;
            --n3;
        }
        return bitMatrix;
    }

    private static byte[][] rotateArray(byte[][] byArray) {
        byte[][] byArray2 = new byte[byArray[0].length][byArray.length];
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray.length - n - 1;
            int n3 = 0;
            while (n3 < byArray[0].length) {
                byArray2[n3][n2] = byArray[n][n3];
                ++n3;
            }
            ++n;
        }
        return byArray2;
    }
}

