/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import oz.util.barcode.FormatException;
import oz.util.barcode.common.CharacterSetECI;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.pdf417.PDF417ResultMetadata;
import oz.util.barcode.pdf417.decoder.DecodedBitStreamParser$Mode;

final class DecodedBitStreamParser {
    private static final int TEXT_COMPACTION_MODE_LATCH = 900;
    private static final int BYTE_COMPACTION_MODE_LATCH = 901;
    private static final int NUMERIC_COMPACTION_MODE_LATCH = 902;
    private static final int BYTE_COMPACTION_MODE_LATCH_6 = 924;
    private static final int ECI_USER_DEFINED = 925;
    private static final int ECI_GENERAL_PURPOSE = 926;
    private static final int ECI_CHARSET = 927;
    private static final int BEGIN_MACRO_PDF417_CONTROL_BLOCK = 928;
    private static final int BEGIN_MACRO_PDF417_OPTIONAL_FIELD = 923;
    private static final int MACRO_PDF417_TERMINATOR = 922;
    private static final int MODE_SHIFT_TO_BYTE_COMPACTION_MODE = 913;
    private static final int MAX_NUMERIC_CODEWORDS = 15;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_FILE_NAME = 0;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_SEGMENT_COUNT = 1;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_TIME_STAMP = 2;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_SENDER = 3;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_ADDRESSEE = 4;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_FILE_SIZE = 5;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_CHECKSUM = 6;
    private static final int PL = 25;
    private static final int LL = 27;
    private static final int AS = 27;
    private static final int ML = 28;
    private static final int AL = 28;
    private static final int PS = 29;
    private static final int PAL = 29;
    private static final char[] PUNCT_CHARS;
    private static final char[] MIXED_CHARS;
    private static final BigInteger[] EXP900;
    private static final int NUMBER_OF_SEQUENCE_CODEWORDS = 2;

    static {
        BigInteger bigInteger;
        PUNCT_CHARS = ";<>@[\\]_`~!\r\t,:\n-.$/\"|*()?{}'".toCharArray();
        MIXED_CHARS = "0123456789&\r\t,:#-.$/+%*=^".toCharArray();
        EXP900 = new BigInteger[16];
        DecodedBitStreamParser.EXP900[0] = BigInteger.ONE;
        DecodedBitStreamParser.EXP900[1] = bigInteger = BigInteger.valueOf(900L);
        int n = 2;
        while (n < EXP900.length) {
            DecodedBitStreamParser.EXP900[n] = EXP900[n - 1].multiply(bigInteger);
            ++n;
        }
    }

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(int[] nArray, String string) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 2);
        Charset charset = StandardCharsets.ISO_8859_1;
        int n = 1;
        int n2 = nArray[n++];
        PDF417ResultMetadata pDF417ResultMetadata = new PDF417ResultMetadata();
        while (n < nArray[0]) {
            switch (n2) {
                case 900: {
                    n = DecodedBitStreamParser.textCompaction(nArray, n, stringBuilder);
                    break;
                }
                case 901: 
                case 924: {
                    n = DecodedBitStreamParser.byteCompaction(n2, nArray, charset, n, stringBuilder);
                    break;
                }
                case 913: {
                    stringBuilder.append((char)nArray[n++]);
                    break;
                }
                case 902: {
                    n = DecodedBitStreamParser.numericCompaction(nArray, n, stringBuilder);
                    break;
                }
                case 927: {
                    object = CharacterSetECI.getCharacterSetECIByValue(nArray[n++]);
                    charset = Charset.forName(((Enum)object).name());
                    break;
                }
                case 926: {
                    n += 2;
                    break;
                }
                case 925: {
                    ++n;
                    break;
                }
                case 928: {
                    n = DecodedBitStreamParser.decodeMacroBlock(nArray, n, pDF417ResultMetadata);
                    break;
                }
                case 922: 
                case 923: {
                    throw FormatException.getFormatInstance();
                }
                default: {
                    --n;
                    n = DecodedBitStreamParser.textCompaction(nArray, n, stringBuilder);
                }
            }
            if (n < nArray.length) {
                n2 = nArray[n++];
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        if (stringBuilder.length() == 0) {
            throw FormatException.getFormatInstance();
        }
        object = new DecoderResult(null, stringBuilder.toString(), null, string);
        ((DecoderResult)object).setOther(pDF417ResultMetadata);
        return object;
    }

    static int decodeMacroBlock(int[] nArray, int n, PDF417ResultMetadata pDF417ResultMetadata) {
        if (n + 2 > nArray[0]) {
            throw FormatException.getFormatInstance();
        }
        int[] nArray2 = new int[2];
        int n2 = 0;
        while (n2 < 2) {
            nArray2[n2] = nArray[n];
            ++n2;
            ++n;
        }
        pDF417ResultMetadata.setSegmentIndex(Integer.parseInt(DecodedBitStreamParser.decodeBase900toBase10(nArray2, 2)));
        StringBuilder stringBuilder = new StringBuilder();
        n = DecodedBitStreamParser.textCompaction(nArray, n, stringBuilder);
        pDF417ResultMetadata.setFileId(stringBuilder.toString());
        int n3 = -1;
        if (nArray[n] == 923) {
            n3 = n + 1;
        }
        while (n < nArray[0]) {
            block0 : switch (nArray[n]) {
                case 923: {
                    switch (nArray[++n]) {
                        case 0: {
                            StringBuilder stringBuilder2 = new StringBuilder();
                            n = DecodedBitStreamParser.textCompaction(nArray, n + 1, stringBuilder2);
                            pDF417ResultMetadata.setFileName(stringBuilder2.toString());
                            break block0;
                        }
                        case 3: {
                            StringBuilder stringBuilder3 = new StringBuilder();
                            n = DecodedBitStreamParser.textCompaction(nArray, n + 1, stringBuilder3);
                            pDF417ResultMetadata.setSender(stringBuilder3.toString());
                            break block0;
                        }
                        case 4: {
                            StringBuilder stringBuilder4 = new StringBuilder();
                            n = DecodedBitStreamParser.textCompaction(nArray, n + 1, stringBuilder4);
                            pDF417ResultMetadata.setAddressee(stringBuilder4.toString());
                            break block0;
                        }
                        case 1: {
                            StringBuilder stringBuilder5 = new StringBuilder();
                            n = DecodedBitStreamParser.numericCompaction(nArray, n + 1, stringBuilder5);
                            pDF417ResultMetadata.setSegmentCount(Integer.parseInt(stringBuilder5.toString()));
                            break block0;
                        }
                        case 2: {
                            StringBuilder stringBuilder6 = new StringBuilder();
                            n = DecodedBitStreamParser.numericCompaction(nArray, n + 1, stringBuilder6);
                            pDF417ResultMetadata.setTimestamp(Long.parseLong(stringBuilder6.toString()));
                            break block0;
                        }
                        case 6: {
                            StringBuilder stringBuilder7 = new StringBuilder();
                            n = DecodedBitStreamParser.numericCompaction(nArray, n + 1, stringBuilder7);
                            pDF417ResultMetadata.setChecksum(Integer.parseInt(stringBuilder7.toString()));
                            break block0;
                        }
                        case 5: {
                            StringBuilder stringBuilder8 = new StringBuilder();
                            n = DecodedBitStreamParser.numericCompaction(nArray, n + 1, stringBuilder8);
                            pDF417ResultMetadata.setFileSize(Long.parseLong(stringBuilder8.toString()));
                            break block0;
                        }
                    }
                    throw FormatException.getFormatInstance();
                }
                case 922: {
                    ++n;
                    pDF417ResultMetadata.setLastSegment(true);
                    break;
                }
                default: {
                    throw FormatException.getFormatInstance();
                }
            }
        }
        if (n3 != -1) {
            int n4 = n - n3;
            if (pDF417ResultMetadata.isLastSegment()) {
                --n4;
            }
            pDF417ResultMetadata.setOptionalData(Arrays.copyOfRange(nArray, n3, n3 + n4));
        }
        return n;
    }

    private static int textCompaction(int[] nArray, int n, StringBuilder stringBuilder) {
        int[] nArray2 = new int[(nArray[0] - n) * 2];
        int[] nArray3 = new int[(nArray[0] - n) * 2];
        int n2 = 0;
        boolean bl = false;
        while (n < nArray[0] && !bl) {
            int n3;
            if ((n3 = nArray[n++]) < 900) {
                nArray2[n2] = n3 / 30;
                nArray2[n2 + 1] = n3 % 30;
                n2 += 2;
                continue;
            }
            switch (n3) {
                case 900: {
                    nArray2[n2++] = 900;
                    break;
                }
                case 901: 
                case 902: 
                case 922: 
                case 923: 
                case 924: 
                case 928: {
                    --n;
                    bl = true;
                    break;
                }
                case 913: {
                    nArray2[n2] = 913;
                    nArray3[n2] = n3 = nArray[n++];
                    ++n2;
                }
            }
        }
        DecodedBitStreamParser.decodeTextCompaction(nArray2, nArray3, n2, stringBuilder);
        return n;
    }

    private static void decodeTextCompaction(int[] nArray, int[] nArray2, int n, StringBuilder stringBuilder) {
        DecodedBitStreamParser$Mode decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
        DecodedBitStreamParser$Mode decodedBitStreamParser$Mode2 = DecodedBitStreamParser$Mode.ALPHA;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            int n4 = 0;
            block0 : switch (decodedBitStreamParser$Mode) {
                case ALPHA: {
                    if (n3 < 26) {
                        n4 = (char)(65 + n3);
                        break;
                    }
                    switch (n3) {
                        case 26: {
                            n4 = 32;
                            break;
                        }
                        case 27: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.LOWER;
                            break;
                        }
                        case 28: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.MIXED;
                            break;
                        }
                        case 29: {
                            decodedBitStreamParser$Mode2 = decodedBitStreamParser$Mode;
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.PUNCT_SHIFT;
                            break;
                        }
                        case 913: {
                            stringBuilder.append((char)nArray2[n2]);
                            break;
                        }
                        case 900: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
                        }
                    }
                    break;
                }
                case LOWER: {
                    if (n3 < 26) {
                        n4 = (char)(97 + n3);
                        break;
                    }
                    switch (n3) {
                        case 26: {
                            n4 = 32;
                            break;
                        }
                        case 27: {
                            decodedBitStreamParser$Mode2 = decodedBitStreamParser$Mode;
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA_SHIFT;
                            break;
                        }
                        case 28: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.MIXED;
                            break;
                        }
                        case 29: {
                            decodedBitStreamParser$Mode2 = decodedBitStreamParser$Mode;
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.PUNCT_SHIFT;
                            break;
                        }
                        case 913: {
                            stringBuilder.append((char)nArray2[n2]);
                            break;
                        }
                        case 900: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
                        }
                    }
                    break;
                }
                case MIXED: {
                    if (n3 < 25) {
                        n4 = MIXED_CHARS[n3];
                        break;
                    }
                    switch (n3) {
                        case 25: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.PUNCT;
                            break;
                        }
                        case 26: {
                            n4 = 32;
                            break;
                        }
                        case 27: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.LOWER;
                            break;
                        }
                        case 28: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
                            break;
                        }
                        case 29: {
                            decodedBitStreamParser$Mode2 = decodedBitStreamParser$Mode;
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.PUNCT_SHIFT;
                            break;
                        }
                        case 913: {
                            stringBuilder.append((char)nArray2[n2]);
                            break;
                        }
                        case 900: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
                        }
                    }
                    break;
                }
                case PUNCT: {
                    if (n3 < 29) {
                        n4 = PUNCT_CHARS[n3];
                        break;
                    }
                    switch (n3) {
                        case 29: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
                            break;
                        }
                        case 913: {
                            stringBuilder.append((char)nArray2[n2]);
                            break;
                        }
                        case 900: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
                        }
                    }
                    break;
                }
                case ALPHA_SHIFT: {
                    decodedBitStreamParser$Mode = decodedBitStreamParser$Mode2;
                    if (n3 < 26) {
                        n4 = (char)(65 + n3);
                        break;
                    }
                    switch (n3) {
                        case 26: {
                            n4 = 32;
                            break;
                        }
                        case 900: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
                        }
                    }
                    break;
                }
                case PUNCT_SHIFT: {
                    decodedBitStreamParser$Mode = decodedBitStreamParser$Mode2;
                    if (n3 < 29) {
                        n4 = PUNCT_CHARS[n3];
                        break;
                    }
                    switch (n3) {
                        case 29: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
                            break block0;
                        }
                        case 913: {
                            stringBuilder.append((char)nArray2[n2]);
                            break block0;
                        }
                        case 900: {
                            decodedBitStreamParser$Mode = DecodedBitStreamParser$Mode.ALPHA;
                        }
                    }
                }
            }
            if (n4 != 0) {
                stringBuilder.append((char)n4);
            }
            ++n2;
        }
    }

    private static int byteCompaction(int n, int[] nArray, Charset charset, int n2, StringBuilder stringBuilder) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        long l = 0L;
        boolean bl = false;
        switch (n) {
            case 901: {
                int n4;
                int[] nArray2 = new int[6];
                int n5 = nArray[n2++];
                block10: while (n2 < nArray[0] && !bl) {
                    nArray2[n3++] = n5;
                    l = 900L * l + (long)n5;
                    n5 = nArray[n2++];
                    switch (n5) {
                        case 900: 
                        case 901: 
                        case 902: 
                        case 922: 
                        case 923: 
                        case 924: 
                        case 928: {
                            --n2;
                            bl = true;
                            break;
                        }
                        default: {
                            if (n3 % 5 != 0 || n3 <= 0) continue block10;
                            n4 = 0;
                            while (n4 < 6) {
                                byteArrayOutputStream.write((byte)(l >> 8 * (5 - n4)));
                                ++n4;
                            }
                            l = 0L;
                            n3 = 0;
                        }
                    }
                }
                if (n2 == nArray[0] && n5 < 900) {
                    nArray2[n3++] = n5;
                }
                n4 = 0;
                while (n4 < n3) {
                    byteArrayOutputStream.write((byte)nArray2[n4]);
                    ++n4;
                }
                break;
            }
            case 924: {
                while (n2 < nArray[0] && !bl) {
                    int n6;
                    if ((n6 = nArray[n2++]) < 900) {
                        ++n3;
                        l = 900L * l + (long)n6;
                    } else {
                        switch (n6) {
                            case 900: 
                            case 901: 
                            case 902: 
                            case 922: 
                            case 923: 
                            case 924: 
                            case 928: {
                                --n2;
                                bl = true;
                            }
                        }
                    }
                    if (n3 % 5 != 0 || n3 <= 0) continue;
                    int n7 = 0;
                    while (n7 < 6) {
                        byteArrayOutputStream.write((byte)(l >> 8 * (5 - n7)));
                        ++n7;
                    }
                    l = 0L;
                    n3 = 0;
                }
                break;
            }
        }
        stringBuilder.append(new String(byteArrayOutputStream.toByteArray(), charset));
        return n2;
    }

    private static int numericCompaction(int[] nArray, int n, StringBuilder stringBuilder) {
        int n2 = 0;
        boolean bl = false;
        int[] nArray2 = new int[15];
        while (n < nArray[0] && !bl) {
            int n3 = nArray[n++];
            if (n == nArray[0]) {
                bl = true;
            }
            if (n3 < 900) {
                nArray2[n2] = n3;
                ++n2;
            } else {
                switch (n3) {
                    case 900: 
                    case 901: 
                    case 922: 
                    case 923: 
                    case 924: 
                    case 928: {
                        --n;
                        bl = true;
                    }
                }
            }
            if (n2 % 15 != 0 && n3 != 902 && !bl || n2 <= 0) continue;
            stringBuilder.append(DecodedBitStreamParser.decodeBase900toBase10(nArray2, n2));
            n2 = 0;
        }
        return n;
    }

    private static String decodeBase900toBase10(int[] nArray, int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n2 = 0;
        while (n2 < n) {
            bigInteger = bigInteger.add(EXP900[n - n2 - 1].multiply(BigInteger.valueOf(nArray[n2])));
            ++n2;
        }
        String string = bigInteger.toString();
        if (string.charAt(0) != '1') {
            throw FormatException.getFormatInstance();
        }
        return string.substring(1);
    }
}

