/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder;

import oz.util.barcode.common.detector.MathUtils;
import oz.util.barcode.pdf417.PDF417Common;

final class PDF417CodewordDecoder {
    private static final float[][] RATIOS_TABLE = new float[PDF417Common.SYMBOL_TABLE.length][8];

    static {
        int n = 0;
        while (n < PDF417Common.SYMBOL_TABLE.length) {
            int n2 = PDF417Common.SYMBOL_TABLE[n];
            int n3 = n2 & 1;
            int n4 = 0;
            while (n4 < 8) {
                float f2 = 0.0f;
                while ((n2 & 1) == n3) {
                    f2 += 1.0f;
                    n2 >>= 1;
                }
                n3 = n2 & 1;
                PDF417CodewordDecoder.RATIOS_TABLE[n][8 - n4 - 1] = f2 / 17.0f;
                ++n4;
            }
            ++n;
        }
    }

    private PDF417CodewordDecoder() {
    }

    static int getDecodedValue(int[] nArray) {
        int n = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(nArray));
        if (n != -1) {
            return n;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(nArray);
    }

    private static int[] sampleBitCounts(int[] nArray) {
        float f2 = MathUtils.sum(nArray);
        int[] nArray2 = new int[8];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 17) {
            float f3 = f2 / 34.0f + (float)n3 * f2 / 17.0f;
            if ((float)(n2 + nArray[n]) <= f3) {
                n2 += nArray[n];
            }
            int n4 = ++n;
            nArray2[n4] = nArray2[n4] + 1;
            ++n3;
        }
        return nArray2;
    }

    private static int getDecodedCodewordValue(int[] nArray) {
        int n = PDF417CodewordDecoder.getBitValue(nArray);
        return PDF417Common.getCodeword(n) == -1 ? -1 : n;
    }

    private static int getBitValue(int[] nArray) {
        long l = 0L;
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n]) {
                l = l << 1 | (long)(n % 2 == 0 ? 1 : 0);
                ++n2;
            }
            ++n;
        }
        return (int)l;
    }

    private static int getClosestDecodedValue(int[] nArray) {
        int n = MathUtils.sum(nArray);
        float[] fArray = new float[8];
        if (n > 1) {
            int n2 = 0;
            while (n2 < fArray.length) {
                fArray[n2] = (float)nArray[n2] / (float)n;
                ++n2;
            }
        }
        float f2 = Float.MAX_VALUE;
        int n3 = -1;
        int n4 = 0;
        while (n4 < RATIOS_TABLE.length) {
            float f3 = 0.0f;
            float[] fArray2 = RATIOS_TABLE[n4];
            int n5 = 0;
            while (n5 < 8) {
                float f4 = fArray2[n5] - fArray[n5];
                if ((f3 += f4 * f4) >= f2) break;
                ++n5;
            }
            if (f3 < f2) {
                f2 = f3;
                n3 = PDF417Common.SYMBOL_TABLE[n4];
            }
            ++n4;
        }
        return n3;
    }
}

