/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.detector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.pdf417.detector.PDF417DetectorResult;

public final class Detector {
    private static final int[] INDEXES_START_PATTERN;
    private static final int[] INDEXES_STOP_PATTERN;
    private static final float MAX_AVG_VARIANCE = 0.42f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.8f;
    private static final int[] START_PATTERN;
    private static final int[] STOP_PATTERN;
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int ROW_STEP = 5;
    private static final int BARCODE_MIN_HEIGHT = 10;

    static {
        int[] nArray = new int[4];
        nArray[1] = 4;
        nArray[2] = 1;
        nArray[3] = 5;
        INDEXES_START_PATTERN = nArray;
        INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
        START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
        STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    }

    private Detector() {
    }

    public static PDF417DetectorResult detect(BinaryBitmap binaryBitmap, Map map, boolean bl) {
        BitMatrix bitMatrix = binaryBitmap.getBlackMatrix();
        List list = Detector.detect(bl, bitMatrix);
        if (list.isEmpty()) {
            bitMatrix = bitMatrix.clone();
            bitMatrix.rotate180();
            list = Detector.detect(bl, bitMatrix);
        }
        return new PDF417DetectorResult(bitMatrix, list);
    }

    private static List detect(boolean bl, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> arrayList = new ArrayList<ResultPoint[]>();
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        while (n < bitMatrix.getHeight()) {
            ResultPoint[] resultPointArray = Detector.findVertices(bitMatrix, n, n2);
            if (resultPointArray[0] == null && resultPointArray[3] == null) {
                if (!bl2) break;
                bl2 = false;
                n2 = 0;
                for (ResultPoint[] resultPointArray2 : arrayList) {
                    if (resultPointArray2[1] != null) {
                        n = (int)Math.max((float)n, resultPointArray2[1].getY());
                    }
                    if (resultPointArray2[3] == null) continue;
                    n = Math.max(n, (int)resultPointArray2[3].getY());
                }
                n += 5;
                continue;
            }
            bl2 = true;
            arrayList.add(resultPointArray);
            if (!bl) break;
            if (resultPointArray[2] != null) {
                n2 = (int)resultPointArray[2].getX();
                n = (int)resultPointArray[2].getY();
                continue;
            }
            n2 = (int)resultPointArray[4].getX();
            n = (int)resultPointArray[4].getY();
        }
        return arrayList;
    }

    private static ResultPoint[] findVertices(BitMatrix bitMatrix, int n, int n2) {
        int n3 = bitMatrix.getHeight();
        int n4 = bitMatrix.getWidth();
        ResultPoint[] resultPointArray = new ResultPoint[8];
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix, n3, n4, n, n2, START_PATTERN), INDEXES_START_PATTERN);
        if (resultPointArray[4] != null) {
            n2 = (int)resultPointArray[4].getX();
            n = (int)resultPointArray[4].getY();
        }
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix, n3, n4, n, n2, STOP_PATTERN), INDEXES_STOP_PATTERN);
        return resultPointArray;
    }

    private static void copyToResult(ResultPoint[] resultPointArray, ResultPoint[] resultPointArray2, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            resultPointArray[nArray[n]] = resultPointArray2[n];
            ++n;
        }
    }

    private static ResultPoint[] findRowsWithPattern(BitMatrix bitMatrix, int n, int n2, int n3, int n4, int[] nArray) {
        Object[] objectArray = new ResultPoint[4];
        boolean bl = false;
        int[] nArray2 = new int[nArray.length];
        while (n3 < n) {
            int[] nArray3 = Detector.findGuardPattern(bitMatrix, n4, n3, n2, false, nArray, nArray2);
            if (nArray3 != null) {
                while (n3 > 0) {
                    int[] nArray4;
                    if ((nArray4 = Detector.findGuardPattern(bitMatrix, n4, --n3, n2, false, nArray, nArray2)) != null) {
                        nArray3 = nArray4;
                        continue;
                    }
                    ++n3;
                    break;
                }
                objectArray[0] = new ResultPoint(nArray3[0], n3);
                objectArray[1] = new ResultPoint(nArray3[1], n3);
                bl = true;
                break;
            }
            n3 += 5;
        }
        int n5 = n3 + 1;
        if (bl) {
            int n6 = 0;
            int[] nArray5 = new int[]{(int)((ResultPoint)objectArray[0]).getX(), (int)((ResultPoint)objectArray[1]).getX()};
            while (n5 < n) {
                int[] nArray6 = Detector.findGuardPattern(bitMatrix, nArray5[0], n5, n2, false, nArray, nArray2);
                if (nArray6 != null && Math.abs(nArray5[0] - nArray6[0]) < 5 && Math.abs(nArray5[1] - nArray6[1]) < 5) {
                    nArray5 = nArray6;
                    n6 = 0;
                } else {
                    if (n6 > 25) break;
                    ++n6;
                }
                ++n5;
            }
            objectArray[2] = new ResultPoint(nArray5[0], n5 -= n6 + 1);
            objectArray[3] = new ResultPoint(nArray5[1], n5);
        }
        if (n5 - n3 < 10) {
            Arrays.fill(objectArray, null);
        }
        return objectArray;
    }

    private static int[] findGuardPattern(BitMatrix bitMatrix, int n, int n2, int n3, boolean bl, int[] nArray, int[] nArray2) {
        Arrays.fill(nArray2, 0, nArray2.length, 0);
        int n4 = n;
        int n5 = 0;
        while (bitMatrix.get(n4, n2) && n4 > 0 && n5++ < 3) {
            --n4;
        }
        int n6 = n4;
        int n7 = 0;
        int n8 = nArray.length;
        boolean bl2 = bl;
        while (n6 < n3) {
            boolean bl3 = bitMatrix.get(n6, n2);
            if (bl3 != bl2) {
                int n9 = n7;
                nArray2[n9] = nArray2[n9] + 1;
            } else {
                if (n7 == n8 - 1) {
                    if (Detector.patternMatchVariance(nArray2, nArray, 0.8f) < 0.42f) {
                        return new int[]{n4, n6};
                    }
                    n4 += nArray2[0] + nArray2[1];
                    System.arraycopy(nArray2, 2, nArray2, 0, n7 - 1);
                    nArray2[n7 - 1] = 0;
                    nArray2[n7] = 0;
                    --n7;
                } else {
                    ++n7;
                }
                nArray2[n7] = 1;
                bl2 = !bl2;
            }
            ++n6;
        }
        if (n7 == n8 - 1 && Detector.patternMatchVariance(nArray2, nArray, 0.8f) < 0.42f) {
            return new int[]{n4, n6 - 1};
        }
        return null;
    }

    private static float patternMatchVariance(int[] nArray, int[] nArray2, float f2) {
        int n = nArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n2 += nArray[n4];
            n3 += nArray2[n4];
            ++n4;
        }
        if (n2 < n3) {
            return Float.POSITIVE_INFINITY;
        }
        float f3 = (float)n2 / (float)n3;
        f2 *= f3;
        float f4 = 0.0f;
        int n5 = 0;
        while (n5 < n) {
            float f5;
            int n6 = nArray[n5];
            float f6 = (float)nArray2[n5] * f3;
            float f7 = f5 = (float)n6 > f6 ? (float)n6 - f6 : f6 - (float)n6;
            if (f5 > f2) {
                return Float.POSITIVE_INFINITY;
            }
            f4 += f5;
            ++n5;
        }
        return f4 / (float)n2;
    }
}

