/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.encoder;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import oz.util.barcode.WriterException;
import oz.util.barcode.common.CharacterSetECI;
import oz.util.barcode.pdf417.encoder.Compaction;

final class PDF417HighLevelEncoder {
    private static final int TEXT_COMPACTION = 0;
    private static final int BYTE_COMPACTION = 1;
    private static final int NUMERIC_COMPACTION = 2;
    private static final int SUBMODE_ALPHA = 0;
    private static final int SUBMODE_LOWER = 1;
    private static final int SUBMODE_MIXED = 2;
    private static final int SUBMODE_PUNCTUATION = 3;
    private static final int LATCH_TO_TEXT = 900;
    private static final int LATCH_TO_BYTE_PADDED = 901;
    private static final int LATCH_TO_NUMERIC = 902;
    private static final int SHIFT_TO_BYTE = 913;
    private static final int LATCH_TO_BYTE = 924;
    private static final int ECI_USER_DEFINED = 925;
    private static final int ECI_GENERAL_PURPOSE = 926;
    private static final int ECI_CHARSET = 927;
    private static final byte[] TEXT_MIXED_RAW;
    private static final byte[] TEXT_PUNCTUATION_RAW;
    private static final byte[] MIXED;
    private static final byte[] PUNCTUATION;
    private static final Charset DEFAULT_ENCODING;

    static {
        byte by;
        byte[] byArray = new byte[30];
        byArray[0] = 48;
        byArray[1] = 49;
        byArray[2] = 50;
        byArray[3] = 51;
        byArray[4] = 52;
        byArray[5] = 53;
        byArray[6] = 54;
        byArray[7] = 55;
        byArray[8] = 56;
        byArray[9] = 57;
        byArray[10] = 38;
        byArray[11] = 13;
        byArray[12] = 9;
        byArray[13] = 44;
        byArray[14] = 58;
        byArray[15] = 35;
        byArray[16] = 45;
        byArray[17] = 46;
        byArray[18] = 36;
        byArray[19] = 47;
        byArray[20] = 43;
        byArray[21] = 37;
        byArray[22] = 42;
        byArray[23] = 61;
        byArray[24] = 94;
        byArray[26] = 32;
        TEXT_MIXED_RAW = byArray;
        byte[] byArray2 = new byte[30];
        byArray2[0] = 59;
        byArray2[1] = 60;
        byArray2[2] = 62;
        byArray2[3] = 64;
        byArray2[4] = 91;
        byArray2[5] = 92;
        byArray2[6] = 93;
        byArray2[7] = 95;
        byArray2[8] = 96;
        byArray2[9] = 126;
        byArray2[10] = 33;
        byArray2[11] = 13;
        byArray2[12] = 9;
        byArray2[13] = 44;
        byArray2[14] = 58;
        byArray2[15] = 10;
        byArray2[16] = 45;
        byArray2[17] = 46;
        byArray2[18] = 36;
        byArray2[19] = 47;
        byArray2[20] = 34;
        byArray2[21] = 124;
        byArray2[22] = 42;
        byArray2[23] = 40;
        byArray2[24] = 41;
        byArray2[25] = 63;
        byArray2[26] = 123;
        byArray2[27] = 125;
        byArray2[28] = 39;
        TEXT_PUNCTUATION_RAW = byArray2;
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        DEFAULT_ENCODING = StandardCharsets.ISO_8859_1;
        Arrays.fill(MIXED, (byte)-1);
        int n = 0;
        while (n < TEXT_MIXED_RAW.length) {
            by = TEXT_MIXED_RAW[n];
            if (by > 0) {
                PDF417HighLevelEncoder.MIXED[by] = (byte)n;
            }
            ++n;
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        n = 0;
        while (n < TEXT_PUNCTUATION_RAW.length) {
            by = TEXT_PUNCTUATION_RAW[n];
            if (by > 0) {
                PDF417HighLevelEncoder.PUNCTUATION[by] = (byte)n;
            }
            ++n;
        }
    }

    private PDF417HighLevelEncoder() {
    }

    static String encodeHighLevel(String string, Compaction compaction, Charset charset) {
        CharacterSetECI characterSetECI;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        if (charset == null) {
            charset = DEFAULT_ENCODING;
        } else if (!DEFAULT_ENCODING.equals(charset) && (characterSetECI = CharacterSetECI.getCharacterSetECIByName(charset.name())) != null) {
            PDF417HighLevelEncoder.encodingECI(characterSetECI.getValue(), stringBuilder);
        }
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        switch (compaction) {
            case TEXT: {
                PDF417HighLevelEncoder.encodeText(string, n2, n, stringBuilder, n3);
                break;
            }
            case BYTE: {
                byte[] byArray = string.getBytes(charset);
                PDF417HighLevelEncoder.encodeBinary(byArray, n2, byArray.length, 1, stringBuilder);
                break;
            }
            case NUMERIC: {
                stringBuilder.append('\u0386');
                PDF417HighLevelEncoder.encodeNumeric(string, n2, n, stringBuilder);
                break;
            }
            default: {
                int n4 = 0;
                while (n2 < n) {
                    byte[] byArray;
                    int n5 = PDF417HighLevelEncoder.determineConsecutiveDigitCount(string, n2);
                    if (n5 >= 13) {
                        stringBuilder.append('\u0386');
                        n4 = 2;
                        n3 = 0;
                        PDF417HighLevelEncoder.encodeNumeric(string, n2, n5, stringBuilder);
                        n2 += n5;
                        continue;
                    }
                    int n6 = PDF417HighLevelEncoder.determineConsecutiveTextCount(string, n2);
                    if (n6 >= 5 || n5 == n) {
                        if (n4 != 0) {
                            stringBuilder.append('\u0384');
                            n4 = 0;
                            n3 = 0;
                        }
                        n3 = PDF417HighLevelEncoder.encodeText(string, n2, n6, stringBuilder, n3);
                        n2 += n6;
                        continue;
                    }
                    int n7 = PDF417HighLevelEncoder.determineConsecutiveBinaryCount(string, n2, charset);
                    if (n7 == 0) {
                        n7 = 1;
                    }
                    if ((byArray = string.substring(n2, n2 + n7).getBytes(charset)).length == 1 && n4 == 0) {
                        PDF417HighLevelEncoder.encodeBinary(byArray, 0, 1, 0, stringBuilder);
                    } else {
                        PDF417HighLevelEncoder.encodeBinary(byArray, 0, byArray.length, n4, stringBuilder);
                        n4 = 1;
                        n3 = 0;
                    }
                    n2 += n7;
                }
                break block0;
            }
        }
        return stringBuilder.toString();
    }

    private static int encodeText(CharSequence charSequence, int n, int n2, StringBuilder stringBuilder, int n3) {
        int n4;
        char c2;
        StringBuilder stringBuilder2 = new StringBuilder(n2);
        int n5 = n3;
        int n6 = 0;
        block5: while (true) {
            c2 = charSequence.charAt(n + n6);
            switch (n5) {
                case 0: {
                    if (PDF417HighLevelEncoder.isAlphaUpper(c2)) {
                        if (c2 == ' ') {
                            stringBuilder2.append('\u001a');
                            break;
                        }
                        stringBuilder2.append((char)(c2 - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c2)) {
                        n5 = 1;
                        stringBuilder2.append('\u001b');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c2)) {
                        n5 = 2;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)PUNCTUATION[c2]);
                    break;
                }
                case 1: {
                    if (PDF417HighLevelEncoder.isAlphaLower(c2)) {
                        if (c2 == ' ') {
                            stringBuilder2.append('\u001a');
                            break;
                        }
                        stringBuilder2.append((char)(c2 - 97));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(c2)) {
                        stringBuilder2.append('\u001b');
                        stringBuilder2.append((char)(c2 - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c2)) {
                        n5 = 2;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)PUNCTUATION[c2]);
                    break;
                }
                case 2: {
                    if (PDF417HighLevelEncoder.isMixed(c2)) {
                        stringBuilder2.append((char)MIXED[c2]);
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(c2)) {
                        n5 = 0;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c2)) {
                        n5 = 1;
                        stringBuilder2.append('\u001b');
                        continue block5;
                    }
                    if (n + n6 + 1 < n2 && PDF417HighLevelEncoder.isPunctuation((char)(n4 = (int)charSequence.charAt(n + n6 + 1)))) {
                        n5 = 3;
                        stringBuilder2.append('\u0019');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)PUNCTUATION[c2]);
                    break;
                }
                default: {
                    if (PDF417HighLevelEncoder.isPunctuation(c2)) {
                        stringBuilder2.append((char)PUNCTUATION[c2]);
                        break;
                    }
                    n5 = 0;
                    stringBuilder2.append('\u001d');
                    continue block5;
                }
            }
            if (++n6 >= n2) break;
        }
        c2 = '\u0000';
        n4 = stringBuilder2.length();
        int n7 = 0;
        while (n7 < n4) {
            boolean bl;
            boolean bl2 = bl = n7 % 2 != 0;
            if (bl) {
                c2 = (char)(c2 * 30 + stringBuilder2.charAt(n7));
                stringBuilder.append(c2);
            } else {
                c2 = stringBuilder2.charAt(n7);
            }
            ++n7;
        }
        if (n4 % 2 != 0) {
            stringBuilder.append((char)(c2 * 30 + 29));
        }
        return n5;
    }

    private static void encodeBinary(byte[] byArray, int n, int n2, int n3, StringBuilder stringBuilder) {
        if (n2 == 1 && n3 == 0) {
            stringBuilder.append('\u0391');
        } else if (n2 % 6 == 0) {
            stringBuilder.append('\u039c');
        } else {
            stringBuilder.append('\u0385');
        }
        int n4 = n;
        if (n2 >= 6) {
            char[] cArray = new char[5];
            while (n + n2 - n4 >= 6) {
                long l = 0L;
                int n5 = 0;
                while (n5 < 6) {
                    l <<= 8;
                    l += (long)(byArray[n4 + n5] & 0xFF);
                    ++n5;
                }
                n5 = 0;
                while (n5 < 5) {
                    cArray[n5] = (char)(l % 900L);
                    l /= 900L;
                    ++n5;
                }
                n5 = cArray.length - 1;
                while (n5 >= 0) {
                    stringBuilder.append(cArray[n5]);
                    --n5;
                }
                n4 += 6;
            }
        }
        int n6 = n4;
        while (n6 < n + n2) {
            int n7 = byArray[n6] & 0xFF;
            stringBuilder.append((char)n7);
            ++n6;
        }
    }

    private static void encodeNumeric(String string, int n, int n2, StringBuilder stringBuilder) {
        int n3 = 0;
        StringBuilder stringBuilder2 = new StringBuilder(n2 / 3 + 1);
        BigInteger bigInteger = BigInteger.valueOf(900L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        while (n3 < n2) {
            stringBuilder2.setLength(0);
            int n4 = Math.min(44, n2 - n3);
            String string2 = String.valueOf('1') + string.substring(n + n3, n + n3 + n4);
            BigInteger bigInteger3 = new BigInteger(string2);
            do {
                stringBuilder2.append((char)bigInteger3.mod(bigInteger).intValue());
            } while (!(bigInteger3 = bigInteger3.divide(bigInteger)).equals(bigInteger2));
            int n5 = stringBuilder2.length() - 1;
            while (n5 >= 0) {
                stringBuilder.append(stringBuilder2.charAt(n5));
                --n5;
            }
            n3 += n4;
        }
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isAlphaUpper(char c2) {
        return c2 == ' ' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isAlphaLower(char c2) {
        return c2 == ' ' || c2 >= 'a' && c2 <= 'z';
    }

    private static boolean isMixed(char c2) {
        return MIXED[c2] != -1;
    }

    private static boolean isPunctuation(char c2) {
        return PUNCTUATION[c2] != -1;
    }

    private static boolean isText(char c2) {
        return c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 >= ' ' && c2 <= '~';
    }

    private static int determineConsecutiveDigitCount(CharSequence charSequence, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = charSequence.length();
        if (n3 < n4) {
            char c2 = charSequence.charAt(n3);
            while (PDF417HighLevelEncoder.isDigit(c2) && n3 < n4) {
                ++n2;
                if (++n3 >= n4) continue;
                c2 = charSequence.charAt(n3);
            }
        }
        return n2;
    }

    private static int determineConsecutiveTextCount(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = n;
        while (n3 < n2) {
            char c2 = charSequence.charAt(n3);
            int n4 = 0;
            while (n4 < 13 && PDF417HighLevelEncoder.isDigit(c2) && n3 < n2) {
                ++n4;
                if (++n3 >= n2) continue;
                c2 = charSequence.charAt(n3);
            }
            if (n4 >= 13) {
                return n3 - n - n4;
            }
            if (n4 > 0) continue;
            c2 = charSequence.charAt(n3);
            if (!PDF417HighLevelEncoder.isText(c2)) break;
            ++n3;
        }
        return n3 - n;
    }

    private static int determineConsecutiveBinaryCount(String string, int n, Charset charset) {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            int n4 = 0;
            while (n4 < 13 && PDF417HighLevelEncoder.isDigit(c2)) {
                int n5;
                if ((n5 = n3 + ++n4) >= n2) break;
                c2 = string.charAt(n5);
            }
            if (n4 >= 13) {
                return n3 - n;
            }
            c2 = string.charAt(n3);
            if (!charsetEncoder.canEncode(c2)) {
                throw new WriterException("Non-encodable character detected: " + c2 + " (Unicode: " + c2 + ')');
            }
            ++n3;
        }
        return n3 - n;
    }

    private static void encodingECI(int n, StringBuilder stringBuilder) {
        if (n >= 0 && n < 900) {
            stringBuilder.append('\u039f');
            stringBuilder.append((char)n);
        } else if (n < 810900) {
            stringBuilder.append('\u039e');
            stringBuilder.append((char)(n / 900 - 1));
            stringBuilder.append((char)(n % 900));
        } else if (n < 811800) {
            stringBuilder.append('\u039d');
            stringBuilder.append((char)(810900 - n));
        } else {
            throw new WriterException("ECI number not in valid range from 0..811799, but was " + n);
        }
    }
}

