/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.decoder;

import oz.util.barcode.qrcode.decoder.ErrorCorrectionLevel;

final class FormatInformation {
    private static final int FORMAT_INFO_MASK_QR = 21522;
    private static final int[][] FORMAT_INFO_DECODE_LOOKUP;
    private final ErrorCorrectionLevel errorCorrectionLevel;
    private final byte dataMask;

    static {
        int[][] nArrayArray = new int[32][];
        int[] nArray = new int[2];
        nArray[0] = 21522;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{20773, 1};
        nArrayArray[2] = new int[]{24188, 2};
        nArrayArray[3] = new int[]{23371, 3};
        nArrayArray[4] = new int[]{17913, 4};
        nArrayArray[5] = new int[]{16590, 5};
        nArrayArray[6] = new int[]{20375, 6};
        nArrayArray[7] = new int[]{19104, 7};
        nArrayArray[8] = new int[]{30660, 8};
        nArrayArray[9] = new int[]{29427, 9};
        nArrayArray[10] = new int[]{32170, 10};
        nArrayArray[11] = new int[]{30877, 11};
        nArrayArray[12] = new int[]{26159, 12};
        nArrayArray[13] = new int[]{25368, 13};
        nArrayArray[14] = new int[]{27713, 14};
        nArrayArray[15] = new int[]{26998, 15};
        nArrayArray[16] = new int[]{5769, 16};
        nArrayArray[17] = new int[]{5054, 17};
        nArrayArray[18] = new int[]{7399, 18};
        nArrayArray[19] = new int[]{6608, 19};
        nArrayArray[20] = new int[]{1890, 20};
        nArrayArray[21] = new int[]{597, 21};
        nArrayArray[22] = new int[]{3340, 22};
        nArrayArray[23] = new int[]{2107, 23};
        nArrayArray[24] = new int[]{13663, 24};
        nArrayArray[25] = new int[]{12392, 25};
        nArrayArray[26] = new int[]{16177, 26};
        nArrayArray[27] = new int[]{14854, 27};
        nArrayArray[28] = new int[]{9396, 28};
        nArrayArray[29] = new int[]{8579, 29};
        nArrayArray[30] = new int[]{11994, 30};
        nArrayArray[31] = new int[]{11245, 31};
        FORMAT_INFO_DECODE_LOOKUP = nArrayArray;
    }

    private FormatInformation(int n) {
        this.errorCorrectionLevel = ErrorCorrectionLevel.forBits(n >> 3 & 3);
        this.dataMask = (byte)(n & 7);
    }

    static int numBitsDiffering(int n, int n2) {
        return Integer.bitCount(n ^ n2);
    }

    static FormatInformation decodeFormatInformation(int n, int n2) {
        FormatInformation formatInformation = FormatInformation.doDecodeFormatInformation(n, n2);
        if (formatInformation != null) {
            return formatInformation;
        }
        return FormatInformation.doDecodeFormatInformation(n ^ 0x5412, n2 ^ 0x5412);
    }

    private static FormatInformation doDecodeFormatInformation(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        int[][] nArray = FORMAT_INFO_DECODE_LOOKUP;
        int n5 = FORMAT_INFO_DECODE_LOOKUP.length;
        int n6 = 0;
        while (n6 < n5) {
            int[] nArray2 = nArray[n6];
            int n7 = nArray2[0];
            if (n7 == n || n7 == n2) {
                return new FormatInformation(nArray2[1]);
            }
            int n8 = FormatInformation.numBitsDiffering(n, n7);
            if (n8 < n3) {
                n4 = nArray2[1];
                n3 = n8;
            }
            if (n != n2 && (n8 = FormatInformation.numBitsDiffering(n2, n7)) < n3) {
                n4 = nArray2[1];
                n3 = n8;
            }
            ++n6;
        }
        if (n3 <= 3) {
            return new FormatInformation(n4);
        }
        return null;
    }

    ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    byte getDataMask() {
        return this.dataMask;
    }

    public int hashCode() {
        return this.errorCorrectionLevel.ordinal() << 3 | this.dataMask;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FormatInformation)) {
            return false;
        }
        FormatInformation formatInformation = (FormatInformation)object;
        return this.errorCorrectionLevel == formatInformation.errorCorrectionLevel && this.dataMask == formatInformation.dataMask;
    }
}

