/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.detector;

import java.util.ArrayList;
import java.util.List;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPointCallback;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.qrcode.detector.AlignmentPattern;

final class AlignmentPatternFinder {
    private final BitMatrix image;
    private final List possibleCenters;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private final float moduleSize;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    AlignmentPatternFinder(BitMatrix bitMatrix, int n, int n2, int n3, int n4, float f2, ResultPointCallback resultPointCallback) {
        this.image = bitMatrix;
        this.possibleCenters = new ArrayList(5);
        this.startX = n;
        this.startY = n2;
        this.width = n3;
        this.height = n4;
        this.moduleSize = f2;
        this.crossCheckStateCount = new int[3];
        this.resultPointCallback = resultPointCallback;
    }

    AlignmentPattern find() {
        int n = this.startX;
        int n2 = this.height;
        int n3 = n + this.width;
        int n4 = this.startY + n2 / 2;
        int[] nArray = new int[3];
        int n5 = 0;
        while (n5 < n2) {
            AlignmentPattern alignmentPattern;
            int n6 = n4 + ((n5 & 1) == 0 ? (n5 + 1) / 2 : -((n5 + 1) / 2));
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            int n7 = n;
            while (n7 < n3 && !this.image.get(n7, n6)) {
                ++n7;
            }
            int n8 = 0;
            while (n7 < n3) {
                if (this.image.get(n7, n6)) {
                    if (n8 == 1) {
                        nArray[1] = nArray[1] + 1;
                    } else if (n8 == 2) {
                        if (this.foundPatternCross(nArray) && (alignmentPattern = this.handlePossibleCenter(nArray, n6, n7)) != null) {
                            return alignmentPattern;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = 1;
                        nArray[2] = 0;
                        n8 = 1;
                    } else {
                        int n9 = ++n8;
                        nArray[n9] = nArray[n9] + 1;
                    }
                } else {
                    if (n8 == 1) {
                        // empty if block
                    }
                    int n10 = ++n8;
                    nArray[n10] = nArray[n10] + 1;
                }
                ++n7;
            }
            if (this.foundPatternCross(nArray) && (alignmentPattern = this.handlePossibleCenter(nArray, n6, n3)) != null) {
                return alignmentPattern;
            }
            ++n5;
        }
        if (!this.possibleCenters.isEmpty()) {
            return (AlignmentPattern)this.possibleCenters.get(0);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static float centerFromEnd(int[] nArray, int n) {
        return (float)(n - nArray[2]) - (float)nArray[1] / 2.0f;
    }

    private boolean foundPatternCross(int[] nArray) {
        float f2 = this.moduleSize;
        float f3 = f2 / 2.0f;
        int n = 0;
        while (n < 3) {
            if (Math.abs(f2 - (float)nArray[n]) >= f3) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private float crossCheckVertical(int var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 = this.image;
        var6_6 = var5_5.getHeight();
        var7_7 = this.crossCheckStateCount;
        var7_7[0] = 0;
        var7_7[1] = 0;
        var7_7[2] = 0;
        var8_8 = var1_1;
        while (var8_8 >= 0 && var5_5.get(var2_2, var8_8) && var7_7[1] <= var3_3) {
            var7_7[1] = var7_7[1] + 1;
            --var8_8;
        }
        if (var8_8 >= 0 && var7_7[1] <= var3_3) ** GOTO lbl16
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[0] = var7_7[0] + 1;
            --var8_8;
lbl16:
            // 2 sources

            ** while (var8_8 >= 0 && !var5_5.get((int)var2_2, (int)var8_8) && var7_7[0] <= var3_3)
        }
lbl17:
        // 1 sources

        if (var7_7[0] > var3_3) {
            return NaNf;
        }
        var8_8 = var1_1 + 1;
        while (var8_8 < var6_6 && var5_5.get(var2_2, var8_8) && var7_7[1] <= var3_3) {
            var7_7[1] = var7_7[1] + 1;
            ++var8_8;
        }
        if (var8_8 != var6_6 && var7_7[1] <= var3_3) ** GOTO lbl28
        return NaNf;
lbl-1000:
        // 1 sources

        {
            var7_7[2] = var7_7[2] + 1;
            ++var8_8;
lbl28:
            // 2 sources

            ** while (var8_8 < var6_6 && !var5_5.get((int)var2_2, (int)var8_8) && var7_7[2] <= var3_3)
        }
lbl29:
        // 1 sources

        if (var7_7[2] > var3_3) {
            return NaNf;
        }
        var9_9 = var7_7[0] + var7_7[1] + var7_7[2];
        if (5 * Math.abs(var9_9 - var4_4) >= 2 * var4_4) {
            return NaNf;
        }
        return this.foundPatternCross(var7_7) != false ? AlignmentPatternFinder.centerFromEnd(var7_7, var8_8) : NaNf;
    }

    private AlignmentPattern handlePossibleCenter(int[] nArray, int n, int n2) {
        int n3 = nArray[0] + nArray[1] + nArray[2];
        float f2 = AlignmentPatternFinder.centerFromEnd(nArray, n2);
        float f3 = this.crossCheckVertical(n, (int)f2, 2 * nArray[1], n3);
        if (!Float.isNaN(f3)) {
            AlignmentPattern alignmentPattern2;
            float f4 = (float)(nArray[0] + nArray[1] + nArray[2]) / 3.0f;
            for (AlignmentPattern alignmentPattern2 : this.possibleCenters) {
                if (!alignmentPattern2.aboutEquals(f4, f3, f2)) continue;
                return alignmentPattern2.combineEstimate(f3, f2, f4);
            }
            alignmentPattern2 = new AlignmentPattern(f2, f3, f4);
            this.possibleCenters.add(alignmentPattern2);
            if (this.resultPointCallback != null) {
                this.resultPointCallback.foundPossibleResultPoint(alignmentPattern2);
            }
        }
        return null;
    }
}

