/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.encoder;

import java.util.Arrays;

public final class ByteMatrix {
    private final byte[][] bytes;
    private final int width;
    private final int height;

    public ByteMatrix(int n, int n2) {
        this.bytes = new byte[n2][n];
        this.width = n;
        this.height = n2;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public byte get(int n, int n2) {
        return this.bytes[n2][n];
    }

    public byte[][] getArray() {
        return this.bytes;
    }

    public void set(int n, int n2, byte by) {
        this.bytes[n2][n] = by;
    }

    public void set(int n, int n2, int n3) {
        this.bytes[n2][n] = (byte)n3;
    }

    public void set(int n, int n2, boolean bl) {
        this.bytes[n2][n] = (byte)(bl ? 1 : 0);
    }

    public void clear(byte by) {
        byte[][] byArray = this.bytes;
        int n = this.bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray2 = byArray[n2];
            Arrays.fill(byArray2, by);
            ++n2;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2 * this.width * this.height + 2);
        int n = 0;
        while (n < this.height) {
            byte[] byArray = this.bytes[n];
            int n2 = 0;
            while (n2 < this.width) {
                switch (byArray[n2]) {
                    case 0: {
                        stringBuilder.append(" 0");
                        break;
                    }
                    case 1: {
                        stringBuilder.append(" 1");
                        break;
                    }
                    default: {
                        stringBuilder.append("  ");
                    }
                }
                ++n2;
            }
            stringBuilder.append('\n');
            ++n;
        }
        return stringBuilder.toString();
    }
}

