/*
 * Decompiled with CFR 0.152.
 */
package oz.util.eformbot;

import android.util.Base64;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;
import oz.util.eformbot.IOZEFormBotAuthRequest;
import oz.util.eformbot.IOZEFormBotCore;
import oz.util.eformbot.IOZEFormBotCoreInitRequest;
import oz.util.eformbot.IOZEFormBotRecognitionRequest;
import oz.util.eformbot.OZEFormBotCore_Server$WorkThread;
import oz.util.eformbot.OZEFormBotListener;
import oz.util.eformbot.OZEFormBotRecognitionRequest;

public class OZEFormBotCore_Server
implements IOZEFormBotCore {
    private static final String SERVICE_AUTH = "/auth";
    private static final String SERVICE_RECOGNITION = "/instant";
    private String mUrl;
    private String mToken;
    private List mWorks = new ArrayList();
    private static final int WORK_AUTH = 1;
    private static final int WORK_RECOGNITION = 2;

    private static String makeSignatureSha256(String string, String string2, String string3) {
        int n = 0;
        if (string3 != null && !string3.isEmpty()) {
            try {
                n = Integer.valueOf(string3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        String string4 = "";
        try {
            String string5 = string2;
            String string6 = String.format("%s::%d", string, n);
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(string5.getBytes(), "HmacSHA256");
            mac.init(secretKeySpec);
            string4 = Base64.encodeToString((byte[])mac.doFinal(string6.getBytes()), (int)2);
        }
        catch (Throwable throwable) {
            System.out.println("timestamp Error");
        }
        return string4;
    }

    public void init(IOZEFormBotCoreInitRequest iOZEFormBotCoreInitRequest) {
        if (iOZEFormBotCoreInitRequest != null) {
            this.mUrl = iOZEFormBotCoreInitRequest.getUrl();
        }
    }

    public long authToken(IOZEFormBotAuthRequest iOZEFormBotAuthRequest) {
        long l = -1L;
        if (iOZEFormBotAuthRequest != null && this.mUrl != null && !this.mUrl.isEmpty()) {
            l = iOZEFormBotAuthRequest.getRequestId();
            new OZEFormBotCore_Server$WorkThread(this, 1, iOZEFormBotAuthRequest).start();
        }
        return l;
    }

    public String getAuthToken() {
        return this.mToken;
    }

    public long recognition(IOZEFormBotRecognitionRequest iOZEFormBotRecognitionRequest) {
        long l = -1L;
        if (iOZEFormBotRecognitionRequest != null && this.mUrl != null && !this.mUrl.isEmpty()) {
            l = iOZEFormBotRecognitionRequest.getRequestId();
            new OZEFormBotCore_Server$WorkThread(this, 2, iOZEFormBotRecognitionRequest).start();
        }
        return l;
    }

    private static HttpURLConnection createConnection(String string, String string2) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(string + string2).openConnection();
            if (httpURLConnection != null) {
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setReadTimeout(5000);
                httpURLConnection.setConnectTimeout(5000);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return httpURLConnection;
    }

    private HttpURLConnection createAuthConnection() {
        HttpURLConnection httpURLConnection = OZEFormBotCore_Server.createConnection(this.mUrl, SERVICE_AUTH);
        if (httpURLConnection != null) {
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
        }
        return httpURLConnection;
    }

    private HttpURLConnection createRecognitionConnection() {
        HttpURLConnection httpURLConnection = OZEFormBotCore_Server.createConnection(this.mUrl, SERVICE_RECOGNITION);
        if (httpURLConnection != null) {
            httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            httpURLConnection.setRequestProperty("Authorization", this.mToken);
        }
        return httpURLConnection;
    }

    private void authWork(IOZEFormBotAuthRequest iOZEFormBotAuthRequest) {
        block8: {
            HttpURLConnection httpURLConnection = this.createAuthConnection();
            if (httpURLConnection != null) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("client", (Object)iOZEFormBotAuthRequest.getClient());
                    jSONObject.put("timestamp", (Object)iOZEFormBotAuthRequest.getTimestamp());
                    jSONObject.put("signature", (Object)OZEFormBotCore_Server.makeSignatureSha256(iOZEFormBotAuthRequest.getClient(), iOZEFormBotAuthRequest.getKey(), iOZEFormBotAuthRequest.getTimestamp()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                    dataOutputStream.writeBytes(jSONObject.toString());
                    dataOutputStream.flush();
                    dataOutputStream.close();
                    int n = httpURLConnection.getResponseCode();
                    if (n == 200) {
                        String string;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((string = bufferedReader.readLine()) != null) {
                            stringBuffer.append(string);
                        }
                        JSONObject jSONObject2 = new JSONObject(stringBuffer.toString());
                        String string2 = jSONObject2.getString("token");
                        this.callAuthSuccess(iOZEFormBotAuthRequest, string2);
                        break block8;
                    }
                    this.callAuthFailed(iOZEFormBotAuthRequest);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.callAuthFailed(iOZEFormBotAuthRequest);
                }
            } else {
                this.callAuthFailed(iOZEFormBotAuthRequest);
            }
        }
    }

    private void callAuthSuccess(IOZEFormBotAuthRequest iOZEFormBotAuthRequest, String string) {
        this.mToken = string;
    }

    private void callAuthFailed(IOZEFormBotAuthRequest iOZEFormBotAuthRequest) {
    }

    private void recognitionWork(IOZEFormBotRecognitionRequest iOZEFormBotRecognitionRequest) {
        block6: {
            HttpURLConnection httpURLConnection = this.createRecognitionConnection();
            if (httpURLConnection != null) {
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                    dataOutputStream.write(iOZEFormBotRecognitionRequest.getText().getBytes("UTF-8"));
                    dataOutputStream.close();
                    int n = httpURLConnection.getResponseCode();
                    if (n == 200) {
                        String string;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((string = bufferedReader.readLine()) != null) {
                            stringBuffer.append(string);
                        }
                        String string2 = stringBuffer.toString();
                        this.callRecognitionSuccess(iOZEFormBotRecognitionRequest, string2);
                        break block6;
                    }
                    this.callRecognitionFailed(iOZEFormBotRecognitionRequest);
                }
                catch (Throwable throwable) {
                    this.callRecognitionFailed(iOZEFormBotRecognitionRequest);
                }
            } else {
                this.callRecognitionFailed(iOZEFormBotRecognitionRequest);
            }
        }
    }

    private void callRecognitionSuccess(IOZEFormBotRecognitionRequest iOZEFormBotRecognitionRequest, String string) {
        OZEFormBotListener oZEFormBotListener = iOZEFormBotRecognitionRequest.getListener();
        if (oZEFormBotListener != null) {
            oZEFormBotListener.onResponseResult(string, iOZEFormBotRecognitionRequest.getRequestId());
        }
    }

    private void callRecognitionFailed(IOZEFormBotRecognitionRequest iOZEFormBotRecognitionRequest) {
        OZEFormBotListener oZEFormBotListener = iOZEFormBotRecognitionRequest.getListener();
        if (oZEFormBotListener != null) {
            String string = OZEFormBotRecognitionRequest.getSTTInputValue(iOZEFormBotRecognitionRequest.getText());
            oZEFormBotListener.onResponseResult(string, iOZEFormBotRecognitionRequest.getRequestId());
        }
    }

    static /* synthetic */ List access$000(OZEFormBotCore_Server oZEFormBotCore_Server) {
        return oZEFormBotCore_Server.mWorks;
    }

    static /* synthetic */ void access$100(OZEFormBotCore_Server oZEFormBotCore_Server, IOZEFormBotAuthRequest iOZEFormBotAuthRequest) {
        oZEFormBotCore_Server.authWork(iOZEFormBotAuthRequest);
    }

    static /* synthetic */ void access$200(OZEFormBotCore_Server oZEFormBotCore_Server, IOZEFormBotRecognitionRequest iOZEFormBotRecognitionRequest) {
        oZEFormBotCore_Server.recognitionWork(iOZEFormBotRecognitionRequest);
    }
}

