/*
 * Decompiled with CFR 0.152.
 */
package oz.util.handwrite;

import android.util.Log;
import java.util.HashMap;
import oz.util.handwrite.AHandWriteContext;
import oz.util.handwrite.IOZHandWriteContext;
import oz.util.handwrite.IOZHandWriteModel;
import oz.util.handwrite.NativeHandWriteContextWrapper$1;
import oz.util.handwrite.NativeHandWriteContextWrapper$NativePrepareCallback;
import oz.util.handwrite.NativeHandWriteContextWrapper$NativeTextCallback;

public class NativeHandWriteContextWrapper {
    public static boolean useTestModule = false;
    IOZHandWriteContext context;
    public HashMap models;

    public native String nativeGetModuleName();

    public native void nativeRecognizeTextCallback(int var1, Object[] var2);

    public native void nativeRecognizeTextErrorCallback(int var1, int var2);

    public native void nativeRecognizeTextCancelCallback(int var1);

    public native void nativePrepareCallback(int var1, boolean var2);

    IOZHandWriteContext getIOZHandWriteContextText() {
        return new NativeHandWriteContextWrapper$1(this);
    }

    public static AHandWriteContext getTestContext(IOZHandWriteContext iOZHandWriteContext) {
        return new AHandWriteContext(iOZHandWriteContext);
    }

    public static AHandWriteContext getGoogleContext() {
        IOZHandWriteContext iOZHandWriteContext = null;
        try {
            iOZHandWriteContext = (IOZHandWriteContext)Class.forName("com.forcs.ozhandwrite.google.mlkit.ARealHandWriteContext").newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
        return iOZHandWriteContext != null ? new AHandWriteContext(iOZHandWriteContext) : null;
    }

    NativeHandWriteContextWrapper() {
    }

    private void initModule() {
        String string = this.nativeGetModuleName();
        if (useTestModule) {
            this.context = NativeHandWriteContextWrapper.getTestContext(this.getIOZHandWriteContextText());
        } else if (string.isEmpty() || string.equalsIgnoreCase("GoogleMLKit")) {
            this.context = NativeHandWriteContextWrapper.getGoogleContext();
        }
        this.models = new HashMap();
    }

    private boolean validContext() {
        return this.context != null;
    }

    public int getModuleVersion() {
        if (this.validContext()) {
            return this.context.getModuleVersion();
        }
        return -1;
    }

    public String getModuleName() {
        if (this.validContext()) {
            return this.context.getModuleName();
        }
        return "";
    }

    public int getContextType() {
        if (this.validContext()) {
            return this.context.getContextType();
        }
        return -1;
    }

    public String createModel(String string) {
        if (this.validContext()) {
            IOZHandWriteModel iOZHandWriteModel = null;
            if (this.models.containsKey(string)) {
                iOZHandWriteModel = (IOZHandWriteModel)this.models.get(string);
            } else {
                iOZHandWriteModel = this.context.createModel(string);
                this.models.put(string, iOZHandWriteModel);
            }
            return string;
        }
        return null;
    }

    public boolean availableModel(String string) {
        IOZHandWriteModel iOZHandWriteModel = (IOZHandWriteModel)this.models.get(string);
        if (this.validContext() && iOZHandWriteModel != null) {
            Log.e((String)this.getClass().getSimpleName(), (String)("availableModel : " + string));
            return this.context.availableModel(iOZHandWriteModel);
        }
        return false;
    }

    public void prepareModel(int n, boolean bl, String string) {
        if (this.validContext()) {
            IOZHandWriteModel iOZHandWriteModel = null;
            if (this.models.containsKey(string)) {
                Log.e((String)this.getClass().getSimpleName(), (String)("prepareModel : " + string + " , useCellularNetwork : " + bl));
                iOZHandWriteModel = (IOZHandWriteModel)this.models.get(string);
                this.context.prepareModel(n, iOZHandWriteModel, bl, new NativeHandWriteContextWrapper$NativePrepareCallback(this, n));
            }
        }
    }

    public boolean isPreparingModel(String string) {
        if (this.validContext()) {
            return this.context.isPreparingModel(string);
        }
        return false;
    }

    public boolean cancelPrepareModel(String string) {
        if (this.validContext()) {
            return this.context.cancelPrepareModel(string);
        }
        return false;
    }

    public void deleteModel(String string) {
        if (this.validContext()) {
            this.context.deleteModel(string);
        }
    }

    public void downPoint(double d2, double d3, double d4) {
        if (this.validContext()) {
            this.context.downPoint(d2, d3, d4);
        }
    }

    public void movePoint(double d2, double d3, double d4) {
        if (this.validContext()) {
            this.context.movePoint(d2, d3, d4);
        }
    }

    public void upPoint(double d2, double d3, double d4) {
        if (this.validContext()) {
            this.context.upPoint(d2, d3, d4);
        }
    }

    public void reset() {
        if (this.validContext()) {
            this.context.reset();
        }
    }

    public void recognizeText(int n, String string, double d2, double d3) {
        if (this.validContext()) {
            this.context.recognizeText(n, string, d2, d3, new NativeHandWriteContextWrapper$NativeTextCallback(this, n));
        }
    }

    public boolean cancelRecognizeText(Object object) {
        if (this.validContext()) {
            return this.context.cancelRecognizeText(object);
        }
        return false;
    }

    public String getRecognizedText(String string) {
        return this.context.getRecognizedText(string);
    }
}

