/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath;

import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import oz.util.signpath.OZSignPathMeta$BooleanValue;
import oz.util.signpath.OZSignPathMeta$DoubleValue;
import oz.util.signpath.OZSignPathMeta$FloatValue;
import oz.util.signpath.OZSignPathMeta$IntegerValue;
import oz.util.signpath.OZSignPathMeta$LongValue;
import oz.util.signpath.OZSignPathMeta$ObjectValue;
import oz.util.signpath.OZSignPathMeta$StringValue;

public class OZSignPathMeta {
    public static final int PRESSURE_CLEAR = -1;
    public static final int PRESSURE_NONE = 0;
    public static final int PRESSURE_USE = 1;
    public static final String META_RATIO = "ratio";
    public static final String META_RENDERTYPE = "rendertype";
    public static final String META_THICK = "penthickness";
    public static final String META_USER_NAME = "user_name";
    public static final String META_USER_ID = "user_id";
    public static final String META_REUSED = "reusedsign";
    public static final String META_LATITUDE = "location_latitude";
    public static final String META_LONGITUDE = "location_longitude";
    public static final String META_REASON = "reason";
    public static final String META_TIME = "time";
    public static final String META_INFO = "info";
    private float ratio = 0.0f;
    private int renderType = 0;
    private float penThick;
    private String userName = null;
    private String userID = null;
    private boolean reused = false;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private String reason = null;
    private long time = 0L;
    private String info = null;
    private boolean mutable = true;
    private HashMap changedValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangedAttrJSON() {
        String string = null;
        if (this.changedValues != null && !this.changedValues.isEmpty()) {
            HashMap hashMap = this.changedValues;
            synchronized (hashMap) {
                JSONObject jSONObject = new JSONObject();
                for (String string2 : this.changedValues.keySet()) {
                    OZSignPathMeta$ObjectValue oZSignPathMeta$ObjectValue = (OZSignPathMeta$ObjectValue)this.changedValues.get(string2);
                    if (oZSignPathMeta$ObjectValue == null) continue;
                    oZSignPathMeta$ObjectValue.appendJSON(jSONObject, string2);
                }
                string = jSONObject.toString();
            }
        }
        return string;
    }

    public void clearChangedAttrJSON() {
        this.changedValues = null;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public OZSignPathMeta setImmutable() {
        this.mutable = false;
        this.clearChangedAttrJSON();
        return this;
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float f2) {
        if (this.mutable && this.ratio != f2 && f2 >= 0.0f) {
            this.ratio = f2;
            this.appendChanged(META_RATIO, f2);
        }
    }

    public int getRenderType() {
        return this.renderType;
    }

    public void setRenderType(int n) {
        if (this.mutable && this.renderType != n && n >= -1 && n <= 1) {
            this.renderType = n;
            this.appendChanged(META_RENDERTYPE, n);
        }
    }

    public float getPenThick() {
        return this.penThick;
    }

    public void setPenThick(float f2) {
        if (this.mutable && this.penThick != f2 && f2 >= 0.0f) {
            this.penThick = f2;
            this.appendChanged(META_THICK, f2);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        if (this.userName != string) {
            if (string == null) {
                string = "";
            }
            if (this.mutable && !string.equals(this.userName)) {
                this.userName = string;
                this.appendChanged(META_USER_NAME, string);
            }
        }
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String string) {
        if (this.userID != string) {
            if (string == null) {
                string = "";
            }
            if (this.mutable && !string.equals(this.userID)) {
                this.userID = string;
                this.appendChanged(META_USER_ID, string);
            }
        }
    }

    public boolean isReused() {
        return this.reused;
    }

    public void setReused(boolean bl) {
        if (this.mutable && this.reused != bl) {
            this.reused = bl;
            this.appendChanged(META_REUSED, bl);
        }
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double d2) {
        if (this.mutable && this.latitude != d2) {
            this.latitude = d2;
            this.appendChanged(META_LATITUDE, d2);
        }
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double d2) {
        if (this.mutable && this.longitude != d2) {
            this.longitude = d2;
            this.appendChanged(META_LONGITUDE, d2);
        }
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        if (this.reason != string) {
            if (string == null) {
                string = "";
            }
            if (this.mutable && !string.equals(this.reason)) {
                this.reason = string;
                this.appendChanged(META_REASON, string);
            }
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l) {
        if (this.mutable && this.time != l && l >= 0L) {
            this.time = l;
            this.appendChanged(META_TIME, l);
        }
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        if (this.info != string) {
            if (string == null) {
                string = "";
            }
            if (this.mutable && !string.equals(this.info)) {
                this.info = string;
                this.appendChanged(META_INFO, string);
            }
        }
    }

    private void appendChanged(String string, int n) {
        this.appendChanged(string, new OZSignPathMeta$IntegerValue(n));
    }

    private void appendChanged(String string, float f2) {
        this.appendChanged(string, new OZSignPathMeta$FloatValue(f2));
    }

    private void appendChanged(String string, boolean bl) {
        this.appendChanged(string, new OZSignPathMeta$BooleanValue(bl));
    }

    private void appendChanged(String string, double d2) {
        this.appendChanged(string, new OZSignPathMeta$DoubleValue(d2));
    }

    private void appendChanged(String string, long l) {
        this.appendChanged(string, new OZSignPathMeta$LongValue(l));
    }

    private void appendChanged(String string, String string2) {
        this.appendChanged(string, new OZSignPathMeta$StringValue(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendChanged(String string, OZSignPathMeta$ObjectValue oZSignPathMeta$ObjectValue) {
        if (this.changedValues == null) {
            this.changedValues = new HashMap();
        }
        HashMap hashMap = this.changedValues;
        synchronized (hashMap) {
            this.changedValues.put(string, oZSignPathMeta$ObjectValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OZSignPathMeta copy() {
        OZSignPathMeta oZSignPathMeta = new OZSignPathMeta();
        oZSignPathMeta.ratio = this.ratio;
        oZSignPathMeta.renderType = this.renderType;
        oZSignPathMeta.penThick = this.penThick;
        oZSignPathMeta.userName = this.userName;
        oZSignPathMeta.userID = this.userID;
        oZSignPathMeta.reused = this.reused;
        oZSignPathMeta.latitude = this.latitude;
        oZSignPathMeta.longitude = this.longitude;
        oZSignPathMeta.reason = this.reason;
        oZSignPathMeta.time = this.time;
        oZSignPathMeta.info = this.info;
        if (this.changedValues != null && !this.changedValues.isEmpty()) {
            HashMap hashMap = this.changedValues;
            synchronized (hashMap) {
                for (String string : this.changedValues.keySet()) {
                    OZSignPathMeta$ObjectValue oZSignPathMeta$ObjectValue = (OZSignPathMeta$ObjectValue)this.changedValues.get(string);
                    oZSignPathMeta.appendChanged(string, oZSignPathMeta$ObjectValue);
                }
            }
        }
        return oZSignPathMeta;
    }

    public static OZSignPathMeta parse(String string) {
        OZSignPathMeta oZSignPathMeta = new OZSignPathMeta();
        if (string != null && !string.isEmpty()) {
            JSONObject jSONObject = null;
            try {
                jSONObject = new JSONObject(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (jSONObject != null) {
                oZSignPathMeta.setRatio((float)jSONObject.optDouble(META_RATIO, (double)oZSignPathMeta.ratio));
                oZSignPathMeta.setRenderType(jSONObject.optInt(META_RENDERTYPE, oZSignPathMeta.renderType));
                oZSignPathMeta.setPenThick((float)jSONObject.optDouble(META_THICK, (double)oZSignPathMeta.penThick));
                oZSignPathMeta.setUserName(jSONObject.optString(META_USER_NAME, oZSignPathMeta.userName));
                oZSignPathMeta.setUserID(jSONObject.optString(META_USER_ID, oZSignPathMeta.userID));
                oZSignPathMeta.setReused(jSONObject.optBoolean(META_REUSED, oZSignPathMeta.reused));
                oZSignPathMeta.setLatitude(jSONObject.optDouble(META_LATITUDE, oZSignPathMeta.latitude));
                oZSignPathMeta.setLongitude(jSONObject.optDouble(META_LONGITUDE, oZSignPathMeta.longitude));
                oZSignPathMeta.setReason(jSONObject.optString(META_REASON, oZSignPathMeta.reason));
                oZSignPathMeta.setTime(jSONObject.optLong(META_TIME, oZSignPathMeta.time));
                oZSignPathMeta.setInfo(jSONObject.optString(META_INFO, oZSignPathMeta.info));
            }
        }
        return oZSignPathMeta;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(META_RATIO, (double)this.ratio);
            jSONObject.put(META_RENDERTYPE, this.renderType);
            jSONObject.put(META_THICK, (double)this.penThick);
            if (this.userName != null) {
                jSONObject.put(META_USER_NAME, (Object)this.userName);
            }
            if (this.userID != null) {
                jSONObject.put(META_USER_ID, (Object)this.userID);
            }
            jSONObject.put(META_REUSED, this.reused);
            jSONObject.put(META_LATITUDE, this.latitude);
            jSONObject.put(META_LONGITUDE, this.longitude);
            if (this.reason != null) {
                jSONObject.put(META_REASON, (Object)this.reason);
            }
            jSONObject.put(META_TIME, this.time);
            if (this.info != null) {
                jSONObject.put(META_INFO, (Object)this.info);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject.toString();
    }
}

