/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import oz.util.signpath.OZSignPath;
import oz.util.signpath.view.SignPathView$SignTouchViewProvider;
import oz.util.signpath.view.SignPathView$onPathValueChangedListener;
import oz.util.signpath.view.SignPathView$onSignAreaChangedListener;
import oz.util.signpath.view.SignPathView$onTouchEventListener;
import oz.util.signpath.view.model.ISignPathEditableValue;
import oz.util.signpath.view.model.ISignPathSetting;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.model.ISignPathViewProvider;
import oz.util.signpath.view.model.SignPathViewBasicProvider;
import oz.util.signpath.view.render.RenderData;
import oz.util.signpath.view.render.RenderItem;
import oz.util.signpath.view.touch.ISignTouchProcess;
import oz.util.signpath.view.touch.ISignTouchViewProvider;

public class SignPathView
extends View {
    private SignPathView$onPathValueChangedListener mValueChangedListener;
    private SignPathView$onTouchEventListener mTouchEventListener;
    private SignPathView$onSignAreaChangedListener mSignAreaChangedListener;
    private ISignPathSetting mSetting;
    private RenderItem mRenderItem;
    private ISignPathValue mSignValue;
    private ISignTouchProcess mTouchProcess;
    private ISignTouchViewProvider mTouchProvider;
    private boolean mChangedSignValue;
    private Rect mSignArea;
    private boolean mInvalidate;
    private boolean mModeErase;

    public SignPathView(Context context) {
        this(context, (ISignPathViewProvider)null);
    }

    public SignPathView(Context context, ISignPathViewProvider iSignPathViewProvider) {
        super(context);
        this.init(iSignPathViewProvider);
    }

    public SignPathView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0, 0);
    }

    public SignPathView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public SignPathView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n);
        this.init(null);
    }

    private void init(ISignPathViewProvider iSignPathViewProvider) {
        if (iSignPathViewProvider == null) {
            iSignPathViewProvider = new SignPathViewBasicProvider();
        }
        this.setRenderItem(iSignPathViewProvider.provideRenderItem());
        this.setSetting(iSignPathViewProvider.provideSetting());
        this.setSignValue(iSignPathViewProvider.provideSignValue());
        this.setSignTouchProcess(iSignPathViewProvider.provideTouchProcess());
        this.mTouchProvider = new SignPathView$SignTouchViewProvider(this, null);
    }

    private void invalidateTouchWorks() {
        if (this.mTouchProcess != null) {
            this.mTouchProcess.invalidateTouches();
        }
    }

    private void setSignTouchProcess(ISignTouchProcess iSignTouchProcess) {
        if (this.mTouchProcess != iSignTouchProcess) {
            this.invalidateTouchWorks();
            this.mTouchProcess = iSignTouchProcess;
        }
    }

    public void setOnValueChangedListener(SignPathView$onPathValueChangedListener signPathView$onPathValueChangedListener) {
        this.mValueChangedListener = signPathView$onPathValueChangedListener;
    }

    public void setOnTouchEventListener(SignPathView$onTouchEventListener signPathView$onTouchEventListener) {
        this.mTouchEventListener = signPathView$onTouchEventListener;
    }

    public void setOnSignAreaChangedListener(SignPathView$onSignAreaChangedListener signPathView$onSignAreaChangedListener) {
        this.mSignAreaChangedListener = signPathView$onSignAreaChangedListener;
    }

    protected void callValueChanged(ISignPathValue iSignPathValue, ISignPathValue iSignPathValue2) {
        if (this.mValueChangedListener != null) {
            this.mValueChangedListener.onChanged(this, iSignPathValue, iSignPathValue2);
        }
    }

    protected void callValueChangedAppend() {
        if (this.mValueChangedListener != null) {
            this.mValueChangedListener.onAppend(this);
        }
    }

    protected void callValueChangedDeleted() {
        if (this.mValueChangedListener != null) {
            this.mValueChangedListener.onDeleted(this);
        }
    }

    protected void callValueChangedClear() {
        if (this.mValueChangedListener != null) {
            this.mValueChangedListener.onClear(this);
        }
    }

    protected void callTouchDown(float f2, float f3) {
        if (this.mTouchEventListener != null) {
            this.mTouchEventListener.onTouchDown(this, f2, f3);
        }
    }

    protected void callTouchUp(float f2, float f3) {
        if (this.mTouchEventListener != null) {
            this.mTouchEventListener.onTouchUp(this, f2, f3);
        }
    }

    private void drawNewLine(ISignPathValue iSignPathValue) {
        if (this.mRenderItem != null) {
            this.mRenderItem.drawNewLine(this.createRenderData(), iSignPathValue);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = false;
        if (this.isEnabled() && this.mTouchProcess != null && (bl = this.mTouchProcess.handleTouchEvent(this.mTouchProvider, motionEvent))) {
            this.mTouchProcess.processTouchEvent(this.mTouchProvider, motionEvent);
        }
        return bl;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.needFullInvalidate();
    }

    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        super.onScrollChanged(n, n2, n3, n4);
        this.invalidateTouchWorks();
    }

    protected void onDraw(Canvas canvas) {
        RenderItem renderItem = this.mRenderItem;
        if (renderItem != null) {
            this.updateSignArea(canvas);
            RenderData renderData = this.createRenderData();
            if (this.mInvalidate) {
                renderItem.invalidate(renderData);
                this.mInvalidate = false;
            }
            renderItem.draw(renderData, canvas);
        }
    }

    private RenderData createRenderData() {
        RenderData renderData = new RenderData();
        renderData.view = this;
        renderData.setting = this.getSetting();
        renderData.value = this.getSignValue();
        renderData.currentLineValue = this.createCurrentLineValuesArray();
        renderData.rect = new Rect(this.mSignArea);
        return renderData;
    }

    private ISignPathValue[] createCurrentLineValuesArray() {
        if (this.mTouchProcess != null) {
            return this.mTouchProcess.createCurrentLineValuesArray();
        }
        return null;
    }

    private void updateSignArea(Canvas canvas) {
        this.updateSignArea(canvas.getWidth(), canvas.getHeight());
    }

    private void updateSignArea(int n, int n2) {
        Rect rect;
        boolean bl = false;
        if (this.mSignArea == null) {
            this.mSignArea = new Rect();
        }
        if ((rect = this.getSetting().getSignArea(n, n2)) == null || rect.isEmpty()) {
            if (n != this.mSignArea.width() || n2 != this.mSignArea.height()) {
                this.mSignArea.set(0, 0, n, n2);
                bl = true;
            }
        } else if (!this.mSignArea.equals((Object)rect)) {
            this.mSignArea.set(rect);
            bl = true;
        }
        if (bl) {
            if (this.mSignAreaChangedListener != null && this.mSignArea != null) {
                this.mSignAreaChangedListener.onSignAreaChanged(this, this.mSignArea.left, this.mSignArea.top, this.mSignArea.right, this.mSignArea.bottom);
            }
            this.invalidateTouchWorks();
        }
    }

    private Rect getSignArea() {
        return this.mSignArea;
    }

    public Rect getCurrentSignArea() {
        return new Rect(this.mSignArea);
    }

    public void setSetting(ISignPathSetting iSignPathSetting) {
        if (this.mSetting != iSignPathSetting) {
            this.mSetting = iSignPathSetting;
            this.needFullInvalidate();
        }
    }

    public ISignPathSetting getSetting() {
        return this.mSetting;
    }

    public void setRenderItem(RenderItem renderItem) {
        if (this.mRenderItem != renderItem) {
            this.mRenderItem = renderItem;
            this.needFullInvalidate();
        }
    }

    private void setSignValueInternal(ISignPathValue iSignPathValue, boolean bl) {
        ISignPathValue iSignPathValue2 = this.mSignValue;
        this.mSignValue = iSignPathValue;
        if (bl) {
            this.callValueChanged(this.mSignValue, iSignPathValue2);
        }
        this.setNotChanged();
        this.needFullInvalidate();
        if (iSignPathValue2 != null) {
            ISignPathEditableValue iSignPathEditableValue;
            OZSignPath oZSignPath = iSignPathValue2.getValueAsSignPath();
            if (oZSignPath != null) {
                oZSignPath.recycle();
            }
            if ((iSignPathEditableValue = iSignPathValue2.toEditable()) != null && (oZSignPath = iSignPathEditableValue.getEditableSignPath()) != null) {
                oZSignPath.recycle();
            }
        }
    }

    public void setSignValue(ISignPathValue iSignPathValue) {
        if (this.mSignValue != iSignPathValue) {
            this.invalidateTouchWorks();
            this.setSignValueInternal(iSignPathValue, true);
        }
    }

    public void clearSignValue() {
        if (this.mSignValue != null) {
            this.invalidateTouchWorks();
            this.setSignValue(null);
            this.setChanged();
            this.needFullInvalidate();
            this.callValueChangedClear();
        }
    }

    public ISignPathValue getSignValue() {
        return this.mSignValue;
    }

    public void needFullInvalidate() {
        this.mInvalidate = true;
        this.postInvalidate();
    }

    protected void setChanged() {
        this.mChangedSignValue = true;
    }

    public void setNotChanged() {
        this.mChangedSignValue = false;
    }

    public boolean isChanged() {
        return this.mChangedSignValue;
    }

    protected void onDrawModeChanged() {
        this.invalidateTouchWorks();
    }

    public boolean isEraseMode() {
        return this.mModeErase;
    }

    public void toggleDrawErase() {
        if (this.isEraseMode()) {
            this.setDrawMode();
        } else {
            this.setEraseMode();
        }
    }

    public void setDrawMode() {
        if (this.mModeErase) {
            this.mModeErase = false;
            this.onDrawModeChanged();
        }
    }

    public void setEraseMode() {
        if (!this.mModeErase) {
            this.mModeErase = true;
            this.onDrawModeChanged();
        }
    }

    static /* synthetic */ Rect access$000(SignPathView signPathView) {
        return signPathView.getSignArea();
    }

    static /* synthetic */ void access$100(SignPathView signPathView, ISignPathValue iSignPathValue) {
        signPathView.drawNewLine(iSignPathValue);
    }

    static /* synthetic */ void access$200(SignPathView signPathView, ISignPathValue iSignPathValue, boolean bl) {
        signPathView.setSignValueInternal(iSignPathValue, bl);
    }
}

