/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view.render;

import android.graphics.Canvas;
import java.util.ArrayList;
import java.util.List;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.render.RenderData;
import oz.util.signpath.view.render.RenderItem;

public class RenderGroupItem
implements RenderItem {
    private List mItems = new ArrayList();

    public void add(RenderItem renderItem) {
        if (renderItem != null) {
            this.mItems.add(renderItem);
        }
    }

    public RenderItem remove(int n) {
        if (n >= 0 && this.mItems.size() > n) {
            return (RenderItem)this.mItems.get(n);
        }
        return null;
    }

    public RenderItem get(int n) {
        if (n >= 0 && this.mItems.size() > n) {
            return (RenderItem)this.mItems.get(n);
        }
        return null;
    }

    public int size() {
        return this.mItems.size();
    }

    public void drawNewLine(RenderData renderData, ISignPathValue iSignPathValue) {
        for (RenderItem renderItem : this.mItems) {
            renderItem.drawNewLine(renderData, iSignPathValue);
        }
    }

    public void invalidate(RenderData renderData) {
        for (RenderItem renderItem : this.mItems) {
            renderItem.invalidate(renderData);
        }
    }

    public void draw(RenderData renderData, Canvas canvas) {
        for (RenderItem renderItem : this.mItems) {
            renderItem.draw(renderData, canvas);
        }
    }
}

