/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view.render;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.render.RenderData;
import oz.util.signpath.view.render.RenderItem;

public class RenderSignAreaItem
implements RenderItem {
    private Paint mRenderPaint;
    private float DpPerPx;

    public void drawNewLine(RenderData renderData, ISignPathValue iSignPathValue) {
    }

    public void invalidate(RenderData renderData) {
        if (this.mRenderPaint == null) {
            this.mRenderPaint = new Paint();
            this.mRenderPaint.setAntiAlias(true);
            this.DpPerPx = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)renderData.view.getContext().getResources().getDisplayMetrics());
        }
    }

    public void draw(RenderData renderData, Canvas canvas) {
        if (renderData.rect != null && !renderData.rect.isEmpty()) {
            int n = renderData.setting.getSignAreaBackgroundColor();
            int n2 = renderData.setting.getSignAreaBorderColor();
            float f2 = renderData.setting.getSignAreaBorderThickness();
            if (n != 0) {
                this.mRenderPaint.setColor(n);
                this.mRenderPaint.setStyle(Paint.Style.FILL);
                canvas.drawRect(renderData.rect, this.mRenderPaint);
            }
            if (n2 != 0 && f2 > 0.0f) {
                canvas.save();
                canvas.clipRect(renderData.rect);
                this.mRenderPaint.setColor(n2);
                this.mRenderPaint.setStrokeWidth(f2 * this.DpPerPx);
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
                canvas.drawRect(renderData.rect, this.mRenderPaint);
                canvas.restore();
            }
        }
    }
}

