/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view.render;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import oz.util.AutoSizeTextDrawHelper;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.render.RenderData;
import oz.util.signpath.view.render.RenderItem;

public class RenderTextItem
implements RenderItem {
    private Paint mTextPaint;
    private Rect mTextArea;
    private String[] mTexts;
    private AutoSizeTextDrawHelper mHelper;
    private int mGravity;

    public void drawNewLine(RenderData renderData, ISignPathValue iSignPathValue) {
    }

    public void invalidate(RenderData renderData) {
        if (this.mTextPaint == null) {
            this.mTextPaint = new Paint();
            this.mTextPaint.setAntiAlias(true);
            this.mTextArea = new Rect();
            this.mHelper = new AutoSizeTextDrawHelper();
        }
        int n = renderData.setting.getTextColor();
        float f2 = renderData.setting.getTextSize() * renderData.setting.getTextSizeScale();
        this.mGravity = renderData.setting.getTextGravity();
        if (n == 0) {
            this.mTexts = null;
        } else {
            this.mTextArea.set(renderData.rect);
            this.mTexts = renderData.setting.getTexts();
            this.mTextPaint.setColor(n);
            this.mTextPaint.setTextSize(f2);
        }
    }

    public void draw(RenderData renderData, Canvas canvas) {
        if (this.mTexts != null && this.mTextArea != null && !this.mTextArea.isEmpty()) {
            boolean bl = renderData.setting.isShowTextWithValue();
            if (!bl) {
                boolean bl2 = bl = renderData.value == null && renderData.currentLineValue == null;
            }
            if (bl) {
                if (this.mGravity != 0 && this.mTextPaint.getTextSize() > 0.0f) {
                    this.drawTextFixedSize(canvas, this.mTextPaint, this.mTexts, this.mTextArea, this.mTextPaint.getTextSize(), this.mGravity);
                } else {
                    this.mHelper.drawTextFullAutoSize(canvas, this.mTextPaint, this.mTexts, this.mTextArea.left, this.mTextArea.top, this.mTextArea.right, this.mTextArea.bottom, this.mTextPaint.getTextSize());
                }
            }
        }
    }

    public void drawTextFixedSize(Canvas canvas, Paint paint, String[] stringArray, Rect rect, float f2, int n) {
        if (canvas != null && paint != null && stringArray != null) {
            int n2 = stringArray.length;
            int n3 = n & 0x70;
            int n4 = n & 7;
            float f3 = f2 - paint.descent();
            float f4 = f2 + paint.descent();
            float f5 = paint.descent() * 2.0f / 3.0f;
            switch (n3) {
                case 48: {
                    f3 = (float)rect.top + f2;
                    break;
                }
                case 80: {
                    f3 = (float)rect.bottom - paint.descent();
                    break;
                }
                default: {
                    f3 = (float)rect.top + (float)rect.height() / 2.0f - f4 * (float)(n2 - 1) / 2.0f - paint.descent() + f2 / 2.0f;
                }
            }
            for (String string : stringArray) {
                float f6 = 0.0f;
                switch (n4) {
                    case 3: {
                        f6 = (float)rect.left + f5;
                        break;
                    }
                    case 5: {
                        f6 = (float)rect.right - paint.measureText(string) - f5;
                        break;
                    }
                    default: {
                        f6 = (float)rect.left + ((float)rect.width() + f6 - paint.measureText(string)) / 2.0f;
                    }
                }
                canvas.drawText(string, f6, f3, paint);
                if (n3 == 80) {
                    f3 -= f4;
                    continue;
                }
                f3 += f4;
            }
        }
    }
}

