/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view.touch;

import android.graphics.Rect;
import android.util.SparseArray;
import android.view.MotionEvent;
import oz.util.signpath.OZSignPath;
import oz.util.signpath.OZSignPathMeta;
import oz.util.signpath.view.model.ISignPathEditableValue;
import oz.util.signpath.view.model.ISignPathSetting;
import oz.util.signpath.view.model.ISignPathValue;
import oz.util.signpath.view.model.SignPathValue;
import oz.util.signpath.view.touch.ISignTouchProcess;
import oz.util.signpath.view.touch.ISignTouchViewProvider;
import oz.util.signpath.view.touch.ISignTouchWork;
import oz.util.signpath.view.touch.SignTouchData;
import oz.util.signpath.view.touch.SignTouchDrawWork;
import oz.util.signpath.view.touch.SignTouchEraseWork;

public class SignTouchProcess
implements ISignTouchProcess {
    private SparseArray mTouchWorks;
    private final Rect mSignArea = new Rect();
    private float mSignAreaRatio;
    private int mAction;
    private int mActionIndex;
    private int mPointerCount;
    private long mTime;
    private boolean mIsDown;
    private boolean mIsMove;
    private boolean mIsUp;
    private boolean mIsCancel;
    private boolean mCanStylusInput;
    private boolean mCanHandInput;
    private boolean mUsePressure;
    private boolean mEmptyPathValue;
    private boolean mIgnoreTouch;
    private ISignTouchWork mFirstTouchWork;
    private boolean mFirstTouchWorkUsePressure;
    private boolean mEraseMode;
    private int mTotalEraseCount;
    private OZSignPath mErasePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISignPathValue[] createCurrentLineValuesArray() {
        ISignPathValue[] iSignPathValueArray = null;
        if (this.mTouchWorks != null) {
            SparseArray sparseArray = this.mTouchWorks;
            synchronized (sparseArray) {
                int n = this.mTouchWorks.size();
                iSignPathValueArray = new ISignPathValue[n];
                boolean bl = false;
                for (int j = 0; j < n; ++j) {
                    ISignTouchWork iSignTouchWork = (ISignTouchWork)this.mTouchWorks.valueAt(j);
                    if (iSignTouchWork == null) continue;
                    iSignPathValueArray[j] = iSignTouchWork.getValue();
                    if (iSignPathValueArray[j] == null) continue;
                    bl = true;
                }
                if (!bl) {
                    iSignPathValueArray = null;
                }
            }
        }
        return iSignPathValueArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateTouches() {
        if (this.mTouchWorks != null) {
            SparseArray sparseArray = this.mTouchWorks;
            synchronized (sparseArray) {
                int n = this.mTouchWorks.size();
                for (int j = 0; j < n; ++j) {
                    ISignTouchWork iSignTouchWork = (ISignTouchWork)this.mTouchWorks.valueAt(j);
                    if (iSignTouchWork == null) continue;
                    iSignTouchWork.onRemoved();
                }
                this.mFirstTouchWork = null;
                this.mErasePath = null;
                this.mTouchWorks.clear();
            }
        }
    }

    public boolean handleTouchEvent(ISignTouchViewProvider iSignTouchViewProvider, MotionEvent motionEvent) {
        boolean bl = false;
        this.mAction = motionEvent.getActionMasked();
        this.mIsDown = this.mAction == 0 || this.mAction == 5;
        this.mIsMove = this.mAction == 2;
        this.mIsUp = this.mAction == 1 || this.mAction == 6;
        this.mIsCancel = this.mAction == 3;
        boolean bl2 = bl = this.mIsDown || this.mIsMove || this.mIsUp || this.mIsCancel;
        if (bl) {
            Rect rect = iSignTouchViewProvider.getSignArea();
            if (rect != null) {
                this.mSignArea.set(rect);
            } else {
                this.mSignArea.setEmpty();
            }
            boolean bl3 = bl = this.mSignArea.width() > 0 && this.mSignArea.height() > 0;
            if (bl) {
                Object object;
                this.mSignAreaRatio = (float)this.mSignArea.width() / (float)this.mSignArea.height();
                this.mActionIndex = motionEvent.getActionIndex();
                this.mPointerCount = motionEvent.getPointerCount();
                this.mTime = motionEvent.getEventTime();
                this.mTotalEraseCount = 0;
                ISignPathSetting iSignPathSetting = iSignTouchViewProvider.getView().getSetting();
                this.mCanHandInput = iSignPathSetting.allowHandInput();
                this.mCanStylusInput = iSignPathSetting.allowStylusInput();
                this.mUsePressure = iSignPathSetting.allowTouchPressure();
                this.mEraseMode = iSignTouchViewProvider.getView().isEraseMode();
                this.mIgnoreTouch = false;
                this.mUsePressure = true;
                this.mEmptyPathValue = false;
                ISignPathValue iSignPathValue = iSignTouchViewProvider.getView().getSignValue();
                if (iSignPathValue != null) {
                    object = iSignPathValue.getValueAsSignPath();
                    if (this.mUsePressure && object != null && !((OZSignPath)object).isRecycled()) {
                        this.mUsePressure = ((OZSignPath)object).getMeta().getRenderType() == 1;
                    } else {
                        this.mEmptyPathValue = true;
                        this.mIgnoreTouch = iSignPathValue.getValueAsBitmap() != null;
                    }
                } else {
                    this.mEmptyPathValue = true;
                }
                this.mErasePath = this.mEraseMode && !this.mEmptyPathValue && !this.mIgnoreTouch ? ((object = iSignPathValue.toEditable()) != null ? object.createEditableSignPath(this.mSignAreaRatio) : null) : null;
            }
        }
        return bl;
    }

    public boolean processTouchEvent(ISignTouchViewProvider iSignTouchViewProvider, MotionEvent motionEvent) {
        boolean bl;
        int n;
        boolean bl2 = false;
        ISignTouchWork iSignTouchWork = null;
        for (n = 0; n < this.mPointerCount; ++n) {
            ISignTouchWork iSignTouchWork2 = this.processTouchEventPointer(iSignTouchViewProvider, motionEvent, n);
            if (iSignTouchWork2 == null) continue;
            bl2 = true;
            if (n != this.mActionIndex) continue;
            iSignTouchWork = iSignTouchWork2;
            if (!this.mIsDown) continue;
            this.checkFirstPathWork(iSignTouchWork2);
        }
        n = bl2 && !this.mEraseMode ? 1 : 0;
        boolean bl3 = bl = (this.mIsUp || this.mIsCancel) && iSignTouchWork != null;
        if (this.mEraseMode && this.mTotalEraseCount > 0) {
            this.onErase(iSignTouchViewProvider);
        }
        if (bl) {
            if (this.mIsCancel) {
                this.invalidateTouches();
            } else {
                if (!this.mEraseMode) {
                    this.onAppendLine(iSignTouchViewProvider, iSignTouchWork);
                }
                this.removeTouchWork(motionEvent.getPointerId(this.mActionIndex));
            }
        }
        if (n != 0) {
            iSignTouchViewProvider.getView().postInvalidate();
        }
        this.completeTouchEvent();
        return bl2;
    }

    private ISignPathValue createEmptySign(ISignTouchViewProvider iSignTouchViewProvider) {
        OZSignPathMeta oZSignPathMeta = new OZSignPathMeta();
        oZSignPathMeta.setRatio(this.mSignAreaRatio);
        oZSignPathMeta.setRenderType(this.mFirstTouchWorkUsePressure ? 1 : 0);
        float f2 = iSignTouchViewProvider.getView().getSetting().getMetaThickness();
        if (f2 > 0.0f) {
            oZSignPathMeta.setPenThick(f2);
        }
        return new SignPathValue(new OZSignPath(oZSignPathMeta));
    }

    private void onAppendLine(ISignTouchViewProvider iSignTouchViewProvider, ISignTouchWork iSignTouchWork) {
        boolean bl = iSignTouchWork.canApplyValue();
        if (bl) {
            ISignPathEditableValue iSignPathEditableValue;
            boolean bl2 = false;
            ISignPathValue iSignPathValue = iSignTouchViewProvider.getView().getSignValue();
            if (iSignPathValue == null) {
                bl2 = true;
                iSignPathValue = this.createEmptySign(iSignTouchViewProvider);
            }
            if ((iSignPathEditableValue = iSignPathValue.toEditable()) != null) {
                iSignPathEditableValue.createEditableSignPath(this.mSignAreaRatio);
                iSignTouchWork.onApplyValue(iSignPathEditableValue);
                if (bl2) {
                    iSignTouchViewProvider.setSignValue(iSignPathValue);
                } else {
                    iSignTouchViewProvider.drawNewLine(iSignTouchWork.getValue());
                }
                iSignTouchViewProvider.setChanged();
                iSignTouchViewProvider.callValueAppend();
            }
        }
    }

    private void onEraseAll(ISignTouchViewProvider iSignTouchViewProvider) {
        this.mErasePath = null;
        iSignTouchViewProvider.setSignValue(null);
        iSignTouchViewProvider.setChanged();
        iSignTouchViewProvider.callValueDeleted();
        iSignTouchViewProvider.getView().needFullInvalidate();
    }

    private void onErase(ISignTouchViewProvider iSignTouchViewProvider) {
        ISignPathEditableValue iSignPathEditableValue;
        ISignPathValue iSignPathValue = iSignTouchViewProvider.getView().getSignValue();
        if (iSignPathValue != null && (iSignPathEditableValue = iSignPathValue.toEditable()) != null && iSignPathEditableValue.getEditableSignPath() == this.mErasePath) {
            iSignPathEditableValue.commit();
            iSignTouchViewProvider.setChanged();
            iSignTouchViewProvider.callValueDeleted();
            iSignTouchViewProvider.getView().needFullInvalidate();
        }
    }

    private void completeTouchEvent() {
        this.mErasePath = null;
    }

    public ISignTouchWork processTouchEventPointer(ISignTouchViewProvider iSignTouchViewProvider, MotionEvent motionEvent, int n) {
        ISignTouchWork iSignTouchWork;
        int n2 = motionEvent.getPointerId(n);
        int n3 = motionEvent.getToolType(n);
        boolean bl = this.mEraseMode && this.mErasePath == null;
        boolean bl2 = this.isAllowTool(n3) && !bl;
        float f2 = (motionEvent.getX(n) + (float)iSignTouchViewProvider.getView().getScrollX() - (float)this.mSignArea.left) / (float)this.mSignArea.width();
        float f3 = (motionEvent.getY(n) + (float)iSignTouchViewProvider.getView().getScrollY() - (float)this.mSignArea.top) / (float)this.mSignArea.height();
        if (bl2 && (f2 < 0.0f || f3 < 0.0f || f2 > 1.0f || f3 > 1.0f)) {
            bl2 = false;
        }
        ISignTouchWork iSignTouchWork2 = iSignTouchWork = bl2 ? this.tryGetTouchWork(n, n2, this.mEraseMode) : this.getTouchWork(n2);
        if (iSignTouchWork != null) {
            boolean bl3 = n3 == 2 && this.mUsePressure && (this.mFirstTouchWork == null || this.mFirstTouchWorkUsePressure);
            SignTouchData signTouchData = new SignTouchData();
            signTouchData.id = n2;
            signTouchData.event = motionEvent;
            signTouchData.active = n == this.mActionIndex;
            signTouchData.action = this.mAction;
            signTouchData.x = f2;
            signTouchData.y = f3;
            signTouchData.p = bl3 ? motionEvent.getPressure(n) : 0.5f;
            signTouchData.t = this.mTime;
            signTouchData.renderType = bl3 ? 1 : 0;
            signTouchData.erase = iSignTouchViewProvider.getView().isEraseMode();
            signTouchData.eraseCount = 0;
            signTouchData.erasePath = this.mErasePath;
            if (signTouchData.active) {
                if (this.mIsDown) {
                    if (signTouchData.x > 0.0f && signTouchData.y > 0.0f) {
                        iSignTouchViewProvider.callTouchDown(signTouchData.x, signTouchData.y);
                        iSignTouchWork.onDown(signTouchData);
                    } else {
                        this.removeTouchWork(n2);
                    }
                } else if (this.mIsMove) {
                    iSignTouchWork.onMove(signTouchData);
                } else if (this.mIsUp) {
                    iSignTouchViewProvider.callTouchUp(signTouchData.x, signTouchData.y);
                    iSignTouchWork.onUp(signTouchData);
                } else if (this.mIsCancel) {
                    iSignTouchWork.onCancel(signTouchData);
                }
            } else if (this.mIsCancel) {
                iSignTouchWork.onCancel(signTouchData);
            } else {
                iSignTouchWork.onMove(signTouchData);
            }
            if (signTouchData.eraseCount > 0) {
                this.mTotalEraseCount += signTouchData.eraseCount;
                if (signTouchData.erasePath != null && signTouchData.erasePath.isEmptyPath()) {
                    this.onEraseAll(iSignTouchViewProvider);
                }
            }
        }
        return iSignTouchWork;
    }

    private void checkFirstPathWork(ISignTouchWork iSignTouchWork) {
        OZSignPath oZSignPath;
        ISignPathValue iSignPathValue;
        boolean bl;
        boolean bl2 = bl = this.mEmptyPathValue && this.mFirstTouchWork == null && iSignTouchWork != null;
        if (bl && (iSignPathValue = iSignTouchWork.getValue()) != null && (oZSignPath = iSignPathValue.getValueAsSignPath()) != null && !oZSignPath.isRecycled()) {
            this.mFirstTouchWork = iSignTouchWork;
            this.mFirstTouchWorkUsePressure = oZSignPath.getMeta().getRenderType() == 1;
        }
    }

    private boolean isAllowTool(int n) {
        if (n == 2) {
            return this.mCanStylusInput;
        }
        if (n == 4) {
            return false;
        }
        return this.mCanHandInput;
    }

    private ISignTouchWork tryGetTouchWork(int n, int n2, boolean bl) {
        ISignTouchWork iSignTouchWork = this.getTouchWork(n2);
        if (iSignTouchWork == null && this.mIsDown && this.mActionIndex == n2 && this.canAddTouchWork()) {
            boolean bl2;
            boolean bl3 = bl2 = this.mIgnoreTouch || this.mEraseMode && this.mErasePath == null;
            if (!bl2) {
                iSignTouchWork = bl ? new SignTouchEraseWork() : new SignTouchDrawWork();
                this.addTouchWork(n2, iSignTouchWork);
            }
        }
        return iSignTouchWork;
    }

    private ISignTouchWork getTouchWork(int n) {
        if (this.mTouchWorks != null) {
            return (ISignTouchWork)this.mTouchWorks.get(n);
        }
        return null;
    }

    private boolean canAddTouchWork() {
        int n = 0;
        if (this.mTouchWorks != null) {
            n = this.mTouchWorks.size();
        }
        return this.getMaximumTouchWorkCount() > n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTouchWork(int n, ISignTouchWork iSignTouchWork) {
        if (this.mTouchWorks == null) {
            this.mTouchWorks = new SparseArray();
        }
        SparseArray sparseArray = this.mTouchWorks;
        synchronized (sparseArray) {
            this.mTouchWorks.put(n, (Object)iSignTouchWork);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTouchWork(int n) {
        if (this.mTouchWorks != null) {
            SparseArray sparseArray = this.mTouchWorks;
            synchronized (sparseArray) {
                ISignTouchWork iSignTouchWork = (ISignTouchWork)this.mTouchWorks.get(n);
                this.mTouchWorks.remove(n);
                if (iSignTouchWork != null) {
                    if (iSignTouchWork == this.mFirstTouchWork) {
                        this.mFirstTouchWork = null;
                    }
                    iSignTouchWork.onRemoved();
                }
            }
        }
    }

    protected int getMaximumTouchWorkCount() {
        return 1;
    }
}

