/*
 * Decompiled with CFR 0.152.
 */
package oz.util.signpath.view.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.util.zip.GZIPInputStream;
import oz.util.signpath.OZSignPath;

public class OZBase64Loader {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_INVALID_BASE64_DATA = 1;
    public static final int ERROR_UNKNOWN_DATA = 2;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_IMAGE = 1;
    public static final int TYPE_OZVP_PATH = 2;
    public static final int TYPE_OZPT_TEXT = 4;
    public static final int TYPE_BASE64_UNKNOWN = 16;
    public static final int TYPE_BASE64_IMAGE = 17;
    public static final int TYPE_OZDPI_IMAGE = 33;
    public static final int TYPE_OZDPI_UNKNOWN = 32;
    public static final int TYPE_GZIP_IMAGE = 33;
    public static final int TYPE_GZIP_UNKNOWN = 32;
    public Object result;
    public int errorCode;
    public int type;
    public int dpi;

    public void parse(String string) {
        if (string != null && !string.isEmpty()) {
            if (string.startsWith("data:")) {
                int n = string.indexOf(";");
                if (n > -1) {
                    this.parse_OZGZIP(string);
                    if (this.errorCode != 0) {
                        String string2 = string.substring(5, n).trim().toLowerCase();
                        if (string2.startsWith("image/ozdpi,")) {
                            int n2 = 0;
                            try {
                                n2 = Integer.parseInt(string.substring(17, n));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.parse_OZGZIP(string.substring(n));
                            if (this.errorCode == 0) {
                                this.setResultDPI(this.result, 0x20 | this.type & 0xF, n2);
                            }
                        } else if (string2.equals("image/ozvp")) {
                            this.setResult(new OZSignPath(string), 2);
                        } else if (string2.equals("image/ozpt")) {
                            this.setResult(string.substring(n), 4);
                        } else {
                            byte[] byArray = this.getBase64(string.substring(n));
                            if (byArray != null) {
                                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                                if (bitmap != null) {
                                    this.setResult(bitmap, 17);
                                } else {
                                    this.setResult(null, 16);
                                }
                            } else {
                                this.setError(1);
                            }
                        }
                    }
                } else {
                    this.setError(1);
                }
            } else {
                this.setError(2);
            }
        } else {
            this.setError(2);
        }
    }

    private byte[] getBase64(String string) {
        String string2 = string;
        if (string.startsWith("base64,")) {
            string2 = string.substring(7);
        }
        byte[] byArray = null;
        try {
            byArray = Base64.decode((String)string2, (int)1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byArray;
    }

    private void parse_OZGZIP(String string) {
        int n = 0;
        String string2 = "data:application/x-gzip-compressed;base64,";
        if (string.startsWith(string2)) {
            byte[] byArray = this.getBase64(string.substring(string2.length()));
            if (byArray != null) {
                GZIPInputStream gZIPInputStream = null;
                try {
                    gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (gZIPInputStream != null) {
                    Bitmap bitmap = BitmapFactory.decodeStream(gZIPInputStream);
                    if (bitmap != null) {
                        this.setResult(bitmap, 33);
                    } else {
                        this.setResult(null, 32);
                    }
                } else {
                    n = 1;
                }
            } else {
                n = 1;
            }
        } else {
            n = 2;
        }
        if (n != 0) {
            this.setError(n);
        }
    }

    private void setError(int n) {
        this.errorCode = n;
        this.type = 0;
        this.result = null;
        this.dpi = 0;
    }

    private void setResult(Object object, int n) {
        this.result = object;
        this.type = n;
        this.dpi = 0;
    }

    private void setResultDPI(Object object, int n, int n2) {
        this.result = object;
        this.type = n;
        this.dpi = 0;
    }

    public boolean hasImage() {
        return (this.type & 1) == 1;
    }

    public boolean hasPath() {
        return (this.type & 2) == 2;
    }

    public boolean hasString() {
        return (this.type & 4) == 4;
    }

    public Bitmap getAsImage() {
        if (this.result != null && this.result instanceof Bitmap) {
            return (Bitmap)this.result;
        }
        return null;
    }

    public OZSignPath getAsPath() {
        if (this.result != null && this.result instanceof OZSignPath) {
            return (OZSignPath)this.result;
        }
        return null;
    }

    public String getAsString() {
        if (this.result != null && this.result instanceof String) {
            return (String)this.result;
        }
        return null;
    }
}

