/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oz.util.view.camera.Camera2Manager$1;
import oz.util.view.camera.Camera2Manager$10;
import oz.util.view.camera.Camera2Manager$11;
import oz.util.view.camera.Camera2Manager$2;
import oz.util.view.camera.Camera2Manager$3;
import oz.util.view.camera.Camera2Manager$4;
import oz.util.view.camera.Camera2Manager$5;
import oz.util.view.camera.Camera2Manager$6;
import oz.util.view.camera.Camera2Manager$7;
import oz.util.view.camera.Camera2Manager$8;
import oz.util.view.camera.Camera2Manager$9;
import oz.util.view.camera.Camera2Manager$CompareSizesByArea;
import oz.util.view.camera.Camera2Manager$ImageSaver;
import oz.util.view.camera.Camera2Manager$ImageSaver$ImageSaverBuilder;
import oz.util.view.camera.Camera2Manager$OnCamera2ManagerListener;
import oz.util.view.camera.Camera2Manager$RefCountedAutoCloseable;
import oz.util.view.camera.Camera2PreviewView;
import oz.util.view.camera.CameraBoxViewBase;
import oz.util.view.camera.CameraUtil;
import oz.util.view.camera.CameraView;

public class Camera2Manager {
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();
    private static final long PRECAPTURE_TIMEOUT_MS = 1000L;
    private static final double ASPECT_RATIO_TOLERANCE = 0.005;
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    private static final int STATE_CLOSED = 0;
    private static final int STATE_OPENED = 1;
    private static final int STATE_PREVIEW = 2;
    private static final int STATE_WAITING_FOR_3A_CONVERGENCE = 3;
    private OrientationEventListener mOrientationListener;
    private final TextureView.SurfaceTextureListener mSurfaceTextureListener = new Camera2Manager$1(this);
    private Camera2PreviewView mTextureView;
    private CameraBoxViewBase mBoxView;
    private CameraView mCameraView;
    private boolean mUseSaveFile;
    private boolean mUseSaveJPG;
    private boolean mUseSaveDNG;
    private boolean mTryTakePicture;
    private String ozCameraID = "0";
    private int ozFlashMode = 0;
    private int idCount;
    private boolean mIsAbleFlash = false;
    private Camera2Manager$OnCamera2ManagerListener mCamera2ManagerListener;
    private HandlerThread mBackgroundThread;
    private final AtomicInteger mRequestCounter = new AtomicInteger();
    private final Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private final Object mCameraStateLock = new Object();
    private String mCameraId;
    private CameraCaptureSession mCaptureSession;
    private CameraDevice mCameraDevice;
    private Size mPreviewSize;
    private CameraCharacteristics mCharacteristics;
    private Handler mBackgroundHandler;
    private Camera2Manager$RefCountedAutoCloseable mPreviewImageReader;
    private Camera2Manager$RefCountedAutoCloseable mJpegImageReader;
    private Camera2Manager$RefCountedAutoCloseable mRawImageReader;
    private boolean mNoAFRun = false;
    private int mPendingUserCaptures = 0;
    private final TreeMap mJpegResultQueue = new TreeMap();
    private final TreeMap mRawResultQueue = new TreeMap();
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private int mState = 0;
    private long mCaptureTimer;
    private final CameraDevice.StateCallback mStateCallback = new Camera2Manager$2(this);
    private final ImageReader.OnImageAvailableListener mOnPreviewImageAvailableListener = new Camera2Manager$3(this);
    private final ImageReader.OnImageAvailableListener mOnJpegImageAvailableListener = new Camera2Manager$4(this);
    private final ImageReader.OnImageAvailableListener mOnRawImageAvailableListener = new Camera2Manager$5(this);
    private CameraCaptureSession.CaptureCallback mPreCaptureCallback = new Camera2Manager$6(this);
    private final CameraCaptureSession.CaptureCallback mCaptureCallbackPreview = new Camera2Manager$7(this);
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new Camera2Manager$8(this);
    private final Handler mMessageHandler = new Camera2Manager$9(this, Looper.getMainLooper());
    private boolean mManualFocusEngaged;

    public void setCamera2ManagerListener(Camera2Manager$OnCamera2ManagerListener camera2Manager$OnCamera2ManagerListener) {
        this.mCamera2ManagerListener = camera2Manager$OnCamera2ManagerListener;
    }

    public Camera2Manager(CameraView cameraView) {
        this.mCameraView = cameraView;
        this.mTextureView = cameraView.getCameraPreviewView();
        this.mBoxView = cameraView.getBoxView();
        this.mUseSaveJPG = true;
        this.mUseSaveDNG = false;
        this.mUseSaveFile = false;
    }

    public int getCameraID() {
        return Integer.parseInt(this.ozCameraID);
    }

    public void setCameraID(int n) {
        this.ozCameraID = String.valueOf(n);
    }

    public void setFlashMode(int n) {
        this.ozFlashMode = n;
    }

    public int switchCamera() {
        if (this.ozCameraID.equals("0")) {
            this.ozCameraID = "1";
            this.closeCamera();
            this.reopenCamera();
        } else if (this.ozCameraID.equals("1")) {
            this.ozCameraID = "0";
            this.closeCamera();
            this.reopenCamera();
        }
        return Integer.parseInt(this.ozCameraID);
    }

    private void setAeMode(int n) {
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)n);
        try {
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mPreCaptureCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    public void swtichFlash() {
        if (this.ozFlashMode == 0) {
            this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            this.setAeMode(1);
            this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
        } else if (this.ozFlashMode == 1) {
            this.setAeMode(1);
            this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)1);
        } else if (this.ozFlashMode == 2) {
            if (Camera2Manager.contains((int[])this.mCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES), 2)) {
                this.setAeMode(2);
            } else {
                this.setAeMode(1);
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)1);
        }
    }

    public void reopenCamera() {
        if (this.mTextureView.isAvailable()) {
            this.openCamera();
        } else {
            this.mTextureView.setSurfaceTextureListener(this.mSurfaceTextureListener);
        }
    }

    public Activity getActivity() {
        return (Activity)this.mTextureView.getContext();
    }

    public boolean isRunningCamera() {
        return this.mBackgroundThread != null && this.mBackgroundThread.isAlive();
    }

    public boolean isAbleFlash() {
        return this.mIsAbleFlash;
    }

    public int getIDCount() {
        return this.idCount;
    }

    public void onResume() {
        if (!this.isRunningCamera()) {
            this.startBackgroundThread();
            this.openCamera();
            if (this.mTextureView.isAvailable()) {
                this.configureTransform(this.mTextureView.getWidth(), this.mTextureView.getHeight());
            } else {
                this.mTextureView.setSurfaceTextureListener(this.mSurfaceTextureListener);
            }
            if (this.mOrientationListener != null && this.mOrientationListener.canDetectOrientation()) {
                this.mOrientationListener.enable();
            }
        }
    }

    public void onPause() {
        if (this.isRunningCamera()) {
            if (this.mOrientationListener != null) {
                this.mOrientationListener.disable();
            }
            this.closeCamera();
            this.stopBackgroundThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setUpCameraOutputs() {
        Activity activity = this.getActivity();
        CameraManager cameraManager = (CameraManager)activity.getSystemService("camera");
        if (cameraManager == null) {
            CameraUtil.e("This device doesn't support Camera2 API.");
            return false;
        }
        try {
            CameraCharacteristics cameraCharacteristics;
            boolean bl = false;
            this.idCount = cameraManager.getCameraIdList().length;
            for (String string : cameraManager.getCameraIdList()) {
                cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
                if (!string.equals(this.ozCameraID)) continue;
                bl = true;
            }
            if (bl) {
                CameraCharacteristics cameraCharacteristics2 = cameraManager.getCameraCharacteristics(this.ozCameraID);
                Boolean bl2 = (Boolean)cameraCharacteristics2.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                this.mIsAbleFlash = bl2 == null ? false : bl2;
                Object object = this.mCameraStateLock;
                synchronized (object) {
                    this.mCharacteristics = cameraCharacteristics2;
                    this.mCameraId = this.ozCameraID;
                }
                return true;
            }
            for (String string : cameraManager.getCameraIdList()) {
                cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
                if (this.mUseSaveDNG && !Camera2Manager.contains((int[])cameraCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES), 3)) continue;
                Boolean bl3 = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                this.mIsAbleFlash = bl3 == null ? false : bl3;
                Object object = this.mCameraStateLock;
                synchronized (object) {
                    this.mCharacteristics = cameraCharacteristics;
                    this.mCameraId = string;
                }
                return true;
            }
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
        CameraUtil.e("This device doesn't support capturing RAW photos");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCamera() {
        if (!this.setUpCameraOutputs()) {
            return;
        }
        Activity activity = this.getActivity();
        CameraManager cameraManager = (CameraManager)activity.getSystemService("camera");
        try {
            Handler handler;
            String string;
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            Object object = this.mCameraStateLock;
            synchronized (object) {
                string = this.mCameraId;
                handler = this.mBackgroundHandler;
            }
            cameraManager.openCamera(string, this.mStateCallback, handler);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCamera() {
        try {
            this.mCameraOpenCloseLock.acquire();
            Object object = this.mCameraStateLock;
            synchronized (object) {
                this.mPendingUserCaptures = 0;
                this.mState = 0;
                if (null != this.mCaptureSession) {
                    this.mCaptureSession.close();
                    this.mCaptureSession = null;
                }
                if (null != this.mCameraDevice) {
                    this.mCameraDevice.close();
                    this.mCameraDevice = null;
                }
                if (null != this.mPreviewImageReader) {
                    this.mPreviewImageReader.close();
                    this.mPreviewImageReader = null;
                }
                if (null != this.mJpegImageReader) {
                    this.mJpegImageReader.close();
                    this.mJpegImageReader = null;
                }
                if (null != this.mRawImageReader) {
                    this.mRawImageReader.close();
                    this.mRawImageReader = null;
                }
                if (this.mJpegResultQueue != null) {
                    this.mJpegResultQueue.clear();
                }
                if (this.mRawResultQueue != null) {
                    this.mRawResultQueue.clear();
                }
                this.mTryTakePicture = false;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", interruptedException);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        Object object = this.mCameraStateLock;
        synchronized (object) {
            this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread() {
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            Object object = this.mCameraStateLock;
            synchronized (object) {
                this.mBackgroundHandler = null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void createCameraPreviewSessionLocked() {
        try {
            List<Size> list;
            Size[] sizeArray;
            SurfaceTexture surfaceTexture = this.mTextureView.getSurfaceTexture();
            surfaceTexture.setDefaultBufferSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
            boolean bl = this.mCameraView.isUsePreviewListener();
            Surface surface = new Surface(surfaceTexture);
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            float f2 = (float)this.mPreviewSize.getWidth() / (float)this.mPreviewSize.getHeight();
            Size[] sizeArray2 = null;
            List<Size> list2 = Arrays.asList(streamConfigurationMap.getOutputSizes(256));
            Collections.sort(list2, new Camera2Manager$CompareSizesByArea());
            for (int j = list2.size() - 1; j >= 0; --j) {
                sizeArray = list2.get(j);
                if ((float)sizeArray.getWidth() / (float)sizeArray.getHeight() != f2) continue;
                sizeArray2 = sizeArray;
                break;
            }
            if (sizeArray2 == null) {
                sizeArray2 = list2.get(0);
            }
            Size size = null;
            sizeArray = streamConfigurationMap.getOutputSizes(32);
            if (sizeArray != null) {
                list = Arrays.asList(sizeArray);
                Collections.sort(list, new Camera2Manager$CompareSizesByArea());
                for (int j = list.size() - 1; j >= 0; --j) {
                    Size size2 = list.get(j);
                    if ((float)size2.getWidth() / (float)size2.getHeight() != f2) continue;
                    size = size2;
                    break;
                }
                if (size == null) {
                    size = list.get(0);
                }
            } else {
                this.mUseSaveDNG = false;
                if (size == null) {
                    size = this.mPreviewSize;
                }
            }
            if (this.mJpegImageReader == null || this.mJpegImageReader.getAndRetain() == null) {
                this.mJpegImageReader = new Camera2Manager$RefCountedAutoCloseable((AutoCloseable)ImageReader.newInstance((int)sizeArray2.getWidth(), (int)sizeArray2.getHeight(), (int)256, (int)5));
            }
            ((ImageReader)this.mJpegImageReader.get()).setOnImageAvailableListener(this.mOnJpegImageAvailableListener, this.mBackgroundHandler);
            if (this.mRawImageReader == null || this.mRawImageReader.getAndRetain() == null) {
                this.mRawImageReader = new Camera2Manager$RefCountedAutoCloseable((AutoCloseable)ImageReader.newInstance((int)size.getWidth(), (int)size.getHeight(), (int)32, (int)5));
                ((ImageReader)this.mRawImageReader.get()).setOnImageAvailableListener(this.mOnRawImageAvailableListener, this.mBackgroundHandler);
            }
            if (this.mPreviewImageReader == null || this.mPreviewImageReader.getAndRetain() == null) {
                this.mPreviewImageReader = new Camera2Manager$RefCountedAutoCloseable((AutoCloseable)ImageReader.newInstance((int)this.mPreviewSize.getWidth(), (int)this.mPreviewSize.getHeight(), (int)35, (int)2));
            }
            ((ImageReader)this.mPreviewImageReader.get()).setOnImageAvailableListener(this.mOnPreviewImageAvailableListener, this.mBackgroundHandler);
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.addTarget(surface);
            if (bl) {
                this.mPreviewRequestBuilder.addTarget(((ImageReader)this.mPreviewImageReader.get()).getSurface());
            }
            list = new ArrayList<Size>();
            ((ArrayList)list).add((Size)surface);
            if (this.mUseSaveJPG) {
                ((ArrayList)list).add((Size)((ImageReader)this.mJpegImageReader.get()).getSurface());
            }
            if (this.mUseSaveDNG) {
                ((ArrayList)list).add((Size)((ImageReader)this.mRawImageReader.get()).getSurface());
            }
            ((ArrayList)list).add((Size)((ImageReader)this.mPreviewImageReader.get()).getSurface());
            this.mCameraDevice.createCaptureSession(list, (CameraCaptureSession.StateCallback)new Camera2Manager$10(this), this.mBackgroundHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setup3AControlsLocked(CaptureRequest.Builder builder) {
        builder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        Float f2 = (Float)this.mCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        boolean bl = this.mNoAFRun = f2 == null || f2.floatValue() == 0.0f;
        if (!this.mNoAFRun) {
            if (Camera2Manager.contains((int[])this.mCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES), 4)) {
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            } else {
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            }
        }
        if (Camera2Manager.contains((int[])this.mCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES), 1)) {
            builder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configureTransform(int n, int n2) {
        CameraUtil.d("configureTransform ");
        Activity activity = this.getActivity();
        Object object = this.mCameraStateLock;
        synchronized (object) {
            float f2;
            boolean bl;
            if (null == this.mTextureView || null == activity) {
                return;
            }
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Size size = Collections.max(Arrays.asList(streamConfigurationMap.getOutputSizes(256)), new Camera2Manager$CompareSizesByArea());
            int n3 = activity.getWindowManager().getDefaultDisplay().getRotation();
            Point point = new Point();
            activity.getWindowManager().getDefaultDisplay().getSize(point);
            int n4 = Camera2Manager.sensorToDeviceRotation(this.mCharacteristics, n3);
            boolean bl2 = n4 == 90 || n4 == 270;
            int n5 = n;
            int n6 = n2;
            int n7 = point.x;
            int n8 = point.y;
            if (bl2) {
                n5 = n2;
                n6 = n;
                n7 = point.y;
                n8 = point.x;
            }
            if (n7 > 1920) {
                n7 = 1920;
            }
            if (n8 > 1080) {
                n8 = 1080;
            }
            Size size2 = Camera2Manager.chooseOptimalSize(streamConfigurationMap.getOutputSizes(SurfaceTexture.class), n5, n6, n7, n8, size);
            if (bl2) {
                this.mTextureView.setAspectRatio(size2.getHeight(), size2.getWidth());
            } else {
                this.mTextureView.setAspectRatio(size2.getWidth(), size2.getHeight());
            }
            int n9 = (Integer)this.mCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0 ? (360 + ORIENTATIONS.get(n3)) % 360 : (360 - ORIENTATIONS.get(n3)) % 360;
            Matrix matrix = new Matrix();
            RectF rectF = new RectF(0.0f, 0.0f, (float)n, (float)n2);
            RectF rectF2 = new RectF(0.0f, 0.0f, (float)size2.getHeight(), (float)size2.getWidth());
            float f3 = rectF.centerX();
            float f4 = rectF.centerY();
            boolean bl3 = bl = n9 == 90 || n9 == 270;
            if (this.mBoxView != null) {
                f2 = 0.0f;
                if (bl) {
                    this.mBoxView.getWholeRect().set(0.0f, 0.0f, rectF2.bottom, rectF2.right);
                    f2 = Math.min((float)this.mBoxView.getHeight() / (float)size2.getHeight(), (float)this.mBoxView.getWidth() / (float)size2.getWidth());
                } else {
                    this.mBoxView.getWholeRect().set(rectF2);
                    f2 = Math.min((float)this.mBoxView.getWidth() / (float)size2.getHeight(), (float)this.mBoxView.getHeight() / (float)size2.getWidth());
                }
                this.mBoxView.getWholeRect().right *= f2;
                this.mBoxView.getWholeRect().bottom *= f2;
                float f5 = (float)this.mBoxView.getWidth() - this.mBoxView.getWholeRect().width();
                float f6 = (float)this.mBoxView.getHeight() - this.mBoxView.getWholeRect().height();
                this.mBoxView.getWholeRect().offset(f5 / 2.0f, f6 / 2.0f);
                this.mBoxView.getOutRect().set(this.mBoxView.getWholeRect());
                this.mBoxView.getOutRect().inset(50.0f, 50.0f);
                this.mBoxView.updateInRect(this.mCameraView.getTargetRatio());
                this.mBoxView.setBackground(null);
                this.mBoxView.setBoxBitmap(null, 0, null);
                this.mBoxView.setDrawInRect(true);
            }
            if (1 == n3 || 3 == n3) {
                rectF2.offset(f3 - rectF2.centerX(), f4 - rectF2.centerY());
                matrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.FILL);
                f2 = Math.max((float)n2 / (float)size2.getHeight(), (float)n / (float)size2.getWidth());
                matrix.postScale(f2, f2, f3, f4);
            }
            matrix.postRotate((float)n9, f3, f4);
            if (this.ozCameraID.equals("1") && (1 == n3 || 3 == n3)) {
                rectF2.offset(f3 - rectF2.centerX(), f4 - rectF2.centerY());
                matrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.FILL);
                f2 = Math.max((float)n2 / (float)size2.getHeight(), (float)n / (float)size2.getWidth());
                matrix.postScale(f2, f2, f3, f4);
                int n10 = n3 == 1 ? -90 : 90;
                matrix.postRotate((float)n10, f3, f4);
            }
            this.mTextureView.setTransform(matrix);
            if (this.mPreviewSize == null || !Camera2Manager.checkAspectsEqual(size2, this.mPreviewSize)) {
                this.mPreviewSize = size2;
                if (this.mState != 0) {
                    this.createCameraPreviewSessionLocked();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture() {
        if (!this.mTryTakePicture) {
            Object object = this.mCameraStateLock;
            synchronized (object) {
                if (this.mState != 2) {
                    return;
                }
                this.mTryTakePicture = true;
                ++this.mPendingUserCaptures;
                try {
                    this.swtichFlash();
                    if (!this.mNoAFRun) {
                        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                    }
                    if (!this.isLegacyLocked()) {
                        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
                    }
                    this.mState = 3;
                    this.startTimerLocked();
                    this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mPreCaptureCallback, this.mBackgroundHandler);
                }
                catch (CameraAccessException cameraAccessException) {
                    cameraAccessException.printStackTrace();
                }
            }
        }
    }

    public boolean onTouch(View view, int n, float f2, float f3) {
        if (n != 0) {
            return false;
        }
        return this.autoFocus(view, f2, f3);
    }

    private boolean isMeteringAreaAFSupported() {
        return (Integer)this.mCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF) >= 1;
    }

    private void captureStillPictureLocked() {
        try {
            Activity activity = this.getActivity();
            if (null == activity || null == this.mCameraDevice) {
                return;
            }
            CaptureRequest.Builder builder = this.mCameraDevice.createCaptureRequest(2);
            if (this.mUseSaveJPG) {
                builder.addTarget(((ImageReader)this.mJpegImageReader.get()).getSurface());
            }
            if (this.mUseSaveDNG) {
                builder.addTarget(((ImageReader)this.mRawImageReader.get()).getSurface());
            }
            this.setup3AControlsLocked(builder);
            int n = activity.getWindowManager().getDefaultDisplay().getRotation();
            builder.set(CaptureRequest.JPEG_ORIENTATION, (Object)Camera2Manager.sensorToDeviceRotation(this.mCharacteristics, n));
            builder.setTag((Object)this.mRequestCounter.getAndIncrement());
            CaptureRequest captureRequest = builder.build();
            Camera2Manager$ImageSaver$ImageSaverBuilder camera2Manager$ImageSaver$ImageSaverBuilder = new Camera2Manager$ImageSaver$ImageSaverBuilder((Context)activity).setCharacteristics(this.mCharacteristics);
            Camera2Manager$ImageSaver$ImageSaverBuilder camera2Manager$ImageSaver$ImageSaverBuilder2 = new Camera2Manager$ImageSaver$ImageSaverBuilder((Context)activity).setCharacteristics(this.mCharacteristics);
            if (this.mUseSaveJPG) {
                this.mJpegResultQueue.put((Integer)captureRequest.getTag(), camera2Manager$ImageSaver$ImageSaverBuilder);
            }
            if (this.mUseSaveDNG) {
                this.mRawResultQueue.put((Integer)captureRequest.getTag(), camera2Manager$ImageSaver$ImageSaverBuilder2);
            }
            this.mCaptureSession.capture(captureRequest, this.mCaptureCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    private void finishedCaptureLocked() {
        try {
            if (!this.mNoAFRun) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mPreCaptureCallback, this.mBackgroundHandler);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            }
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeueAndSaveImage(TreeMap treeMap, Camera2Manager$RefCountedAutoCloseable camera2Manager$RefCountedAutoCloseable) {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            Map.Entry entry = treeMap.firstEntry();
            if (entry != null) {
                Image image;
                Camera2Manager$ImageSaver$ImageSaverBuilder camera2Manager$ImageSaver$ImageSaverBuilder = (Camera2Manager$ImageSaver$ImageSaverBuilder)entry.getValue();
                if (camera2Manager$RefCountedAutoCloseable == null || camera2Manager$RefCountedAutoCloseable.getAndRetain() == null) {
                    CameraUtil.e("Paused the activity before we could save the image, ImageReader already closed.");
                    treeMap.remove(entry.getKey());
                    return;
                }
                try {
                    image = ((ImageReader)camera2Manager$RefCountedAutoCloseable.get()).acquireNextImage();
                }
                catch (IllegalStateException illegalStateException) {
                    CameraUtil.e("Too many images queued for saving, dropping image for request: " + entry.getKey());
                    treeMap.remove(entry.getKey());
                    return;
                }
                camera2Manager$ImageSaver$ImageSaverBuilder.setRefCountedReader(camera2Manager$RefCountedAutoCloseable).setImage(image);
                this.handleCompletionLocked((Integer)entry.getKey(), camera2Manager$ImageSaver$ImageSaverBuilder, treeMap);
            } else {
                try {
                    ((ImageReader)camera2Manager$RefCountedAutoCloseable.get()).acquireNextImage().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static Size chooseOptimalSize(Size[] sizeArray, int n, int n2, int n3, int n4, Size size) {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        ArrayList<Size> arrayList2 = new ArrayList<Size>();
        int n5 = size.getWidth();
        int n6 = size.getHeight();
        for (Size size2 : sizeArray) {
            if (size2.getWidth() > n3 || size2.getHeight() > n4 || size2.getHeight() != size2.getWidth() * n6 / n5) continue;
            if (size2.getWidth() >= n && size2.getHeight() >= n2) {
                arrayList.add(size2);
                continue;
            }
            arrayList2.add(size2);
        }
        if (arrayList.size() > 0) {
            return (Size)Collections.min(arrayList, new Camera2Manager$CompareSizesByArea());
        }
        if (arrayList2.size() > 0) {
            return (Size)Collections.max(arrayList2, new Camera2Manager$CompareSizesByArea());
        }
        CameraUtil.e("Couldn't find any suitable preview size");
        return sizeArray[0];
    }

    private static String generateTimestamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS", Locale.US);
        return simpleDateFormat.format(new Date());
    }

    private static void closeOutput(OutputStream outputStream) {
        if (null != outputStream) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static boolean contains(int[] nArray, int n) {
        if (nArray == null) {
            return false;
        }
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private static boolean checkAspectsEqual(Size size, Size size2) {
        double d2;
        double d3 = (double)size.getWidth() / (double)size.getHeight();
        return Math.abs(d3 - (d2 = (double)size2.getWidth() / (double)size2.getHeight())) <= 0.005;
    }

    private static int sensorToDeviceRotation(CameraCharacteristics cameraCharacteristics, int n) {
        int n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        n = ORIENTATIONS.get(n);
        if ((Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0) {
            n = -n;
        }
        return (n2 - n + 360) % 360;
    }

    private void showToast(String string) {
        CameraUtil.d(string);
    }

    private void handleCompletionLocked(int n, Camera2Manager$ImageSaver$ImageSaverBuilder camera2Manager$ImageSaver$ImageSaverBuilder, TreeMap treeMap) {
        if (camera2Manager$ImageSaver$ImageSaverBuilder == null) {
            return;
        }
        Camera2Manager$ImageSaver camera2Manager$ImageSaver = camera2Manager$ImageSaver$ImageSaverBuilder.buildIfComplete();
        boolean bl = false;
        if (camera2Manager$ImageSaver != null) {
            treeMap.remove(n);
            if (!this.mUseSaveFile) {
                if (this.mCameraView.needTakePicture()) {
                    bl = false;
                    this.mCameraView.OnTakePicture(Camera2Manager$ImageSaver.access$3400(camera2Manager$ImageSaver), Camera2Manager.sensorToDeviceRotation(this.mCharacteristics, this.getActivity().getWindowManager().getDefaultDisplay().getRotation()));
                }
            } else {
                bl = false;
                AsyncTask.THREAD_POOL_EXECUTOR.execute(camera2Manager$ImageSaver);
            }
        } else if (Camera2Manager$ImageSaver$ImageSaverBuilder.access$3500(camera2Manager$ImageSaver$ImageSaverBuilder) != null && !this.mUseSaveFile && this.mCameraView.needTakePicture()) {
            this.mCameraView.onTakePictureFailed("failed check condition");
        }
        if (bl && camera2Manager$ImageSaver$ImageSaverBuilder != null && Camera2Manager$ImageSaver$ImageSaverBuilder.access$3500(camera2Manager$ImageSaver$ImageSaverBuilder) != null) {
            try {
                Camera2Manager$ImageSaver$ImageSaverBuilder.access$3500(camera2Manager$ImageSaver$ImageSaverBuilder).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean isLegacyLocked() {
        return (Integer)this.mCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) == 2;
    }

    private void startTimerLocked() {
        this.mCaptureTimer = SystemClock.elapsedRealtime();
    }

    private boolean hitTimeoutLocked() {
        return SystemClock.elapsedRealtime() - this.mCaptureTimer > 1000L;
    }

    public boolean autoFocus() {
        float f2 = this.mCameraView.getWidth() / 2;
        float f3 = this.mCameraView.getHeight() / 2;
        return this.autoFocus((View)this.mCameraView, f2, f3);
    }

    private boolean autoFocus(View view, float f2, float f3) {
        if (this.mManualFocusEngaged) {
            CameraUtil.d("Manual focus already engaged");
            return false;
        }
        Rect rect = (Rect)this.mCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        int n = (int)(f2 / (float)view.getWidth() * (float)rect.height());
        int n2 = (int)(f3 / (float)view.getHeight() * (float)rect.width());
        int n3 = 150;
        int n4 = 150;
        MeteringRectangle meteringRectangle = new MeteringRectangle(Math.max(n2 - 150, 0), Math.max(n - 150, 0), 300, 300, 999);
        Camera2Manager$11 camera2Manager$11 = new Camera2Manager$11(this);
        try {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)camera2Manager$11, this.mBackgroundHandler);
            if (this.isMeteringAreaAFSupported()) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{meteringRectangle});
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.mPreviewRequestBuilder.setTag((Object)"FOCUS_TAG");
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)camera2Manager$11, this.mBackgroundHandler);
            this.mManualFocusEngaged = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    static /* synthetic */ Camera2Manager$OnCamera2ManagerListener access$000(Camera2Manager camera2Manager) {
        return camera2Manager.mCamera2ManagerListener;
    }

    static /* synthetic */ Object access$100(Camera2Manager camera2Manager) {
        return camera2Manager.mCameraStateLock;
    }

    static /* synthetic */ Size access$202(Camera2Manager camera2Manager, Size size) {
        camera2Manager.mPreviewSize = size;
        return camera2Manager.mPreviewSize;
    }

    static /* synthetic */ int access$302(Camera2Manager camera2Manager, int n) {
        camera2Manager.mState = n;
        return camera2Manager.mState;
    }

    static /* synthetic */ Semaphore access$400(Camera2Manager camera2Manager) {
        return camera2Manager.mCameraOpenCloseLock;
    }

    static /* synthetic */ CameraDevice access$502(Camera2Manager camera2Manager, CameraDevice cameraDevice) {
        camera2Manager.mCameraDevice = cameraDevice;
        return camera2Manager.mCameraDevice;
    }

    static /* synthetic */ Size access$200(Camera2Manager camera2Manager) {
        return camera2Manager.mPreviewSize;
    }

    static /* synthetic */ Camera2PreviewView access$600(Camera2Manager camera2Manager) {
        return camera2Manager.mTextureView;
    }

    static /* synthetic */ void access$700(Camera2Manager camera2Manager) {
        camera2Manager.createCameraPreviewSessionLocked();
    }

    static /* synthetic */ CameraView access$800(Camera2Manager camera2Manager) {
        return camera2Manager.mCameraView;
    }

    static /* synthetic */ CameraCharacteristics access$900(Camera2Manager camera2Manager) {
        return camera2Manager.mCharacteristics;
    }

    static /* synthetic */ int access$1000(CameraCharacteristics cameraCharacteristics, int n) {
        return Camera2Manager.sensorToDeviceRotation(cameraCharacteristics, n);
    }

    static /* synthetic */ TreeMap access$1100(Camera2Manager camera2Manager) {
        return camera2Manager.mJpegResultQueue;
    }

    static /* synthetic */ Camera2Manager$RefCountedAutoCloseable access$1200(Camera2Manager camera2Manager) {
        return camera2Manager.mJpegImageReader;
    }

    static /* synthetic */ void access$1300(Camera2Manager camera2Manager, TreeMap treeMap, Camera2Manager$RefCountedAutoCloseable camera2Manager$RefCountedAutoCloseable) {
        camera2Manager.dequeueAndSaveImage(treeMap, camera2Manager$RefCountedAutoCloseable);
    }

    static /* synthetic */ TreeMap access$1400(Camera2Manager camera2Manager) {
        return camera2Manager.mRawResultQueue;
    }

    static /* synthetic */ Camera2Manager$RefCountedAutoCloseable access$1500(Camera2Manager camera2Manager) {
        return camera2Manager.mRawImageReader;
    }

    static /* synthetic */ int access$300(Camera2Manager camera2Manager) {
        return camera2Manager.mState;
    }

    static /* synthetic */ boolean access$1602(Camera2Manager camera2Manager, boolean bl) {
        camera2Manager.mTryTakePicture = bl;
        return camera2Manager.mTryTakePicture;
    }

    static /* synthetic */ boolean access$1700(Camera2Manager camera2Manager) {
        return camera2Manager.mNoAFRun;
    }

    static /* synthetic */ boolean access$1800(Camera2Manager camera2Manager) {
        return camera2Manager.isLegacyLocked();
    }

    static /* synthetic */ boolean access$1900(Camera2Manager camera2Manager) {
        return camera2Manager.hitTimeoutLocked();
    }

    static /* synthetic */ int access$2000(Camera2Manager camera2Manager) {
        return camera2Manager.mPendingUserCaptures;
    }

    static /* synthetic */ void access$2100(Camera2Manager camera2Manager) {
        camera2Manager.captureStillPictureLocked();
    }

    static /* synthetic */ int access$2010(Camera2Manager camera2Manager) {
        return camera2Manager.mPendingUserCaptures--;
    }

    static /* synthetic */ String access$2200() {
        return Camera2Manager.generateTimestamp();
    }

    static /* synthetic */ boolean access$2300(Camera2Manager camera2Manager) {
        return camera2Manager.mUseSaveFile;
    }

    static /* synthetic */ void access$2400(Camera2Manager camera2Manager, int n, Camera2Manager$ImageSaver$ImageSaverBuilder camera2Manager$ImageSaver$ImageSaverBuilder, TreeMap treeMap) {
        camera2Manager.handleCompletionLocked(n, camera2Manager$ImageSaver$ImageSaverBuilder, treeMap);
    }

    static /* synthetic */ void access$2500(Camera2Manager camera2Manager) {
        camera2Manager.finishedCaptureLocked();
    }

    static /* synthetic */ void access$2600(Camera2Manager camera2Manager, String string) {
        camera2Manager.showToast(string);
    }

    static /* synthetic */ CameraDevice access$500(Camera2Manager camera2Manager) {
        return camera2Manager.mCameraDevice;
    }

    static /* synthetic */ CaptureRequest.Builder access$2700(Camera2Manager camera2Manager) {
        return camera2Manager.mPreviewRequestBuilder;
    }

    static /* synthetic */ void access$2800(Camera2Manager camera2Manager, CaptureRequest.Builder builder) {
        camera2Manager.setup3AControlsLocked(builder);
    }

    static /* synthetic */ CameraCaptureSession.CaptureCallback access$2900(Camera2Manager camera2Manager) {
        return camera2Manager.mPreCaptureCallback;
    }

    static /* synthetic */ Handler access$3000(Camera2Manager camera2Manager) {
        return camera2Manager.mBackgroundHandler;
    }

    static /* synthetic */ CameraCaptureSession access$3102(Camera2Manager camera2Manager, CameraCaptureSession cameraCaptureSession) {
        camera2Manager.mCaptureSession = cameraCaptureSession;
        return camera2Manager.mCaptureSession;
    }

    static /* synthetic */ void access$3200(OutputStream outputStream) {
        Camera2Manager.closeOutput(outputStream);
    }

    static /* synthetic */ boolean access$3602(Camera2Manager camera2Manager, boolean bl) {
        camera2Manager.mManualFocusEngaged = bl;
        return camera2Manager.mManualFocusEngaged;
    }

    static {
        ORIENTATIONS.append(0, 0);
        ORIENTATIONS.append(1, 90);
        ORIENTATIONS.append(2, 180);
        ORIENTATIONS.append(3, 270);
    }
}

