/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.SizeF;
import android.view.View;
import oz.util.view.camera.CameraBoxViewBase$CameraBox;
import oz.util.view.camera.CameraBoxViewBase$CameraBoxRender;

public abstract class CameraBoxViewBase
extends View {
    protected RectF mViewRect = new RectF();
    protected RectF mViewTempRect = new RectF();
    protected RectF mWholeRect = new RectF();
    protected Paint mWholeRectPaint = new Paint(1);
    protected RectF mOutRect;
    protected Paint mOutRectPaint;
    protected RectF mInRect;
    protected Paint mInRectPaint;
    protected Paint mBitmapPaint;
    protected boolean mDrawWholeRect;
    protected boolean mDrawOutRect;
    protected boolean mDrawInRect;
    protected int mBackgroundColor;
    protected boolean mDrawBackground;
    protected Bitmap mBitmap;
    protected RectF mBitmapRect;
    protected int mBitmapRotation;
    protected boolean mBoxDraw;
    protected CameraBoxViewBase$CameraBoxRender mBoxRender;
    protected CameraBoxViewBase$CameraBox[] mBox;
    protected int mImageViewCameraMode;
    protected SizeF mBitmapSize;

    public CameraBoxViewBase(Context context) {
        super(context);
        this.mWholeRectPaint.setColor(-16711681);
        this.mWholeRectPaint.setStrokeWidth(30.0f);
        this.mWholeRectPaint.setStyle(Paint.Style.STROKE);
        this.mOutRect = new RectF();
        this.mOutRectPaint = new Paint(1);
        this.mOutRectPaint.setColor(-16776961);
        this.mOutRectPaint.setStrokeWidth(20.0f);
        this.mOutRectPaint.setStyle(Paint.Style.STROKE);
        this.mInRect = new RectF();
        this.mInRectPaint = new Paint(1);
        this.mInRectPaint.setColor(-16711936);
        this.mInRectPaint.setStrokeWidth(10.0f);
        this.mInRectPaint.setStyle(Paint.Style.STROKE);
        this.mDrawWholeRect = true;
        this.mDrawOutRect = true;
        this.mDrawInRect = true;
        this.mDrawBackground = true;
        this.mBackgroundColor = Color.argb((int)150, (int)0, (int)0, (int)0);
        this.mBitmapPaint = new Paint(1);
        this.mBitmapRect = new RectF();
        this.updateDrawRectFlag();
    }

    protected abstract void updateDrawRectFlag();

    public void updateInRect(float f2) {
        float f3 = f2;
        if (f3 > 0.0f) {
            float f4 = this.getOutRect().width();
            float f5 = this.getOutRect().height();
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = f4;
            float f9 = f5;
            if (f4 > f3 * f5) {
                f6 = (f4 - f5 * f3) / 2.0f;
                f8 = f5 * f3;
            } else {
                f7 = (f5 - f4 / f3) / 2.0f;
                f9 = f4 / f3;
            }
            this.getInRect().set(this.getOutRect().left + f6, this.getOutRect().top + f7, this.getOutRect().left + f6 + f8, this.getOutRect().top + f7 + f9);
        } else {
            this.getInRect().setEmpty();
        }
    }

    public RectF getWholeRect() {
        return this.mWholeRect;
    }

    public RectF getOutRect() {
        return this.mOutRect;
    }

    public RectF getInRect() {
        return this.mInRect;
    }

    public void setBitmapSize(SizeF sizeF) {
        this.mBitmapSize = sizeF;
    }

    public void setDrawInRect(boolean bl) {
        this.postInvalidate();
    }

    public void setBoxBitmap(Bitmap bitmap, int n, RectF rectF) {
        this.mBitmapRotation = n;
        if (rectF == null) {
            this.mBitmapRect.setEmpty();
        } else {
            this.mBitmapRect.set(rectF);
        }
        if (bitmap != this.mBitmap) {
            Bitmap bitmap2 = this.mBitmap;
            this.mBitmap = bitmap;
            this.postInvalidate();
            if (bitmap2 != null) {
                bitmap2.recycle();
            }
        }
    }

    public void setBoxDraw(boolean bl) {
        this.mBoxDraw = bl;
    }

    public void setBox(CameraBoxViewBase$CameraBox[] cameraBoxViewBase$CameraBoxArray) {
        this.mBox = cameraBoxViewBase$CameraBoxArray;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mViewRect.set(0.0f, 0.0f, (float)n, (float)n2);
    }

    protected void drawRect(Canvas canvas, RectF rectF, Paint paint) {
        if (!rectF.isEmpty()) {
            this.mViewTempRect.setIntersect(this.mViewRect, rectF);
            if (!this.mViewTempRect.isEmpty()) {
                canvas.drawRect(this.mViewTempRect, paint);
            }
        }
    }
}

