/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.combinedinput;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import oz.main.MainFrameView;
import oz.main.OZStorage;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.combinedinput.OZCombinedCheck;
import oz.viewer.ui.combinedinput.OZCombinedGroupView;
import oz.viewer.ui.combinedinput.OZCombinedInputDialog$1;
import oz.viewer.ui.combinedinput.OZCombinedInputDialog$2;
import oz.viewer.ui.combinedinput.OZCombinedInputDialog$3;
import oz.viewer.ui.combinedinput.OZCombinedInputDialog$4;
import oz.viewer.ui.combinedinput.OZCombinedRadio;
import oz.viewer.ui.combinedinput.OZCombinedSign;
import oz.viewer.ui.combinedinput.OZCombinedSignWnd;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.dlg.CIObjectInfo;

public class OZCombinedInputDialog {
    private Context mContext;
    private final int titleBGColor = Color.rgb((int)0, (int)91, (int)172);
    private final int titleTextColor = Color.rgb((int)255, (int)255, (int)255);
    private final int backGroundColor = Color.rgb((int)238, (int)245, (int)252);
    private final int groupTitleTextColor = Color.rgb((int)0, (int)92, (int)182);
    private final int textColor = Color.rgb((int)92, (int)87, (int)80);
    private final int agreeBGColor = Color.rgb((int)0, (int)152, (int)230);
    private final int agreeTextColor = Color.rgb((int)255, (int)255, (int)255);
    private final int disagreeBGColor = Color.rgb((int)255, (int)71, (int)111);
    private final int disagreeTextColor = Color.rgb((int)255, (int)255, (int)255);
    private final int signBGColor = Color.rgb((int)44, (int)51, (int)76);
    private final int signTextColor = Color.rgb((int)255, (int)255, (int)255);
    private static final int groupTextSize = 18;
    private static final int descriptionTextSize = 14;
    private static final String BTN_OK = "resource/combine_ok.png";
    private static final String BTN_CANCEL = "resource/combine_cancel.png";
    private static final int BUTTON_WIDHT = 88;
    private static final int BUTTON_HEIGHT = 50;
    private static final int SIGN_FRAME_MARGIN = 30;
    private static final int CONTENT_PADDING = 40;
    private LinearLayout mDefaultSignLayout_1;
    private LinearLayout mDefaultSignLayout_2;
    private LinearLayout mAdditionalSignLayout_1;
    private LinearLayout mAdditionalSignLayout_2;
    private String m_strWindowTitle;
    private String m_strHeaderText;
    private String m_strAgreementText;
    private String m_strDisagreementText;
    private String m_strSignInputTitle;
    private String m_strDefaultSignTitle;
    private String m_strAdditionalSignTitle;
    private String m_strTracingoutlineNameText;
    private String m_strTracingoutlineSignText;
    private int m_signPadPenThickness;
    private boolean m_hasDefaultsign;
    private boolean m_hasAdditionalsign;
    private int m_NameBorderThick = 0;
    private int m_NameBorderColor = -65536;
    private int m_SignBorderThick = 0;
    private int m_SignBorderColor = -16776961;
    private List m_objects;
    private List m_compLayout;
    private List m_signWnd;
    private LinearLayout mRoot;
    public int AGREE_ID;
    public int DISAGREE_ID;
    public int mDialogWidth;
    MainFrameView mMainFrameView;
    private static int backup_screen_orientation = -1;
    private static int backup_screen_lock = 0;

    public static void lockDeviceRotation(Context context) {
        if (backup_screen_lock == 0) {
            backup_screen_orientation = ((Activity)context).getRequestedOrientation();
            ((Activity)context).setRequestedOrientation(OZStorage.getLockScreenOrientation((Activity)context));
        }
        ++backup_screen_lock;
    }

    public static void unlockDeviceRotation(Context context) {
        if (backup_screen_lock > 0 && --backup_screen_lock == 0) {
            ((Activity)context).setRequestedOrientation(backup_screen_orientation);
        }
    }

    public OZCombinedInputDialog(Context context, MainFrameView mainFrameView) {
        this.mContext = context;
        this.mMainFrameView = mainFrameView;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void init() {
        if (this.m_objects != null) {
            this.m_objects.clear();
        }
        this.m_objects = new ArrayList();
        this.m_compLayout = new ArrayList();
        this.m_signWnd = new ArrayList();
        this.mDialogWidth = this.getScreenSize().x;
        if (this.mContext.getResources().getConfiguration().orientation == 2) {
            this.mDialogWidth = this.getScreenSize().y;
        }
    }

    public void setCompProperties(Object[] objectArray) {
        CIObjectInfo cIObjectInfo = new CIObjectInfo();
        cIObjectInfo.setDFIndex((Integer)objectArray[0]);
        cIObjectInfo.setComptype((Integer)objectArray[1]);
        cIObjectInfo.setSigngroupcount((Integer)objectArray[2]);
        cIObjectInfo.setTitleText((String)objectArray[3]);
        cIObjectInfo.setDescriptionText((String)objectArray[4]);
        cIObjectInfo.setHasTitleText((Boolean)objectArray[5]);
        cIObjectInfo.setSignGroupName((String)objectArray[6]);
        this.m_objects.add(cIObjectInfo);
    }

    public void setProperties(Object[] objectArray) {
        Object object;
        String string;
        this.m_strWindowTitle = (String)objectArray[0];
        this.m_strHeaderText = (String)objectArray[1];
        this.m_strAgreementText = (String)objectArray[2];
        this.m_strDisagreementText = (String)objectArray[3];
        this.m_strSignInputTitle = (String)objectArray[4];
        this.m_strDefaultSignTitle = (String)objectArray[5];
        this.m_strAdditionalSignTitle = (String)objectArray[6];
        this.m_strTracingoutlineNameText = (String)objectArray[7];
        this.m_strTracingoutlineSignText = (String)objectArray[8];
        this.m_signPadPenThickness = Integer.parseInt((String)objectArray[9]);
        this.m_hasDefaultsign = (Boolean)objectArray[10];
        this.m_hasAdditionalsign = (Boolean)objectArray[11];
        String string2 = (String)objectArray[12];
        try {
            if (string2 != null && !string2.isEmpty()) {
                string = new JSONObject(string2);
                this.m_NameBorderThick = Integer.parseInt(string.getString("borderthick"));
                object = string.getString("bordercolor");
                if (((String)object).length() == 6) {
                    object = "#" + (String)object;
                }
                try {
                    this.m_NameBorderColor = Color.parseColor((String)object);
                }
                catch (Exception exception) {}
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        string = (String)objectArray[13];
        try {
            if (string != null && !string.isEmpty()) {
                object = new JSONObject(string);
                this.m_SignBorderThick = Integer.parseInt(object.getString("borderthick"));
                String string3 = object.getString("bordercolor");
                if (string3.length() == 6) {
                    string3 = "#" + string3;
                }
                try {
                    this.m_SignBorderColor = Color.parseColor((String)string3);
                }
                catch (Exception exception) {}
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.m_strAgreementText.isEmpty()) {
            this.m_strAgreementText = OZAndroidResource.getResource("combinedinput.agree");
        }
        if (this.m_strDisagreementText.isEmpty()) {
            this.m_strDisagreementText = OZAndroidResource.getResource("combinedinput.disagree");
        }
    }

    public List getCompLayout() {
        return this.m_compLayout;
    }

    public List getCompObject() {
        return this.m_objects;
    }

    public List getSign() {
        return this.m_signWnd;
    }

    public void updateCombinedCheckBox() {
        LinearLayout linearLayout;
        int n = 0;
        int n2 = 0;
        int n3 = this.m_compLayout.size();
        for (int j = 0; j < this.m_compLayout.size(); ++j) {
            linearLayout = (LinearLayout)this.m_compLayout.get(j);
            if (linearLayout instanceof OZCombinedCheck) {
                if (((OZCombinedCheck)linearLayout).isChecked()) {
                    ++n;
                    continue;
                }
                ++n2;
                continue;
            }
            if (linearLayout instanceof OZCombinedRadio) {
                if (((OZCombinedRadio)linearLayout).isCheckedAgree()) {
                    ++n;
                }
                if (!((OZCombinedRadio)linearLayout).isCheckedDisagree()) continue;
                ++n2;
                continue;
            }
            if (!(linearLayout instanceof OZCombinedSign)) continue;
            if (((OZCombinedSign)linearLayout).isChecked()) {
                ++n;
                continue;
            }
            ++n2;
        }
        CheckBox checkBox = (CheckBox)this.mRoot.findViewById(this.AGREE_ID);
        linearLayout = (CheckBox)this.mRoot.findViewById(this.DISAGREE_ID);
        if (n == n3) {
            checkBox.setChecked(true);
            linearLayout.setChecked(false);
        } else if (n2 == n3) {
            checkBox.setChecked(false);
            linearLayout.setChecked(true);
        } else {
            checkBox.setChecked(false);
            linearLayout.setChecked(false);
        }
    }

    public LinearLayout makeTitleView() {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setBackgroundColor(this.titleBGColor);
        linearLayout.setOrientation(1);
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)this.m_strWindowTitle);
        textView.setTextSize(2, 20.0f);
        textView.setGravity(19);
        textView.setTextColor(this.titleTextColor);
        textView.setPadding(40, 0, 0, 0);
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mDialogWidth, (int)(textView.getTextSize() * 2.0f)));
        return linearLayout;
    }

    public LinearLayout makeCombinedCheckView() {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.getContext(), 16973836);
        int n = 200;
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setBackgroundColor(this.backGroundColor);
        linearLayout.setOrientation(0);
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)this.m_strHeaderText);
        textView.setTextSize(2, 20.0f);
        textView.setGravity(19);
        textView.setTextColor(this.textColor);
        textView.setPadding(40, 0, 0, 0);
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mDialogWidth - (n * 2 + 60), -1));
        textView = new LinearLayout(this.getContext());
        textView.setGravity(1);
        textView.setBackgroundColor(this.agreeBGColor);
        textView.setOrientation(1);
        textView.setPadding(0, 0, 0, 0);
        TextView textView2 = new TextView(this.getContext());
        textView2.setText((CharSequence)this.m_strAgreementText);
        textView2.setTextSize(2, 14.0f);
        textView2.setGravity(17);
        textView2.setTextColor(this.agreeTextColor);
        textView.addView((View)textView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 80));
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setGravity(1);
        CheckBox checkBox = new CheckBox((Context)contextThemeWrapper);
        checkBox.setBackgroundColor(this.agreeBGColor);
        checkBox.setPadding(0, 0, 0, 0);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        textView.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout2.addView((View)checkBox, (ViewGroup.LayoutParams)layoutParams);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(n, -2);
        layoutParams2.setMargins(0, 30, 30, 0);
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams2);
        OZCombinedInputDialog oZCombinedInputDialog = this;
        this.AGREE_ID = oZCombinedInputDialog.mRoot.generateViewId();
        checkBox.setId(this.AGREE_ID);
        checkBox.setOnClickListener((View.OnClickListener)new OZCombinedInputDialog$1(this));
        textView = new LinearLayout(this.getContext());
        textView.setGravity(1);
        textView.setBackgroundColor(this.disagreeBGColor);
        textView.setOrientation(1);
        textView.setPadding(0, 0, 0, 0);
        textView2 = new TextView(this.getContext());
        textView2.setText((CharSequence)this.m_strDisagreementText);
        textView2.setTextSize(2, 14.0f);
        textView2.setGravity(17);
        textView2.setTextColor(this.disagreeTextColor);
        textView.addView((View)textView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 80));
        linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setGravity(1);
        checkBox = new CheckBox((Context)contextThemeWrapper);
        checkBox.setBackgroundColor(this.disagreeBGColor);
        checkBox.setPadding(0, 0, 0, 0);
        layoutParams = new LinearLayout.LayoutParams(-2, -2);
        textView.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout2.addView((View)checkBox, (ViewGroup.LayoutParams)layoutParams);
        layoutParams2 = new LinearLayout.LayoutParams(n, -2);
        layoutParams2.setMargins(0, 30, 30, 0);
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams2);
        OZCombinedInputDialog oZCombinedInputDialog2 = this;
        this.DISAGREE_ID = oZCombinedInputDialog2.mRoot.generateViewId();
        checkBox.setId(this.DISAGREE_ID);
        checkBox.setOnClickListener((View.OnClickListener)new OZCombinedInputDialog$2(this));
        return linearLayout;
    }

    public ScrollView makeContextView() {
        ScrollView scrollView = new ScrollView(this.getContext());
        scrollView.setBackgroundColor(this.backGroundColor);
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        scrollView.addView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mDialogWidth, -2));
        if (!this.m_objects.isEmpty()) {
            OZCombinedGroupView oZCombinedGroupView = new OZCombinedGroupView(this.getContext());
            oZCombinedGroupView.setOrientation(1);
            oZCombinedGroupView.setBackgroundColor(this.backGroundColor);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.mDialogWidth - 60, -2);
            layoutParams.setMargins(30, 30, 30, 30);
            oZCombinedGroupView.setPadding(0, 30, 0, 30);
            linearLayout.addView((View)oZCombinedGroupView, (ViewGroup.LayoutParams)layoutParams);
            block6: for (int j = 0; j < this.m_objects.size(); ++j) {
                CIObjectInfo cIObjectInfo = (CIObjectInfo)this.m_objects.get(j);
                if (!cIObjectInfo.getHasTitleText() && cIObjectInfo.getDescriptionText().isEmpty() && cIObjectInfo.getComptype() != 57) continue;
                switch (cIObjectInfo.getComptype()) {
                    case 400: {
                        if (oZCombinedGroupView.getChildCount() != 0) {
                            oZCombinedGroupView = new OZCombinedGroupView(this.getContext());
                            oZCombinedGroupView.setOrientation(1);
                            oZCombinedGroupView.setBackgroundColor(this.backGroundColor);
                            oZCombinedGroupView.setPadding(0, 30, 0, 30);
                            linearLayout.addView((View)oZCombinedGroupView, (ViewGroup.LayoutParams)layoutParams);
                        }
                        TextView textView = new TextView(this.getContext());
                        textView.setText((CharSequence)cIObjectInfo.getTitleText());
                        textView.setTypeface(null, 1);
                        textView.setTextSize(2, 18.0f);
                        textView.setGravity(19);
                        textView.setTextColor(this.groupTitleTextColor);
                        textView.setPadding(40, 0, 0, 20);
                        oZCombinedGroupView.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                        if (cIObjectInfo.getDescriptionText().isEmpty()) continue block6;
                        TextView textView2 = new TextView(this.getContext());
                        textView2.setText((CharSequence)cIObjectInfo.getDescriptionText());
                        textView2.setTypeface(null, 1);
                        textView2.setTextSize(2, 14.0f);
                        textView2.setGravity(19);
                        textView2.setTextColor(this.textColor);
                        textView2.setPadding(40, 0, 0, 30);
                        oZCombinedGroupView.addView((View)textView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                        continue block6;
                    }
                    case 53: {
                        if (cIObjectInfo.getHasTitleText()) {
                            oZCombinedGroupView = this.makeNewGroup(linearLayout, oZCombinedGroupView, layoutParams, cIObjectInfo.getTitleText());
                        }
                        OZCombinedCheck oZCombinedCheck = new OZCombinedCheck(this.getContext(), this);
                        LinearLayout linearLayout2 = oZCombinedCheck.makeCheckComp(this.mRoot, cIObjectInfo);
                        if (cIObjectInfo.getDescriptionText().isEmpty()) {
                            ((LinearLayout)oZCombinedGroupView.getChildAt(oZCombinedGroupView.getChildCount() - 1)).addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1, 0.0f));
                        } else {
                            oZCombinedGroupView.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                        }
                        this.m_compLayout.add(oZCombinedCheck);
                        continue block6;
                    }
                    case 81: {
                        if (cIObjectInfo.getHasTitleText()) {
                            oZCombinedGroupView = this.makeNewGroup(linearLayout, oZCombinedGroupView, layoutParams, cIObjectInfo.getTitleText());
                        }
                        OZCombinedRadio oZCombinedRadio = new OZCombinedRadio(this.getContext(), this);
                        LinearLayout linearLayout3 = oZCombinedRadio.makeRadioComp(this.mRoot, cIObjectInfo);
                        if (cIObjectInfo.getDescriptionText().isEmpty()) {
                            ((LinearLayout)oZCombinedGroupView.getChildAt(oZCombinedGroupView.getChildCount() - 1)).addView((View)linearLayout3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1, 0.0f));
                        } else {
                            oZCombinedGroupView.addView((View)linearLayout3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                        }
                        this.m_compLayout.add(oZCombinedRadio);
                        continue block6;
                    }
                    case 57: {
                        boolean bl = cIObjectInfo.getSignGroupName().startsWith("defaultsign_");
                        boolean bl2 = cIObjectInfo.getSignGroupName().startsWith("additionalsign_");
                        if (!bl && !bl2 || cIObjectInfo.getTitleText().isEmpty() && cIObjectInfo.getDescriptionText().isEmpty()) continue block6;
                        if ((bl || bl2) && !cIObjectInfo.getTitleText().isEmpty()) {
                            oZCombinedGroupView = this.makeNewGroup(linearLayout, oZCombinedGroupView, layoutParams, cIObjectInfo.getTitleText());
                        }
                        OZCombinedSign oZCombinedSign = new OZCombinedSign(this.getContext(), this, bl);
                        LinearLayout linearLayout4 = oZCombinedSign.makeSignComp(this.mRoot, cIObjectInfo.getDFIndex(), cIObjectInfo.getDescriptionText());
                        if (cIObjectInfo.getDescriptionText().isEmpty()) {
                            ((LinearLayout)oZCombinedGroupView.getChildAt(oZCombinedGroupView.getChildCount() - 1)).addView((View)linearLayout4, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1, 0.0f));
                        } else {
                            oZCombinedGroupView.addView((View)linearLayout4, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                        }
                        this.m_compLayout.add(oZCombinedSign);
                        continue block6;
                    }
                }
            }
        }
        return scrollView;
    }

    public LinearLayout makeSignPadView(Dialog dialog) {
        LinearLayout.LayoutParams layoutParams;
        OZCombinedSignWnd oZCombinedSignWnd;
        LinearLayout linearLayout;
        Dialog dialog2 = dialog;
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setOrientation(1);
        linearLayout2.setBackgroundColor(this.signBGColor);
        LinearLayout linearLayout3 = new LinearLayout(this.getContext());
        linearLayout3.setOrientation(0);
        linearLayout3.setGravity(3);
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)this.m_strSignInputTitle);
        textView.setTextSize(2, 20.0f);
        textView.setGravity(19);
        textView.setTextColor(this.signTextColor);
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setPadding(30, 0, 0, 0);
        linearLayout3.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1, 1.0f));
        textView = new Button(this.mContext);
        Button button = new Button(this.mContext);
        try {
            textView.setBackgroundDrawable((Drawable)new BitmapDrawable(this.getContext().getAssets().open(BTN_CANCEL)));
            button.setBackgroundDrawable((Drawable)new BitmapDrawable(this.getContext().getAssets().open(BTN_OK)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(DFUtils.toDP(this.getContext(), 88.0f), DFUtils.toDP(this.getContext(), 50.0f), 0.0f);
        layoutParams2.setMargins(30, 30, 30, 30);
        LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(DFUtils.toDP(this.getContext(), 88.0f), DFUtils.toDP(this.getContext(), 50.0f), 0.0f);
        layoutParams3.setMargins(0, 30, 30, 30);
        linearLayout3.addView((View)textView, (ViewGroup.LayoutParams)layoutParams2);
        linearLayout3.addView((View)button, (ViewGroup.LayoutParams)layoutParams3);
        textView.setOnClickListener((View.OnClickListener)new OZCombinedInputDialog$3(this, dialog2));
        button.setOnClickListener((View.OnClickListener)new OZCombinedInputDialog$4(this, dialog2));
        linearLayout2.addView((View)linearLayout3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mDialogWidth, -2));
        int n = this.mDialogWidth / 2;
        int n2 = this.getScreenSize().y / 2;
        float f2 = (float)((double)(this.mDialogWidth / 2) - 45.0);
        float f3 = this.getScreenSize().y / 8;
        if (this.m_hasDefaultsign) {
            linearLayout = new LinearLayout(this.getContext());
            linearLayout.setOrientation(0);
            linearLayout.setBackgroundColor(this.signBGColor);
            oZCombinedSignWnd = new OZCombinedSignWnd(this.getContext(), 0);
            this.m_signWnd.add(oZCombinedSignWnd);
            oZCombinedSignWnd.setProperty(this.m_strDefaultSignTitle, -1, 13, this.m_strTracingoutlineNameText, -16777216, -1, -1, -16777216, this.m_signPadPenThickness, f2, f3, 0.7f, this.m_NameBorderThick, this.m_NameBorderColor);
            this.mDefaultSignLayout_1 = oZCombinedSignWnd.getOZCombinedSignWnd(f2, f3);
            layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(30, 0, 15, 30);
            linearLayout.addView((View)this.mDefaultSignLayout_1, (ViewGroup.LayoutParams)layoutParams);
            oZCombinedSignWnd = new OZCombinedSignWnd(this.getContext(), 1);
            this.m_signWnd.add(oZCombinedSignWnd);
            oZCombinedSignWnd.setProperty("", -1, 13, this.m_strTracingoutlineSignText, -16777216, -1, -1, -16777216, this.m_signPadPenThickness, n, n2, 0.7f, this.m_SignBorderThick, this.m_SignBorderColor);
            this.mDefaultSignLayout_2 = oZCombinedSignWnd.getOZCombinedSignWnd(f2, f3);
            layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(15, 0, 30, 30);
            linearLayout.addView((View)this.mDefaultSignLayout_2, (ViewGroup.LayoutParams)layoutParams);
            linearLayout2.addView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mDialogWidth, -2));
        }
        if (this.m_hasAdditionalsign) {
            linearLayout = new LinearLayout(this.getContext());
            linearLayout.setOrientation(0);
            linearLayout.setBackgroundColor(this.signBGColor);
            oZCombinedSignWnd = new OZCombinedSignWnd(this.getContext(), 0);
            this.m_signWnd.add(oZCombinedSignWnd);
            oZCombinedSignWnd.setProperty(this.m_strAdditionalSignTitle, -1, 13, this.m_strTracingoutlineNameText, -16777216, -1, -1, -16777216, this.m_signPadPenThickness, n, n2, 0.7f, this.m_NameBorderThick, this.m_NameBorderColor);
            this.mAdditionalSignLayout_1 = oZCombinedSignWnd.getOZCombinedSignWnd(f2, f3);
            layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(30, 0, 15, 30);
            linearLayout.addView((View)this.mAdditionalSignLayout_1, (ViewGroup.LayoutParams)layoutParams);
            oZCombinedSignWnd = new OZCombinedSignWnd(this.getContext(), 1);
            this.m_signWnd.add(oZCombinedSignWnd);
            oZCombinedSignWnd.setProperty("", -1, 13, this.m_strTracingoutlineSignText, -16777216, -1, -1, -16777216, this.m_signPadPenThickness, n, n2, 0.7f, this.m_SignBorderThick, this.m_SignBorderColor);
            this.mAdditionalSignLayout_2 = oZCombinedSignWnd.getOZCombinedSignWnd(f2, f3);
            layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(15, 0, 30, 30);
            linearLayout.addView((View)this.mAdditionalSignLayout_2, (ViewGroup.LayoutParams)layoutParams);
            linearLayout2.addView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mDialogWidth, -2));
        }
        return linearLayout2;
    }

    public Dialog showDialog() {
        OZCombinedInputDialog.lockDeviceRotation(this.mContext);
        Dialog dialog = new Dialog(this.mContext, 16973834);
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setGravity(1);
        this.mRoot = linearLayout;
        LinearLayout linearLayout2 = this.makeTitleView();
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 0.0f));
        LinearLayout linearLayout3 = this.makeCombinedCheckView();
        linearLayout.addView((View)linearLayout3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 0.0f));
        ScrollView scrollView = this.makeContextView();
        linearLayout.addView((View)scrollView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 1.0f));
        LinearLayout linearLayout4 = this.makeSignPadView(dialog);
        linearLayout.addView((View)linearLayout4, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 0.0f));
        dialog.setContentView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        dialog.setTitle(null);
        Window window = dialog.getWindow();
        window.setSoftInputMode(16);
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.gravity = 17;
        layoutParams.flags &= 0xFFFFFFFD;
        window.setAttributes(layoutParams);
        window.setLayout(-1, -1);
        window.setBackgroundDrawable((Drawable)new ColorDrawable(Color.argb((int)100, (int)0, (int)0, (int)0)));
        dialog.show();
        return dialog;
    }

    private OZCombinedGroupView makeNewGroup(LinearLayout linearLayout, OZCombinedGroupView oZCombinedGroupView, LinearLayout.LayoutParams layoutParams, String string) {
        if (oZCombinedGroupView.getChildCount() != 0) {
            oZCombinedGroupView = new OZCombinedGroupView(this.getContext());
            oZCombinedGroupView.setOrientation(1);
            oZCombinedGroupView.setBackgroundColor(this.backGroundColor);
            oZCombinedGroupView.setPadding(0, 30, 0, 30);
            linearLayout.addView((View)oZCombinedGroupView, (ViewGroup.LayoutParams)layoutParams);
        }
        TextView textView = new TextView(this.getContext());
        textView.setTypeface(null, 1);
        textView.setTextSize(2, 18.0f);
        textView.setText((CharSequence)string);
        textView.setTextColor(this.groupTitleTextColor);
        textView.setPadding(40, 0, 20, 0);
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setBackgroundColor(0);
        linearLayout2.setOrientation(0);
        linearLayout2.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        oZCombinedGroupView.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        return oZCombinedGroupView;
    }

    public Point getScreenSize() {
        Point point = new Point();
        ((Activity)this.mContext).getWindowManager().getDefaultDisplay().getSize(point);
        return point;
    }

    static /* synthetic */ List access$000(OZCombinedInputDialog oZCombinedInputDialog) {
        return oZCombinedInputDialog.m_compLayout;
    }
}

