/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df;

import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.util.ArrayList;
import java.util.List;
import oz.viewer.ui.df.DFSoftKeyboard$1;
import oz.viewer.ui.df.DFSoftKeyboard$SoftKeyboardChanged;
import oz.viewer.ui.df.DFSoftKeyboard$SoftKeyboardChangesThread;

public class DFSoftKeyboard
implements View.OnFocusChangeListener {
    private static final int CLEAR_FOCUS = 0;
    private ViewGroup layout;
    private int layoutBottom;
    private InputMethodManager im;
    private int[] coords;
    private boolean isKeyboardShow;
    private DFSoftKeyboard$SoftKeyboardChangesThread softKeyboardThread;
    private List editTextList;
    private View tempView;
    private final Handler mHandler = new DFSoftKeyboard$1(this);

    public DFSoftKeyboard(ViewGroup viewGroup, InputMethodManager inputMethodManager) {
        this.layout = viewGroup;
        this.keyboardHideByDefault();
        this.initEditTexts(viewGroup);
        this.im = inputMethodManager;
        this.coords = new int[2];
        this.isKeyboardShow = false;
        this.softKeyboardThread = new DFSoftKeyboard$SoftKeyboardChangesThread(this);
        this.softKeyboardThread.start();
    }

    public void openSoftKeyboard() {
        if (!this.isKeyboardShow) {
            this.layoutBottom = this.getLayoutCoordinates();
            this.im.toggleSoftInput(0, 1);
            this.softKeyboardThread.keyboardOpened();
            this.isKeyboardShow = true;
        }
    }

    public void closeSoftKeyboard() {
        if (this.isKeyboardShow) {
            this.im.toggleSoftInput(1, 0);
            this.isKeyboardShow = false;
        }
    }

    public void setSoftKeyboardCallback(DFSoftKeyboard$SoftKeyboardChanged dFSoftKeyboard$SoftKeyboardChanged) {
        this.softKeyboardThread.setCallback(dFSoftKeyboard$SoftKeyboardChanged);
    }

    public void unRegisterSoftKeyboardCallback() {
        this.softKeyboardThread.stopThread();
    }

    private int getLayoutCoordinates() {
        this.layout.getLocationOnScreen(this.coords);
        return this.coords[1] + this.layout.getHeight();
    }

    private void keyboardHideByDefault() {
        this.layout.setFocusable(true);
        this.layout.setFocusableInTouchMode(true);
    }

    private void initEditTexts(ViewGroup viewGroup) {
        if (this.editTextList == null) {
            this.editTextList = new ArrayList();
        }
        int n = viewGroup.getChildCount();
        for (int j = 0; j <= n - 1; ++j) {
            View view = viewGroup.getChildAt(j);
            if (view instanceof ViewGroup) {
                this.initEditTexts((ViewGroup)view);
            }
            if (!(view instanceof EditText)) continue;
            EditText editText = (EditText)view;
            editText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
            editText.setCursorVisible(true);
            this.editTextList.add(editText);
        }
    }

    public void onFocusChange(View view, boolean bl) {
        if (bl) {
            this.tempView = view;
            if (!this.isKeyboardShow) {
                this.layoutBottom = this.getLayoutCoordinates();
                this.softKeyboardThread.keyboardOpened();
                this.isKeyboardShow = true;
            }
        }
    }

    static /* synthetic */ View access$000(DFSoftKeyboard dFSoftKeyboard) {
        return dFSoftKeyboard.tempView;
    }

    static /* synthetic */ View access$002(DFSoftKeyboard dFSoftKeyboard, View view) {
        dFSoftKeyboard.tempView = view;
        return dFSoftKeyboard.tempView;
    }

    static /* synthetic */ int access$100(DFSoftKeyboard dFSoftKeyboard) {
        return dFSoftKeyboard.getLayoutCoordinates();
    }

    static /* synthetic */ int access$200(DFSoftKeyboard dFSoftKeyboard) {
        return dFSoftKeyboard.layoutBottom;
    }

    static /* synthetic */ boolean access$300(DFSoftKeyboard dFSoftKeyboard) {
        return dFSoftKeyboard.isKeyboardShow;
    }

    static /* synthetic */ boolean access$302(DFSoftKeyboard dFSoftKeyboard, boolean bl) {
        dFSoftKeyboard.isKeyboardShow = bl;
        return dFSoftKeyboard.isKeyboardShow;
    }

    static /* synthetic */ Handler access$400(DFSoftKeyboard dFSoftKeyboard) {
        return dFSoftKeyboard.mHandler;
    }
}

