/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Handler;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;
import oz.main.OZStorage;
import oz.util.drawable.FitBitmapDrawable;
import oz.viewer.ui.df.DFManager;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils$1;
import oz.viewer.ui.df.DFUtils$2;
import oz.viewer.ui.df.DFUtils$EmptyStringException;
import oz.viewer.ui.df.view.DFInflaterView;
import oz.viewer.ui.df.view.DFProgressbar;

public class DFUtils {
    public static final String TAG = DFUtils.class.getSimpleName();
    public static boolean USEC = true;
    public static boolean USED = true;
    public static final int ID_IMAGE_BG = 0;
    public static final int ID_IMAGE_SPEAKER_ON = 1;
    public static final int ID_IMAGE_SPEAKER_OFF = 2;
    public static final int ID_IMAGE_VOICE_ON = 3;
    public static final int ID_IMAGE_VOICE_OFF = 4;
    public static final int ID_IMAGE_UP_NORMAL = 5;
    public static final int ID_IMAGE_UP_PRESSED = 6;
    public static final int ID_IMAGE_DOWN_NORMAL = 7;
    public static final int ID_IMAGE_DOWN_PRESSED = 8;
    public static final int ID_IMAGE_CLOSE_NORMAL = 9;
    public static final int ID_IMAGE_CLOSE_PRESSED = 10;
    public static final int ID_IMAGE_NEXT_ARROW = 11;
    public static final int ID_IMAGE_VOICERECORDER_READY = 12;
    public static final int ID_IMAGE_VOICERECORDER_STOP = 13;
    public static final int ID_IMAGE_VOICERECORDER_PLAY = 14;
    public static final int ID_IMAGE_VOICERECORDER_PAUSE = 15;
    public static final int ID_IMAGE_VOICERECORDER_MIC = 16;
    public static final int ID_IMAGE_VOICERECORDER_CLEAR = 17;
    public static final int ID_IMAGE_ATTACHMENT_DOCUMENT = 18;
    public static final int ID_IMAGE_ATTACHMENT_CAMERA = 19;
    public static final int ID_IMAGE_ATTACHMENT_IMAGE = 20;
    public static final int ID_IMAGE_ATTACHMENT_MERGE = 42;
    public static final int ID_IMAGE_NUMERICUPDOWN_MINUS = 21;
    public static final int ID_IMAGE_NUMERICUPDOWN_PLUS = 22;
    public static final int ID_IMAGE_XBUTTON = 23;
    public static final int ID_IMAGE_DATE_LEFT_ARROW = 24;
    public static final int ID_IMAGE_DATE_RIGHT_ARROW = 25;
    public static final int ID_IMAGE_SIGNATURE = 26;
    public static final int ID_IMAGE_CAMERA = 27;
    public static final int ID_IMAGE_TAKEPICTURE_NORMAL = 28;
    public static final int ID_IMAGE_TAKEPICTURE_PRESSED = 29;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_AUTO = 30;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_AUTO_D = 31;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_OFF = 32;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_OFF_D = 33;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_ON = 34;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_ON_D = 35;
    public static final int ID_IMAGE_TAKEPICTURE_FACING_SWITCH = 36;
    public static final int ID_IMAGE_TAKEPICTURE_FACING_SWITCH_D = 37;
    public static final int ID_IMAGE_SEAL = 38;
    public static final int ID_IMAGE_IDCARD = 39;
    public static final String[] imageStore = new String[]{"DFBG.png", "speakon.png", "speakoff.png", "voiceon.png", "voiceoff.png", "up.png", "up.png", "down.png", "down.png", "close.png", "close.png", "next_arrow.png", "vr_ready.png", "vr_stop.png", "vr_play.png", "vr_pause.png", "vr_mic.png", "vr_clear.png", "at_document.png", "at_camera.png", "at_image.png", "nm_minus.png", "nm_plus.png", "xbutton.png", "left.png", "right.png", "signature.png", "camera.png", "takepicture_normal.png", "takepicture_pressed.png", "ip_flash_auto.png", "ip_flash_auto_d.png", "ip_flash_off.png", "ip_flash_off_d.png", "ip_flash_on.png", "ip_flash_on_d.png", "ip_facing_switch.png", "ip_facing_switch_d.png", "seal.png", "idcard.png", "popup_dropdown.png", "popup_calendar.png", "at_merge.png"};
    private static final int COLOR_VOICE_BTN_BORDER_WIDTH = 1;
    private static final int COLOR_VOICE_BTN_BG = Color.argb((int)25, (int)255, (int)255, (int)255);
    private static final int COLOR_VOICE_BTN_PRESSED = Color.argb((int)128, (int)208, (int)208, (int)208);
    private static final int COLOR_VOICE_BTN_STROKE = Color.argb((int)102, (int)255, (int)255, (int)255);

    public static void c(Context context, String string) {
        if (USEC) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)string, (int)0);
            toast.show();
            Handler handler = new Handler(Looper.getMainLooper());
            handler.postDelayed((Runnable)new DFUtils$1(toast), 500L);
        }
    }

    public static void d(String string) {
        if (USED) {
            Log.d((String)("<###### " + TAG), (String)string);
        }
    }

    public static int toDP(Context context, float f2) {
        return (int)DFUtils.toDP_F(context, f2);
    }

    public static float toDP_F(Context context, float f2) {
        if (f2 == 0.0f) {
            return 0.0f;
        }
        return TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int toPx(Context context, int n) {
        return (int)((float)n * context.getResources().getDisplayMetrics().density);
    }

    public static int pxToDp(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        if ((double)f3 == 1.0) {
            f3 = (float)((double)f3 * 4.0);
        } else if ((double)f3 == 1.5) {
            f3 *= 2.0f;
        } else if ((double)f3 == 2.0) {
            f3 = (float)((double)f3 * 2.0);
        }
        return (int)(f2 / f3);
    }

    public static float toSP(Context context, float f2) {
        if (f2 == 0.0f) {
            return 0.0f;
        }
        return TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static boolean isPhone(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getPhoneType() != 0;
    }

    public static Drawable getImageDrawable(Context context, int n) {
        Drawable drawable2 = null;
        if (n < DFManager.imageStore.length) {
            try {
                drawable2 = OZStorage.getDrawable(context.getResources().getAssets().open("resource/df/" + DFManager.imageStore[n]));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return drawable2;
    }

    public static Point getScreenSize(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        return point;
    }

    private static void setOnClick(View view, View.OnClickListener onClickListener) {
        if (view != null) {
            view.setOnClickListener(onClickListener);
        }
    }

    public static void setOnClick(Dialog dialog, int n, View.OnClickListener onClickListener) {
        if (dialog != null) {
            DFUtils.setOnClick(dialog.findViewById(n), onClickListener);
        }
    }

    private static void setOnTouch(View view, View.OnTouchListener onTouchListener) {
        if (view != null) {
            view.setOnTouchListener(onTouchListener);
        }
    }

    public static void setOnTouch(Dialog dialog, int n, View.OnTouchListener onTouchListener) {
        if (dialog != null) {
            DFUtils.setOnTouch(dialog.findViewById(n), onTouchListener);
        }
    }

    private static void setProgress(View view, int n, int n2) {
        if (view != null && view instanceof DFProgressbar) {
            DFProgressbar dFProgressbar = (DFProgressbar)view;
            dFProgressbar.setProgressAndMax(n, n2);
        }
    }

    public static void setProgress(Dialog dialog, int n, int n2, int n3) {
        if (dialog != null) {
            DFUtils.setProgress(dialog.findViewById(n), n2, n3);
        }
    }

    public static Drawable getReusableSignButtonDrawable(Context context) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(Color.argb((int)255, (int)255, (int)255, (int)255));
        gradientDrawable.setStroke(3, -5592406);
        gradientDrawable.setCornerRadius(10.0f);
        return gradientDrawable;
    }

    public static GradientDrawable getGDNormal() {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(0);
        gradientDrawable.setStroke(1, -1);
        gradientDrawable.setCornerRadius(10.0f);
        return gradientDrawable;
    }

    public static GradientDrawable getGDPressed() {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(Color.argb((int)179, (int)255, (int)255, (int)255));
        gradientDrawable.setStroke(3, -1);
        gradientDrawable.setCornerRadius(10.0f);
        return gradientDrawable;
    }

    public static Button createCustomButton(Context context, int n, String string, GradientDrawable gradientDrawable, View.OnClickListener onClickListener) {
        Button button = new Button(context);
        if (n > 0) {
            button.setId(n);
        }
        if (string != null) {
            button.setText((CharSequence)string);
        }
        button.setBackground((Drawable)gradientDrawable);
        if (onClickListener != null) {
            button.setOnClickListener(onClickListener);
        }
        return button;
    }

    public static void tryCloseEditTextKeyboard(EditText editText) {
        if (editText != null && editText.isFocused()) {
            InputMethodManager inputMethodManager = (InputMethodManager)editText.getContext().getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(editText.getWindowToken(), 0);
        }
    }

    public static Drawable createVoiceButtonDrawable(Context context, Drawable drawable2, int n) {
        Drawable drawable3 = drawable2;
        Drawable drawable4 = drawable2;
        GradientDrawable gradientDrawable = new GradientDrawable();
        GradientDrawable gradientDrawable2 = new GradientDrawable();
        gradientDrawable.setShape(1);
        gradientDrawable.setColor(COLOR_VOICE_BTN_BG);
        gradientDrawable.setStroke(1, n);
        gradientDrawable2.setShape(1);
        gradientDrawable2.setColor(COLOR_VOICE_BTN_PRESSED);
        gradientDrawable2.setStroke(1, n);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{gradientDrawable2, drawable3});
        LayerDrawable layerDrawable2 = new LayerDrawable(new Drawable[]{gradientDrawable, drawable4});
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842910, 16842919}, (Drawable)layerDrawable);
        stateListDrawable.addState(new int[]{16842910, -16842919}, (Drawable)layerDrawable2);
        return stateListDrawable;
    }

    public static boolean isMobile(Context context) {
        if (context != null) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            Activity activity = (Activity)context;
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            float f2 = (float)displayMetrics.heightPixels / displayMetrics.ydpi;
            float f3 = (float)displayMetrics.widthPixels / displayMetrics.xdpi;
            double d2 = Math.sqrt(f3 * f3 + f2 * f2);
            return !(d2 >= 6.9);
        }
        return false;
    }

    public static int getRGB(int n) {
        int n2 = (n & 0xFF) << 16 | n & 0xFF00 | (n & 0xFF0000) >> 16 | 0xFF000000;
        return n2;
    }

    public static int getARGB(int n) {
        int n2 = (n & 0xFF) << 16 | n & 0xFF00 | (n & 0xFF0000) >> 16 | 0xFF000000 & n;
        return n2;
    }

    public static int getFontSizeKey(Context context, int n, int n2) {
        int n3 = DFUtils.isMobile(context) ? n2 : n;
        return n3;
    }

    public static int getTextTypeFace(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        return n2;
    }

    public static int getTextGravity(int n) {
        int n2 = 3;
        switch (n) {
            case 0: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 17;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
        }
        return n2;
    }

    public static Drawable getMakeDrawable(Context context, Drawable drawable2, int n, int n2, int n3) {
        return DFUtils.getMakeDrawable(context, drawable2, 0, n, n2, n3);
    }

    public static Drawable getMakeDrawable(Context context, int n, int n2, int n3, int n4) {
        return DFUtils.getMakeDrawable(context, null, n, n2, n3, n4);
    }

    public static Drawable getMakeFitBitmalDrawable(Context context, int n, int n2, int n3, int n4, float f2) {
        BitmapDrawable bitmapDrawable = (BitmapDrawable)DFUtils.getMakeDrawable(context, null, n, n2, n3, n4);
        FitBitmapDrawable fitBitmapDrawable = new FitBitmapDrawable(bitmapDrawable.getBitmap(), f2);
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        boolean bl = (Boolean)dFStyleManager.getStyle(n2);
        if (bl) {
            int n5 = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(n3));
            fitBitmapDrawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(n5, PorterDuff.Mode.SRC_ATOP));
        }
        return fitBitmapDrawable;
    }

    private static Drawable getMakeDrawable(Context context, Drawable drawable2, int n, int n2, int n3, int n4) {
        Drawable drawable3 = null;
        drawable3 = drawable2 == null ? DFUtils.getImageDrawable(context, n) : drawable2;
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        boolean bl = (Boolean)dFStyleManager.getStyle(n2);
        if (bl) {
            int n5 = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(n3));
            drawable3.setColorFilter((ColorFilter)new PorterDuffColorFilter(n5, PorterDuff.Mode.SRC_ATOP));
        } else {
            String string = (String)dFStyleManager.getStyle(n4);
            try {
                Drawable drawable4;
                drawable3 = drawable4 = DFUtils.getDrawableFromURL(context, string);
            }
            catch (DFUtils$EmptyStringException dFUtils$EmptyStringException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return drawable3;
    }

    public static Drawable getDrawableFromURL(Context context, String string) {
        BitmapDrawable bitmapDrawable;
        block4: {
            bitmapDrawable = null;
            if (string.toLowerCase().startsWith("res://")) {
                bitmapDrawable = new BitmapDrawable(null, BitmapFactory.decodeStream((InputStream)context.getAssets().open(string.substring(6))));
                break block4;
            }
            if (string.toLowerCase().startsWith("http://") || string.toLowerCase().startsWith("https://")) {
                BitmapDrawable bitmapDrawable2;
                URL uRL = new URL(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setDoInput(true);
                httpURLConnection.connect();
                InputStream inputStream = httpURLConnection.getInputStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                bitmapDrawable = bitmapDrawable2 = new BitmapDrawable(null, bitmap);
                break block4;
            }
            throw new DFUtils$EmptyStringException();
        }
        return bitmapDrawable;
    }

    public static int getPlaceHolderColor(int n) {
        return DFUtils.getAlphaColor(n, 0.6);
    }

    public static int getDisableColor(int n) {
        return DFUtils.getAlphaColor(n, 0.4);
    }

    public static int getAlphaColor(int n, double d2) {
        int n2 = Color.red((int)n);
        int n3 = Color.green((int)n);
        int n4 = Color.blue((int)n);
        return Color.rgb((int)((int)(255.0 * (1.0 - d2) + (double)n2 * (2.0 * d2 - 1.0))), (int)((int)(255.0 * (1.0 - d2) + (double)n3 * (2.0 * d2 - 1.0))), (int)((int)(255.0 * (1.0 - d2) + (double)n4 * (2.0 * d2 - 1.0))));
    }

    public static int getRandomColor() {
        Random random = new Random();
        return Color.argb((int)255, (int)random.nextInt(256), (int)random.nextInt(256), (int)random.nextInt(256));
    }

    public static int calcContentSize(Context context, int n, int n2, int n3) {
        int n4 = DFUtils.toPx(context, n3);
        if (n == 0) {
            Point point = DFUtils.getScreenSize((Activity)context);
            int n5 = point.x;
            if (n4 > 0 && n5 > n4) {
                n2 = n4 - DFInflaterView.CONTENTS_TAB_SPACE * 2;
            }
        }
        return n2;
    }

    public static String calcFileSize(float f2) {
        String string = "KB";
        if (f2 >= 1048576.0f) {
            string = "MB";
            f2 /= 1048576.0f;
        } else {
            f2 /= 1024.0f;
        }
        if (f2 % 1.0f == 0.0f) {
            return String.format("%.0f", Float.valueOf(f2)) + string;
        }
        return String.format("%.1f", Float.valueOf(f2)) + string;
    }

    public static Dialog makeFullScreenDialog(Context context, View view) {
        Dialog dialog = new Dialog(context, 16973834);
        dialog.getWindow().requestFeature(1);
        dialog.setContentView(view);
        dialog.setCanceledOnTouchOutside(false);
        dialog.getWindow().getDecorView().setSystemUiVisibility(4102);
        View view2 = dialog.getWindow().getDecorView();
        view2.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)new DFUtils$2(view));
        return dialog;
    }
}

