/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.model.image;

import org.json.JSONArray;
import org.json.JSONObject;

public class DFImageModel {
    public float compRatio;
    public int jpgQuality;
    public boolean isPickModeCamera;
    public boolean isPickModeSeal;
    public boolean isPickModeID;
    public boolean isCameraShowToolbar;
    public boolean isCameraToolbarFlash;
    public boolean isCameraToolbarFacing;
    public int flashMode;
    public boolean showMaskArea;
    public int facingMode;
    public float compWidth;
    public float compHeight;
    public String initIDScanFilter;
    public Object[] idPaperInfo;
    public boolean isForceShoot;
    public boolean isShowChooseButton;
    public boolean isEndInput;
    public boolean isVisible;
    public boolean isEnable;
    public String errorMessage;

    public void setAttribute(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.setAttribute(jSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAttribute(JSONObject jSONObject) {
        this.compWidth = (float)jSONObject.optDouble("image_width");
        this.compHeight = (float)jSONObject.optDouble("image_height");
        this.jpgQuality = jSONObject.optInt("image_resizequality");
        this.isCameraShowToolbar = jSONObject.optBoolean("image_showtoolbar");
        this.isCameraToolbarFlash = jSONObject.optBoolean("image_showcameraflash");
        this.isCameraToolbarFacing = jSONObject.optBoolean("image_showcamerachange");
        int n = this.flashMode = jSONObject.optBoolean("image_isfrontcamera") ? 1 : 0;
        this.facingMode = jSONObject.optBoolean("image_isflashon") ? 1 : (jSONObject.optBoolean("image_isflashauto") ? 2 : 0);
        this.isShowChooseButton = jSONObject.optBoolean("image_showgallerybutton");
        this.isEndInput = jSONObject.optBoolean("image_endinput");
        this.errorMessage = jSONObject.optString("image_errormessage");
        this.compRatio = 1.0f;
        if (this.compHeight != 0.0f) {
            this.compRatio = this.compWidth / this.compHeight;
        }
        this.isPickModeCamera = false;
        this.isPickModeSeal = false;
        this.isPickModeID = false;
        this.initIDScanFilter = "";
        this.idPaperInfo = null;
        this.isForceShoot = true;
        this.showMaskArea = true;
        if (jSONObject.optBoolean("image_isseal", false)) {
            this.isPickModeSeal = true;
        } else if (jSONObject.optBoolean("image_isid", false)) {
            this.isPickModeID = true;
            JSONObject jSONObject2 = jSONObject.optJSONObject("image_idinfo");
            if (jSONObject2 != null) {
                Object[] objectArray = null;
                JSONArray jSONArray = jSONObject2.optJSONArray("items");
                if (jSONArray != null) {
                    int n2 = jSONArray.length();
                    objectArray = new Object[n2];
                    for (int j = 0; j < n2; ++j) {
                        JSONObject jSONObject3 = jSONArray.optJSONObject(j);
                        objectArray[j] = new Object[]{jSONObject3.optInt("id"), jSONObject3.optString("name")};
                    }
                }
                this.initIDScanFilter = "";
                this.isForceShoot = !jSONObject2.optBoolean("shoot_is_focus");
                this.idPaperInfo = new Object[]{jSONObject2.optString("title"), objectArray};
            }
            this.showMaskArea = jSONObject.optBoolean("image_showmaskarea");
        } else {
            this.isPickModeCamera = true;
        }
    }
}

