/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.check;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.check.DFCheckViewModel;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFButtonViewModel;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFCheckToggleButtonView;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFCheckToggleView
extends DFLayoutView
implements View.OnClickListener {
    DFCheckViewModel viewModel;
    LinearLayout mCheckLayout;
    private DFCheckToggleButtonView mToggleButton;
    static final int BUTTON_LEFT_PADDING = 20;

    public DFCheckToggleView(Context context, DFCheckViewModel dFCheckViewModel) {
        super(context);
        this.setViewModel(dFCheckViewModel);
        this.initView();
        this.setVisibility(4);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        if (bl) {
            this.setVisibility(0);
            this.updateView();
        }
    }

    public void setViewModel(DFCheckViewModel dFCheckViewModel) {
        this.viewModel = dFCheckViewModel;
    }

    private void initView() {
        this.mCheckLayout = new LinearLayout(this.getContext());
        this.mCheckLayout.setOrientation(0);
        this.mCheckLayout.setGravity(16);
        DFButtonViewModel dFButtonViewModel = new DFButtonViewModel(this.viewModel.buttonModel);
        this.mToggleButton = new DFCheckToggleButtonView(this.getContext(), this.viewModel.checkModel, dFButtonViewModel);
        this.mToggleButton.setOnClickListener(this);
        this.mCheckLayout.addView((View)this.mToggleButton);
        this.addView((View)this.mCheckLayout, (ViewGroup.LayoutParams)this.getContentLayoutParam());
        this.updateView();
    }

    public void onClick(View view) {
        if (view instanceof DFCheckToggleButtonView) {
            if (this.viewModel.isYes) {
                this.viewModel.isYes = false;
                ((DFCheckToggleButtonView)view).setSelected(false, false);
            } else {
                this.viewModel.isYes = true;
                ((DFCheckToggleButtonView)view).setSelected(true, false);
            }
        }
        this.executeEvent(12, null);
        this.updateView();
    }

    protected Object OnScript(int n, Object object) {
        Object object2 = null;
        switch (n) {
            case -16777211: {
                object2 = String.valueOf(this.viewModel.isYes);
                break;
            }
            case -16777208: {
                String string = (String)object;
                this.viewModel.checkModel.setAttribute(string);
                break;
            }
            case -16777209: {
                object2 = this.viewModel.formid;
                break;
            }
            case -16777206: {
                object2 = this.viewModel.checkModel.isEndInput;
                break;
            }
            case -16777207: {
                int n2 = (Integer)object;
                if (n2 != 1) break;
                this.updateView();
                break;
            }
            case -16777210: {
                String string = (String)object;
                if (string.equals("::true")) {
                    this.viewModel.isYes = true;
                    this.updateView();
                    break;
                }
                if (!string.equals("::false")) break;
                this.viewModel.isYes = false;
                this.updateView();
                break;
            }
        }
        return object2;
    }

    public int calcButtonWidth() {
        int n = DFUtils.toDP(this.getContext(), 30.0f);
        int n2 = this.getWidth() - n * 2;
        this.mToggleButton.setText(this.viewModel.checkModel.yesText);
        this.mToggleButton.measure(0, 0);
        int n3 = this.mToggleButton.getMeasuredWidth();
        this.mToggleButton.setText(this.viewModel.checkModel.noText);
        this.mToggleButton.measure(0, 0);
        int n4 = this.mToggleButton.getMeasuredWidth();
        int n5 = Math.max(n3, n4);
        if (n5 > n2) {
            n5 = n2;
        }
        return n5;
    }

    public void updateView() {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mToggleButton.getLayoutParams();
        layoutParams.width = this.calcButtonWidth();
        int n = DFUtils.toDP(this.getContext(), 20.0f);
        layoutParams.setMargins(n, 0, 0, 0);
        this.mToggleButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.viewModel.isYes) {
            this.mToggleButton.setText(this.viewModel.checkModel.yesText);
            this.mToggleButton.setSelected(true, false);
        } else {
            this.mToggleButton.setText(this.viewModel.checkModel.noText);
            this.mToggleButton.setSelected(false, false);
        }
    }

    public int getCheckImageSize() {
        return this.viewModel.checkModel.useCheckMark ? DFUtils.toDP(this.getContext(), 30.0f) : 0;
    }
}

