/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.confirmbutton;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.confirmbutton.DFConfirmButtonView$1;
import oz.viewer.ui.df.mvvm.views.confirmbutton.DFConfirmButtonViewModel;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFConfirmButtonView
extends DFLayoutView {
    private String mButtonText;
    private TextView tv;
    private int buttonWidth;
    private int buttonHeight;
    public DFConfirmButtonViewModel confirmButtonViewModel;

    public DFConfirmButtonView(Context context, DFConfirmButtonViewModel dFConfirmButtonViewModel) {
        super(context);
        this.confirmButtonViewModel = dFConfirmButtonViewModel;
        this.initView();
    }

    private void initView() {
        this.mButtonText = this.confirmButtonViewModel.confirmModel.text;
        this.tv = new TextView(this.getContext());
        this.tv.setTextColor(this.confirmButtonViewModel.confirmModel.textColor);
        this.tv.setTextSize((float)this.confirmButtonViewModel.confirmModel.textSize);
        this.tv.setText((CharSequence)(this.mButtonText.isEmpty() ? "OK" : this.mButtonText));
        this.tv.setTypeface(null, 1);
        this.tv.setClickable(false);
        this.tv.setSingleLine();
        this.tv.setGravity(17);
        this.tv.setPadding(DFUtils.toDP(this.getContext(), 20.0f), 0, DFUtils.toDP(this.getContext(), 20.0f), 0);
        this.tv.setOnTouchListener((View.OnTouchListener)new DFConfirmButtonView$1(this));
        this.buttonWidth = DFUtils.toDP(this.getContext(), 112.0f);
        this.buttonHeight = DFUtils.toDP(this.getContext(), 51.0f);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        this.tv.setMinimumWidth(this.buttonWidth);
        this.tv.setMinimumHeight(this.buttonHeight);
        if (this.confirmButtonViewModel.confirmModel.sizeType == 1) {
            layoutParams = new FrameLayout.LayoutParams(-1, this.buttonHeight);
            this.buttonWidth = layoutParams.width;
        }
        layoutParams.topMargin = DFUtils.toDP(this.getContext(), 10.0f);
        layoutParams.bottomMargin = DFUtils.toDP(this.getContext(), 10.0f);
        this.tv.setBackground(this.createBackground(this.buttonWidth, this.buttonHeight));
        this.addView((View)this.tv, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setButtonWidth(int n) {
        this.buttonWidth = n;
        this.tv.setBackground(this.createBackground(this.buttonWidth, this.buttonHeight));
    }

    private Drawable createBackground(int n, int n2) {
        float f2 = this.confirmButtonViewModel.confirmModel.radius;
        f2 = f2 < 0.0f ? (float)n2 / 2.0f : f2;
        RoundRectShape roundRectShape = new RoundRectShape(new float[]{f2, f2, f2, f2, f2, f2, f2, f2}, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.getPaint().setAntiAlias(true);
        shapeDrawable.getPaint().setColor(this.confirmButtonViewModel.confirmModel.backgroundColor);
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        return shapeDrawable;
    }

    public void confirmBtnClick() {
        this.executeEvent(3, null);
    }
}

