/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import android.widget.TimePicker;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import oz.materialcalendarview.CalendarDay;
import oz.materialcalendarview.MaterialCalendarView;
import oz.materialcalendarview.MaterialStyle;
import oz.materialcalendarview.OneDayDecorator;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.viewer.ui.df.DFManager;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.date.DFDateView$1;
import oz.viewer.ui.df.mvvm.views.date.DFDateView$2;
import oz.viewer.ui.df.mvvm.views.date.DFDateView$3;
import oz.viewer.ui.df.mvvm.views.date.DFDateView$4;
import oz.viewer.ui.df.mvvm.views.date.DFDateView$TimeInfo;
import oz.viewer.ui.df.mvvm.views.date.DFDateViewModel;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFButtonViewModel;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFListButtonView;
import oz.viewer.ui.df.mvvm.views.popup.DFDatePopupButton;
import oz.viewer.ui.df.mvvm.views.popup.DFDatePopupView;
import oz.viewer.ui.df.view.DFLayoutView;
import oz.viewer.ui.df.view.DFLayoutView$OnEventListener;

public class DFDateView
extends DFLayoutView
implements View.OnClickListener {
    private DFDateViewModel viewModel;
    private DFButtonViewModel resetButtonViewModel;
    private DFDateView _This;
    private DFDatePopupView popupView;
    private DFDatePopupButton mPopupButton;
    private DFManager manager;
    private LinearLayout mRoot;
    private LinearLayout dateTimePickerLayout = null;
    private LinearLayout contentLayout = null;
    private TimePicker tp;
    private final DFDateView$TimeInfo mTime;
    private DFDateView$TimeInfo mMinTime;
    private DFDateView$TimeInfo mMaxTime;
    private MaterialCalendarView calendar;
    private CalendarDay oldCalendarDay = null;
    private OneDayDecorator oneDayCecorator = null;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private DFListButtonView mResetButton = null;

    public DFDateView(Context context, DFDateViewModel dFDateViewModel, DFButtonViewModel dFButtonViewModel) {
        super(context);
        this.viewModel = dFDateViewModel;
        this.resetButtonViewModel = dFButtonViewModel;
        this._This = this;
        this.mTime = new DFDateView$TimeInfo(this, null);
        this.mMinTime = new DFDateView$TimeInfo(this, null);
        this.mMaxTime = new DFDateView$TimeInfo(this, null);
        this.mMinTime.setDate(dFDateViewModel.dateModel.minDate);
        this.mMaxTime.setDate(dFDateViewModel.dateModel.maxDate);
        this.initView();
    }

    public void setManager(DFManager dFManager) {
        this.manager = dFManager;
    }

    public DFManager getManager() {
        return this.manager;
    }

    private void initView() {
        this.setComponentText();
        this.mRoot = new LinearLayout(this.getContext());
        this.mRoot.setOrientation(1);
        this.updateDTPLayout();
        this.addView((View)this.mRoot);
    }

    public DFDateViewModel getViewModel() {
        return this.viewModel;
    }

    public void updateView() {
        this.updateDTPLayout();
    }

    private void setComponentText() {
        if (!this.viewModel.value.isEmpty()) {
            Date date = new Date(Long.parseLong(this.viewModel.value));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (this.viewModel.dateModel.isTimePicker) {
                this.mTime.setDateTime(calendar);
            } else {
                this.mTime.setDate(calendar);
            }
            if (this.mTime.toDate().getTime() < this.mMinTime.toDate().getTime()) {
                this.mTime.setDate(this.viewModel.dateModel.minDate);
            } else if (this.mTime.toDate().getTime() > this.mMaxTime.toDate().getTime()) {
                this.mTime.setDate(this.viewModel.dateModel.maxDate);
            }
        }
    }

    private void updateDTPLayout() {
        if (this.contentLayout != null) {
            this.mRoot.removeView((View)this.contentLayout);
            this.contentLayout.removeAllViews();
            this.contentLayout = null;
        }
        if (this.contentLayout == null) {
            this.contentLayout = new LinearLayout(this.getContext());
            this.contentLayout.setOrientation(0);
            this.mRoot.addView((View)this.contentLayout);
            if (this.viewModel.isPopupMode) {
                if (this.mPopupButton == null) {
                    this.addPopupButton();
                }
            } else {
                if (this.dateTimePickerLayout != null) {
                    this.contentLayout.removeView((View)this.dateTimePickerLayout);
                    this.dateTimePickerLayout = null;
                }
                if (this.mResetButton != null) {
                    this.mRoot.removeView((View)this.mResetButton);
                    this.mResetButton = null;
                }
                this.mResetButton = this.makeResetButton();
                if (this.mResetButton != null) {
                    this.mRoot.addView((View)this.mResetButton, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
                }
                this.dateTimePickerLayout = this.makeDatetimePickerLayout(this.mResetButton);
                this.contentLayout.addView((View)this.dateTimePickerLayout, 0);
            }
        }
    }

    private void setPopupButtonText() {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        int n = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_POPUPBUTTON_FONT_COLOR));
        String string = "";
        if (this.viewModel.dateModel.isAllowEmpty && this.viewModel.dateModel.iscurrentdateempty.booleanValue()) {
            string = this.viewModel.dateModel.placeHolder;
            this.viewModel.value = "";
            n = DFUtils.getPlaceHolderColor(n);
        } else {
            long l = Long.parseLong(this.viewModel.value);
            string = this.getTimeAsPattern(this.viewModel.pattern, l);
        }
        if (this.mPopupButton != null) {
            this.mPopupButton.setText(string);
            this.mPopupButton.setTextColor(n);
        }
    }

    private void setPopupButtonText(String string) {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        int n = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_POPUPBUTTON_FONT_COLOR));
        if (!string.isEmpty()) {
            this.setComponentText();
            long l = Long.parseLong(string);
            this.mPopupButton.setText(this.getTimeAsPattern(this.viewModel.pattern, l));
        } else {
            this.mPopupButton.setText(this.viewModel.dateModel.placeHolder);
            n = DFUtils.getPlaceHolderColor(n);
        }
        this.mPopupButton.setTextColor(n);
        if (!this.viewModel.dateModel.isEndInput) {
            this.executeEvent(14, this.OnScript(-16777211, null));
        }
    }

    private void addPopupButton() {
        this.mPopupButton = new DFDatePopupButton(this.getContext());
        this.mPopupButton.setSingleLine();
        this.mPopupButton.setMinimumHeight(100);
        this.mPopupButton.setEllipsize(TextUtils.TruncateAt.END);
        this.setPopupButtonText();
        this.mPopupButton.setOnClickListener(new DFDateView$1(this));
        int n = DFUtils.toDP(this.getContext(), 20.0f);
        this.mRoot.setPadding(n, 0, 0, 0);
        this.mRoot.addView((View)this.mPopupButton, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
    }

    public DFListButtonView makeResetButton() {
        DFListButtonView dFListButtonView = null;
        if (this.viewModel.dateModel.isAllowEmpty) {
            dFListButtonView = new DFListButtonView(this.getContext(), this.resetButtonViewModel);
            dFListButtonView.setId(12289);
            dFListButtonView.setText(this.viewModel.dateModel.emptyString);
            dFListButtonView.setOnClickListener(this);
            dFListButtonView.updateTextViewColor();
            dFListButtonView.applyRect();
        }
        return dFListButtonView;
    }

    public LinearLayout makeDatetimePickerLayout(DFListButtonView dFListButtonView) {
        LinearLayout linearLayout = null;
        boolean bl = DFUtils.isMobile(this.getContext());
        linearLayout = new LinearLayout(this.getContext());
        int n = this.getResources().getConfiguration().orientation;
        if (n == 1) {
            linearLayout.setOrientation(1);
        } else if (n == 2) {
            linearLayout.setOrientation(0);
        }
        MaterialStyle materialStyle = new MaterialStyle();
        Drawable drawable2 = this.viewModel.dateModel.leftDR;
        Drawable drawable3 = this.viewModel.dateModel.rightDR;
        int n2 = this.viewModel.dateModel.fontColor;
        int n3 = this.viewModel.dateModel.selectFontColor;
        materialStyle.fontColor = this.viewModel.dateModel.fontColor;
        materialStyle.selectBorderColor = this.viewModel.dateModel.selectBorderColor;
        materialStyle.selectBackgroundColor = this.viewModel.dateModel.selectBackgroundColor;
        materialStyle.todayColor = this.viewModel.dateModel.todayColor;
        materialStyle.disableDayColor = this.viewModel.dateModel.disableDayColor;
        materialStyle.sundayColor = this.viewModel.dateModel.sundayColor;
        materialStyle.saturdayColor = this.viewModel.dateModel.saturdayColor;
        materialStyle.lineColor = this.viewModel.isPopupMode ? -16777216 : -1;
        this.calendar = new MaterialCalendarView(this.getContext(), materialStyle);
        this.oneDayCecorator = new OneDayDecorator();
        this.oneDayCecorator.setFocusedTextColor(n3);
        this.calendar.addDecorator(this.oneDayCecorator);
        this.calendar.setShowOtherDates(5);
        drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(n2, PorterDuff.Mode.SRC_ATOP));
        drawable3.setColorFilter((ColorFilter)new PorterDuffColorFilter(n2, PorterDuff.Mode.SRC_ATOP));
        this.calendar.setLeftArrow(drawable2);
        this.calendar.setRightArrow(drawable3);
        this.tp = new TimePicker(this.getContext(), null, 1);
        this.tp.setIs24HourView(Boolean.valueOf(true));
        if (this.viewModel.dateModel.isAllowEmpty && this.viewModel.dateModel.iscurrentdateempty.booleanValue()) {
            if (dFListButtonView != null) {
                dFListButtonView.setSelected(true);
                this.oneDayCecorator.setDate(null);
                this.calendar.invalidateDecorators();
            }
        } else {
            this.tp.setCurrentHour(Integer.valueOf(this.mTime.hour));
            this.tp.setCurrentMinute(Integer.valueOf(this.mTime.min));
        }
        LocalDate localDate = LocalDate.of(this.mTime.year, this.mTime.month, this.mTime.day);
        LocalDate localDate2 = LocalDate.of(this.mMinTime.year, this.mMinTime.month, this.mMinTime.day);
        LocalDate localDate3 = LocalDate.of(this.mMaxTime.year, this.mMaxTime.month, this.mMaxTime.day);
        this.calendar.state().edit().setMinimumDate(localDate2).setMaximumDate(localDate3).commit();
        CalendarDay calendarDay = CalendarDay.from(localDate);
        if (calendarDay != null && !this.viewModel.dateModel.iscurrentdateempty.booleanValue()) {
            this.calendar.setDateSelected(calendarDay, true);
            this.calendar.setCurrentDate(calendarDay, true);
            this.oneDayCecorator.setDate(calendarDay);
            this.oldCalendarDay = calendarDay;
        }
        this.tp.setOnTimeChangedListener((TimePicker.OnTimeChangedListener)new DFDateView$2(this));
        this.calendar.setOnMonthChangedListener(new DFDateView$3(this));
        this.calendar.setOnDateChangedListener(new DFDateView$4(this));
        int n4 = DFUtils.toDP(this.getContext(), 350.0f);
        linearLayout.addView((View)this.calendar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n4, n4));
        int n5 = Resources.getSystem().getIdentifier("hour", "id", "android");
        int n6 = Resources.getSystem().getIdentifier("minute", "id", "android");
        int n7 = Resources.getSystem().getIdentifier("amPm", "id", "android");
        NumberPicker numberPicker = (NumberPicker)this.tp.findViewById(n5);
        NumberPicker numberPicker2 = (NumberPicker)this.tp.findViewById(n6);
        this.setNumberPickerTextColor(numberPicker, n2);
        this.setNumberPickerTextColor(numberPicker2, n2);
        if (this.viewModel.dateModel.isTimePicker) {
            this.tp.setPadding(this.viewModel.dateModel.timePickerPadding, 0, this.viewModel.dateModel.timePickerPadding, this.viewModel.dateModel.timePickerPadding);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.gravity = 16;
            linearLayout.addView((View)this.tp, (ViewGroup.LayoutParams)layoutParams);
        }
        return linearLayout;
    }

    private void setNumberPickerTextColor(NumberPicker numberPicker, int n) {
        int n2 = numberPicker.getChildCount();
        for (int j = 0; j < n2; ++j) {
            View view = numberPicker.getChildAt(j);
            try {
                Field field = numberPicker.getClass().getDeclaredField("mSelectorWheelPaint");
                field.setAccessible(true);
                ((Paint)field.get(numberPicker)).setColor(n);
                ((EditText)view).setTextColor(n);
                numberPicker.invalidate();
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Log.w((String)"setNumberPickerTextColor", (Throwable)noSuchFieldException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.w((String)"setNumberPickerTextColor", (Throwable)illegalAccessException);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)"setNumberPickerTextColor", (Throwable)illegalArgumentException);
            }
        }
    }

    private int[] splitDate(String string, String object) {
        Object object2;
        int[] nArray = new int[5];
        Date date = null;
        try {
            object2 = "";
            if (!(((String)object).equalsIgnoreCase("STRING") || ((String)object).indexOf("yy") >= 0 && ((String)object).indexOf("MM") >= 0 && ((String)object).indexOf("dd") >= 0)) {
                String string2;
                object2 = "yyyy-MM-dd";
                int n = -1;
                int n2 = ((String)object).indexOf("H");
                n = n2 == -1 ? Math.min(((String)object).indexOf("h"), ((String)object).indexOf("m")) : Math.min(((String)object).indexOf("H"), ((String)object).indexOf("m"));
                if (n != -1 && !"".equals(string2 = ((String)object).substring(n))) {
                    object2 = (String)object2 + string2;
                }
                object = object2;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object, this.viewModel.dateModel.locale);
            date = !"".equals(string) ? simpleDateFormat.parse(string) : new Date();
        }
        catch (Exception exception) {
            Log.e((String)"OZViewer", (String)("Not supported pattern : " + exception.getLocalizedMessage()));
            object = "yyyy-MM-dd";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object, this.viewModel.dateModel.locale);
            try {
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                Log.e((String)"OZViewer", (String)("Not supported text : " + parseException.getLocalizedMessage()));
                date = new Date();
            }
        }
        object2 = Calendar.getInstance();
        ((Calendar)object2).setTime(date);
        nArray[0] = ((Calendar)object2).get(1);
        nArray[1] = ((Calendar)object2).get(2) + 1;
        nArray[2] = ((Calendar)object2).get(5);
        nArray[3] = ((Calendar)object2).get(11);
        nArray[4] = ((Calendar)object2).get(12);
        return nArray;
    }

    public void onClick(View view) {
        if (this.calendar != null && this.tp != null) {
            this.executeEvent(12, null);
            this.calendar.clearSelection();
            this.tp.setCurrentHour(Integer.valueOf(0));
            this.tp.setCurrentMinute(Integer.valueOf(0));
            DFListButtonView dFListButtonView = this.viewModel.isPopupMode ? (DFListButtonView)this.manager.getDialog().findViewById(12289) : (DFListButtonView)this._This.findViewById(12289);
            if (dFListButtonView != null) {
                dFListButtonView.setSelected(true);
                this.oneDayCecorator.setDate(null);
                this.calendar.invalidateDecorators();
            }
        }
    }

    private String getViewValue() {
        if (this.calendar != null) {
            CalendarDay calendarDay = this.calendar.getSelectedDate();
            if (calendarDay != null) {
                Date date;
                String string = FORMATTER.format(calendarDay.getDate());
                int n = Calendar.getInstance().getTime().getSeconds();
                String string2 = String.format(Locale.ENGLISH, "%s:%s:%d", String.format(Locale.ENGLISH, "%02d", this.tp.getCurrentHour()), String.format(Locale.ENGLISH, "%02d", this.tp.getCurrentMinute()), n);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
                try {
                    date = simpleDateFormat.parse(String.format("%s %s", string, string2));
                }
                catch (ParseException parseException) {
                    Log.e((String)"OZViewer", (String)("Not supported pattern(confirm) : " + parseException.getLocalizedMessage()));
                    date = new Date();
                }
                this.viewModel.value = String.valueOf(date.getTime());
            } else {
                this.viewModel.value = "";
            }
        }
        return this.viewModel.value;
    }

    public Object script(int n, Object object) {
        return this.OnScript(n, object);
    }

    protected Object OnScript(int n, Object object) {
        Object object2 = null;
        switch (n) {
            case -16777208: {
                String string = (String)object;
                this.viewModel.dateModel.setAttribute(string);
                break;
            }
            case -16777207: {
                int n2 = (Integer)object;
                if (n2 != 1) break;
                this.updateView();
                break;
            }
            case -16777211: {
                object2 = this.getViewValue();
                break;
            }
            case -16777209: {
                object2 = this.viewModel.formid;
                break;
            }
            case -16777206: {
                object2 = this.viewModel.dateModel.isEndInput;
                break;
            }
            case 31: {
                this.executeEvent(n, null);
                Boolean bl = (Boolean)object;
                if (!bl.booleanValue()) break;
                this.setPopupButtonText(this.getViewValue());
                break;
            }
            case -16777210: {
                this.viewModel.value = (String)object;
                this.setComponentText();
                this.updateView();
            }
        }
        return object2;
    }

    public String getTimeAsPattern(String string, long l) {
        if (string.startsWith("date_")) {
            string = string.substring(5);
        } else if (string.startsWith("d_") || string.startsWith("D_")) {
            string = string.substring(2);
        } else if ("STRING".equals(string)) {
            string = "yyyy-MM-dd";
        }
        if (string.startsWith("ggge") || string.startsWith("ge")) {
            string = "yyyy-MM-dd";
        }
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            String string2 = simpleDateFormat.format(date);
            return string2;
        }
        catch (Exception exception) {
            return "data format exception";
        }
    }

    static /* synthetic */ DFDatePopupView access$100(DFDateView dFDateView) {
        return dFDateView.popupView;
    }

    static /* synthetic */ DFDatePopupView access$102(DFDateView dFDateView, DFDatePopupView dFDatePopupView) {
        dFDateView.popupView = dFDatePopupView;
        return dFDateView.popupView;
    }

    static /* synthetic */ void access$200(DFDateView dFDateView, int n, Object object) {
        dFDateView.executeEvent(n, object);
    }

    static /* synthetic */ DFDateView access$300(DFDateView dFDateView) {
        return dFDateView._This;
    }

    static /* synthetic */ DFLayoutView$OnEventListener access$400(DFDateView dFDateView) {
        return dFDateView.mEventListener;
    }

    static /* synthetic */ DFManager access$500(DFDateView dFDateView) {
        return dFDateView.manager;
    }

    static /* synthetic */ DFDateViewModel access$600(DFDateView dFDateView) {
        return dFDateView.viewModel;
    }

    static /* synthetic */ void access$700(DFDateView dFDateView, int n, Object object) {
        dFDateView.executeEvent(n, object);
    }

    static /* synthetic */ void access$800(DFDateView dFDateView, int n, Object object) {
        dFDateView.executeEvent(n, object);
    }

    static /* synthetic */ void access$900(DFDateView dFDateView, int n, Object object) {
        dFDateView.executeEvent(n, object);
    }

    static /* synthetic */ CalendarDay access$1000(DFDateView dFDateView) {
        return dFDateView.oldCalendarDay;
    }

    static /* synthetic */ CalendarDay access$1002(DFDateView dFDateView, CalendarDay calendarDay) {
        dFDateView.oldCalendarDay = calendarDay;
        return dFDateView.oldCalendarDay;
    }

    static /* synthetic */ OneDayDecorator access$1100(DFDateView dFDateView) {
        return dFDateView.oneDayCecorator;
    }

    static /* synthetic */ void access$1200(DFDateView dFDateView, int n, Object object) {
        dFDateView.executeEvent(n, object);
    }

    static /* synthetic */ DFDateView$TimeInfo access$1300(DFDateView dFDateView) {
        return dFDateView.mMaxTime;
    }
}

