/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.date;

import android.content.Context;
import org.json.JSONObject;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.model.date.DFDateModel;

public class DFDateViewModel {
    public DFDateModel dateModel;
    public String formid;
    public String value;
    public String pattern;
    public int questionnumber;
    public String question;
    public String description;
    public boolean isPopupMode;
    public Context context;

    public DFDateViewModel(DFDateModel dFDateModel) {
        this.dateModel = dFDateModel;
    }

    public DFDateViewModel(Context context) {
        this.dateModel = new DFDateModel();
        this.context = context;
    }

    public void setAttribute(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.setAttribute(jSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAttribute(JSONObject jSONObject) {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        this.formid = jSONObject.optString("formid");
        this.value = jSONObject.optString("date_date");
        this.pattern = jSONObject.optString("date_pattern");
        this.questionnumber = jSONObject.optInt("questionnumber");
        this.question = jSONObject.optString("question");
        this.description = jSONObject.optString("description");
        this.isPopupMode = jSONObject.optBoolean("date_ispopup");
        this.dateModel.leftDR = DFUtils.getImageDrawable(this.context, 24);
        this.dateModel.rightDR = DFUtils.getImageDrawable(this.context, 25);
        this.dateModel.setAttribute(jSONObject);
        if (this.isPopupMode) {
            this.dateModel.fontColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DATETIMEPICKER_FONT_COLOR));
            this.dateModel.selectBorderColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DATETIMEPICKER_SELECT_BORDER_COLOR));
            this.dateModel.selectBackgroundColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DATETIMEPICKER_SELECT_BACKGROUND_COLOR));
            this.dateModel.todayColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DATETIMEPICKER_TODAY_COLOR));
            this.dateModel.disableDayColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DATETIMEPICKER_DISABLE_DAY_COLOR));
            this.dateModel.sundayColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DATETIMEPICKER_SUNDAY_COLOR));
            this.dateModel.saturdayColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DATETIMEPICKER_SATURDAY_COLOR));
            this.dateModel.selectFontColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DATETIMEPICKER_SELECT_COLOR));
        } else {
            this.dateModel.fontColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_DATETIMEPICKER_FONT_COLOR));
            this.dateModel.selectBorderColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_DATETIMEPICKER_SELECT_BORDER_COLOR));
            this.dateModel.selectBackgroundColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_DATETIMEPICKER_SELECT_BACKGROUND_COLOR));
            this.dateModel.todayColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_DATETIMEPICKER_TODAY_COLOR));
            this.dateModel.disableDayColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_DATETIMEPICKER_DISABLE_DAY_COLOR));
            this.dateModel.sundayColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_DATETIMEPICKER_SUNDAY_COLOR));
            this.dateModel.saturdayColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_DATETIMEPICKER_SATURDAY_COLOR));
            this.dateModel.selectFontColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_DATETIMEPICKER_SELECT_COLOR));
        }
    }
}

