/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.dfbutton;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.model.check.DFCheckModel;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFBaseButtonView;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFButtonViewModel;

public class DFCheckToggleButtonView
extends DFBaseButtonView {
    DFCheckModel mCheckModel;
    private static final int DP_PADDING = 12;
    private static final int SP_TEXT_SIZE = 16;
    private static final int SP_TEXT_MIN_WIDTH = 200;
    private LinearLayout mLayout;
    private TextView mTextView;
    private Bitmap checkBitmap;
    private Bitmap uncheckBitmap;
    private ImageView checkImageView;

    public DFCheckToggleButtonView(Context context, DFCheckModel dFCheckModel, DFButtonViewModel dFButtonViewModel) {
        super(context, dFButtonViewModel);
        this.mCheckModel = dFCheckModel;
        this.initLayout();
        this.loadImageResource();
    }

    private void loadImageResource() {
        Drawable drawable2;
        try {
            if (this.viewModel.checkedMarkImagePath == null || this.viewModel.checkedMarkImagePath.isEmpty()) {
                this.viewModel.checkedMarkImagePath = "res://resource/df/check_box_check.png";
            }
            if ((drawable2 = DFUtils.getDrawableFromURL(this.getContext(), this.viewModel.checkedMarkImagePath)) instanceof BitmapDrawable) {
                this.checkBitmap = ((BitmapDrawable)drawable2).getBitmap();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.viewModel.uncheckedMarkImage == null || this.viewModel.uncheckedMarkImage.isEmpty()) {
                this.viewModel.uncheckedMarkImage = "res://resource/df/check_box_uncheck.png";
            }
            if ((drawable2 = DFUtils.getDrawableFromURL(this.getContext(), this.viewModel.uncheckedMarkImage)) instanceof BitmapDrawable) {
                this.uncheckBitmap = ((BitmapDrawable)drawable2).getBitmap();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Drawable createDeselectedDrawable() {
        return super.createDrawable();
    }

    protected Drawable createSelectedDrawable() {
        return super.createSelectedDrawable();
    }

    protected Drawable createDisabledDrawable() {
        GradientDrawable gradientDrawable = (GradientDrawable)this.createDeselectedDrawable();
        return gradientDrawable;
    }

    protected Drawable createDrawable() {
        Drawable drawable2 = this.createSelectedDrawable();
        Drawable drawable3 = this.createDeselectedDrawable();
        Drawable drawable4 = this.createDisabledDrawable();
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{-16842910}, drawable4);
        stateListDrawable.addState(new int[]{16842919}, drawable2);
        stateListDrawable.addState(new int[]{-16842913}, drawable3);
        stateListDrawable.addState(new int[]{0x10100A1}, drawable2);
        return stateListDrawable;
    }

    private void initLayout() {
        int n = DFUtils.toDP(this.getContext(), 12.0f);
        this.mLayout.setPadding(n, n, n + this.getCheckImageSize(), n);
        this.checkImageView = new ImageView(this.getContext());
        this.mLayout.addView((View)this.checkImageView, this.getCheckImageSize(), this.getCheckImageSize());
        this.mLayout.invalidate();
        this.mTextView = new TextView(this.getContext());
        this.mTextView.setMinWidth(200);
        this.mTextView.setTextSize(16.0f);
        this.mTextView.setTextColor(this.viewModel.model.itembuttonFontColor);
        this.mTextView.setTextAlignment(4);
        this.mTextView.setSingleLine();
        this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mTextView.setPadding(this.mCheckModel.useCheckMark ? DFUtils.toDP(this.getContext(), 5.0f) : 0, 0, 0, 0);
        this.mLayout.addView((View)this.mTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 10.0f));
    }

    protected void addImageView(ImageView imageView) {
        this.mLayout = new LinearLayout(this.getContext());
        this.mLayout.setOrientation(0);
        this.mLayout.setGravity(19);
        int n = DFUtils.toDP(this.getContext(), 12.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.mLayout.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
        this.mLayout.setGravity(16);
        this.addView((View)this.mLayout);
        this.updateMargin();
    }

    public void setText(String string) {
        this.mTextView.setText((CharSequence)string);
        this.updateMargin();
    }

    private void updateMargin() {
        int n;
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.getImageView().getLayoutParams();
        layoutParams.rightMargin = this.viewModel.mHasImage && this.mTextView.getText().length() > 0 ? (n = DFUtils.toDP(this.getContext(), 12.0f)) : 0;
    }

    protected void initExtra() {
        super.initExtra();
    }

    public void setTextColor(int n) {
        this.mTextView.setTextColor(n);
    }

    public void setTextSize(float f2) {
        this.mTextView.setTextSize(f2);
    }

    public void setGravity(int n) {
        this.mTextView.setGravity(n);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mTextView.setEnabled(bl);
        this.updateTextViewColor();
    }

    private void updateTextViewColor() {
        int n = this.viewModel.model.itembuttonFontColor;
        int n2 = DFUtils.getPlaceHolderColor(n);
        this.mTextView.setTextColor(this.mTextView.isEnabled() ? n : n2);
    }

    public void setSelected(boolean bl, boolean bl2) {
        super.setSelected(bl);
        this.calcCheckImageSize();
        if (bl) {
            this.checkImageView.setImageBitmap(this.checkBitmap);
            if (this.viewModel.isUseCheckMarkColor) {
                Drawable drawable2 = this.checkImageView.getDrawable();
                drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.viewModel.checkMarkColor, PorterDuff.Mode.SRC_IN));
            }
        } else {
            this.checkImageView.setImageBitmap(this.uncheckBitmap);
            if (this.viewModel.isUseUncheckMarkColor) {
                Drawable drawable3 = this.checkImageView.getDrawable();
                drawable3.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.viewModel.uncheckMarkColor, PorterDuff.Mode.SRC_IN));
            }
        }
        if (this.mCheckModel.useCheckMark) {
            this.checkImageView.setVisibility(0);
        } else {
            this.checkImageView.setVisibility(4);
        }
    }

    private void calcCheckImageSize() {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.checkImageView.getLayoutParams();
        layoutParams.width = this.getCheckImageSize();
        layoutParams.height = this.getCheckImageSize();
        this.checkImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public int getCheckImageSize() {
        return this.mCheckModel.useCheckMark ? DFUtils.toDP(this.getContext(), 30.0f) : 0;
    }
}

