/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.image;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import java.util.HashMap;
import oz.main.MainFrameView;
import oz.util.view.camera.ImageIDView;
import oz.util.view.camera.ImageIDView$OnIDListener;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.ctrl.DFImageRecognitionData;
import oz.viewer.ui.df.mvvm.views.image.DFBaseImagePickerView;
import oz.viewer.ui.df.mvvm.views.image.DFIDImageView$1;
import oz.viewer.ui.df.mvvm.views.image.DFIDImageView$2;
import oz.viewer.ui.df.mvvm.views.image.DFImageViewModel;
import oz.viewer.ui.df.view.DFSelectItemView;

public class DFIDImageView
extends DFBaseImagePickerView
implements ImageIDView$OnIDListener {
    private LinearLayout mIDPaperInfoLayout;
    private ImageIDView mImageIDView;
    private Bitmap mBitmap;
    private String mJPGBase64EncodingData;
    private int[] mIDs;
    private String[] mNames;

    public DFIDImageView(Context context, DFImageViewModel dFImageViewModel) {
        super(context, dFImageViewModel);
        this.initView();
        this.updatePickerView();
    }

    void initView() {
        this.addView((View)this.getContentLayout(-1, 700));
        this.updateButtons();
        String string = this.viewModel.imageModel.initIDScanFilter;
        if (string == null || !string.isEmpty()) {
            this.hideAllLayout(true);
            MainFrameView.AlertDialog("", string, new DFIDImageView$1(this));
        }
        if (this.viewModel.imageModel.idPaperInfo != null) {
            int n;
            this.mIDPaperInfoLayout = new LinearLayout(this.getContext());
            this.mIDPaperInfoLayout.setOrientation(1);
            Object[] objectArray = (Object[])this.viewModel.imageModel.idPaperInfo[1];
            int n2 = n = objectArray != null ? objectArray.length : 0;
            if (n > 0) {
                this.mIDs = new int[n];
                this.mNames = new String[n];
                for (int j = 0; j < n; ++j) {
                    Object[] objectArray2 = (Object[])objectArray[j];
                    this.mIDs[j] = (Integer)objectArray2[0];
                    this.mNames[j] = (String)objectArray2[1];
                    DFSelectItemView dFSelectItemView = new DFSelectItemView(this.getContext());
                    dFSelectItemView.setText(this.mNames[j]);
                    dFSelectItemView.setTag(this.mIDs[j]);
                    dFSelectItemView.setOnClickListener(this);
                    int n3 = DFUtils.toDP(this.getContext(), 10.0f);
                    LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                    layoutParams.setMargins(0, n3, 0, 0);
                    this.mIDPaperInfoLayout.addView((View)dFSelectItemView, (ViewGroup.LayoutParams)layoutParams);
                }
            }
            this.mRootFrameLayout.addView((View)this.mIDPaperInfoLayout);
        }
        this.updatePaperInfoView();
    }

    public void updateView() {
        this.mImageIDView.setPictureRatio(this.viewModel.imageModel.compRatio);
        this.updatePickerView();
    }

    protected FrameLayout getImagePickerView() {
        this.mImageIDView = new ImageIDView(this.getContext());
        this.mImageIDView.setPictureRatio(this.viewModel.imageModel.compRatio);
        this.mImageIDView.setShowMaskArea(this.viewModel.imageModel.showMaskArea);
        this.mImageIDView.setErrorMessage(this.viewModel.imageModel.errorMessage);
        this.mImageIDView.setOnTouchListener(new DFIDImageView$2(this));
        return this.mImageIDView;
    }

    protected void setOnClickListener() {
        super.setOnClickListener();
        this.mImageIDView.setOnIDListener(this);
    }

    public void setIDGuideInfo(int n, int n2, int n3, int n4, int n5) {
        this.mImageIDView.setIDGuideInfo(n, n2, n3, n4, n5);
    }

    public void setIDGuideMosaicInfo(int n, String string) {
        this.mImageIDView.setIDGuideMosaicInfo(n, string);
    }

    public boolean hasManyFilter() {
        return this.mIDs != null && this.mIDs.length > 1;
    }

    private void hideAllLayout(boolean bl) {
        this.mRootFrameLayout.setVisibility(bl ? 8 : 0);
    }

    private void hideImageIDView(boolean bl) {
        this.mImageLayout.setVisibility(bl ? 8 : 0);
        this.mImageIDView.setVisibility(bl ? 8 : 0);
    }

    private void hideIDPaperInfoView(boolean bl) {
        if (this.mIDPaperInfoLayout != null) {
            this.mIDPaperInfoLayout.setVisibility(bl ? 8 : 0);
        }
    }

    private void updatePaperInfoView() {
        if (this.hasManyFilter()) {
            if (!this.hasValue()) {
                this.hideImageIDView(true);
                this.hideIDPaperInfoView(false);
                this.mRootFrameLayout.requestLayout();
            } else {
                this.hideImageIDView(false);
                this.hideIDPaperInfoView(true);
            }
        } else {
            this.hideIDPaperInfoView(true);
        }
    }

    public void setBitmapResult(Object object, String string, int n) {
        if (n == 999) {
            if (object != null) {
                this.mBitmap = DFIDImageView.parseValue(string);
                this.mJPGBase64EncodingData = string;
            }
        } else if (n == 997 && object != null) {
            this.mBitmap = (Bitmap)object;
        }
    }

    public void onClick(View view) {
        super.onClick(view);
        if (view == this.mResetButton) {
            this.updatePaperInfoView();
        } else if (this.viewModel.imageModel.idPaperInfo != null) {
            for (int j = 0; j < this.mIDs.length; ++j) {
                int n = (Integer)view.getTag();
                if (n != this.mIDs[j]) continue;
                this.callIDSelect(j);
                this.mImageIDView.runOnClick();
            }
        }
    }

    protected void callIDSelect(int n) {
        this.executeEvent(-1728053244, n);
    }

    public boolean getForceShoot() {
        return this.viewModel.imageModel.isForceShoot;
    }

    public int OnTakePreview(DFImageRecognitionData dFImageRecognitionData) {
        Object[] objectArray;
        int[] nArray = new int[14];
        nArray[0] = dFImageRecognitionData.mRectWidth;
        nArray[1] = dFImageRecognitionData.mRectHeight;
        nArray[2] = dFImageRecognitionData.mRectLeft;
        nArray[3] = dFImageRecognitionData.mRectTop;
        nArray[4] = dFImageRecognitionData.mBitmapWidth;
        nArray[5] = dFImageRecognitionData.mBitmapHeight;
        nArray[6] = dFImageRecognitionData.mRotation;
        nArray[7] = dFImageRecognitionData.mCameraType;
        nArray[8] = dFImageRecognitionData.mIsFocused;
        nArray[9] = dFImageRecognitionData.mIsOnceFocused;
        nArray[10] = dFImageRecognitionData.mIsForceShutter;
        nArray[11] = dFImageRecognitionData.mIsPreview;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("bitmap", dFImageRecognitionData.mBitmap);
        hashMap.put("data", dFImageRecognitionData.mData);
        hashMap.put("infos", nArray);
        hashMap.put("result", null);
        hashMap.put("id_guide", null);
        hashMap.put("id_mosaic", null);
        this.executeEvent(-1728053246, hashMap);
        Object v = hashMap.get("result");
        Object v2 = hashMap.get("id_guide");
        Object v3 = hashMap.get("id_mosaic");
        if (v2 != null) {
            objectArray = (Object[])v2;
            this.setIDGuideInfo((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4]);
        }
        if (v3 != null) {
            objectArray = (Object[])v3;
            this.setIDGuideMosaicInfo((Integer)objectArray[0], (String)objectArray[1]);
        }
        if (v != null && v instanceof Object[]) {
            objectArray = (Object[])v;
            int n = (Integer)objectArray[0];
            Object object = objectArray[2];
            this.setBitmapResult(object, (String)objectArray[1], n);
            return n;
        }
        return -1;
    }

    public void willShowDialog(Dialog dialog) {
        this.executeEvent(-1728053247, null);
    }

    public void willDismissDialog(Dialog dialog) {
        this.executeEvent(-1728053245, null);
    }

    public void OnTakePicture(Bitmap bitmap) {
        this.setValue(this.mJPGBase64EncodingData, this.mBitmap);
        this.mJPGBase64EncodingData = null;
        this.mBitmap = null;
        this.mImageIDView.dismiss();
        this.updatePaperInfoView();
    }

    protected void updateBitmap(Bitmap bitmap) {
        this.mImageIDView.setImageBitmap(bitmap);
    }

    public void closeDialog() {
        this.mImageIDView.dismiss();
    }
}

