/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.label;

import android.content.Context;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.label.DFLabelViewModel;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFContentLabelView
extends DFLayoutView {
    public static int HIGHLIGHT_TYPE_NONE = 0;
    public static int HIGHLIGHT_TYPE_BORDER = 1;
    public static int HIGHLIGHT_TYPE_QUESTIONTEXTCOLOR = 2;
    public static int HIGHLIGHT_TYPE_BACKGROUNDCOLOR = 3;
    public DFLabelViewModel labelViewModel;
    private TextView textView;

    public DFContentLabelView(Context context, DFLabelViewModel dFLabelViewModel) {
        super(context);
        this.labelViewModel = dFLabelViewModel;
        this.initView();
    }

    private void initView() {
        this.textView = new TextView(this.getContext());
        this.addView((View)this.textView);
        this.updateView();
    }

    private void updateQuestionNumber() {
        if (!this.labelViewModel.labelModel.isNotDFList && this.labelViewModel.labelModel.type == 1 && this.labelViewModel.labelModel.number > -1) {
            String string = this.labelViewModel.labelModel.text;
            string = this.labelViewModel.labelModel.number + 1 + ". " + string;
            this.textView.setText((CharSequence)string);
        }
    }

    public void updateView() {
        Object object;
        String string = "";
        int n = 0;
        int n2 = 0;
        if (this.labelViewModel.labelModel.dftype == 0) {
            if (this.labelViewModel.labelModel.isRequired) {
                string = this.labelViewModel.labelModel.requiredText;
                n2 = this.labelViewModel.labelModel.requiredTextColor;
            } else {
                string = this.labelViewModel.labelModel.optionalText;
                n2 = this.labelViewModel.labelModel.optionalTextColor;
            }
        }
        String string2 = (this.labelViewModel.labelModel.type == 1 ? string : "") + this.labelViewModel.labelModel.text;
        if (!this.labelViewModel.labelModel.isNotDFList && this.labelViewModel.labelModel.number > -1) {
            object = this.labelViewModel.labelModel.number + 1 + ". ";
            string2 = (String)object + string2;
            n = ((String)object).length();
        }
        if (this.labelViewModel.labelModel.dftype == 0 && this.labelViewModel.labelModel.type == 1) {
            object = new SpannableString((CharSequence)string2);
            object.setSpan((Object)new ForegroundColorSpan(n2), n, n + string.length(), 33);
            this.textView.setText((CharSequence)object);
        } else {
            this.textView.setText((CharSequence)string2);
        }
        if (this.labelViewModel.labelModel.type != 3 && string2.isEmpty()) {
            this.textView.setVisibility(8);
        } else {
            this.textView.setVisibility(0);
        }
        this.textView.setTextSize((float)this.labelViewModel.labelModel.textSize);
        int n3 = (Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.GUIDE_HIGHLIGHT_TYPE);
        if (this.hasHighlight && this.labelViewModel.labelModel.type == 1 && n3 != HIGHLIGHT_TYPE_NONE && this.labelViewModel.labelModel.useHighlightTextColor) {
            DFStyleManager dFStyleManager = DFStyleManager.getInstance();
            this.textView.setTextColor(DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.GUIDE_HIGHLIGHT_QUESTION_TEXT_COLOR)));
        } else {
            this.textView.setTextColor(this.labelViewModel.labelModel.textColor);
        }
        this.textView.setTypeface(this.textView.getTypeface(), this.labelViewModel.labelModel.style);
        this.textView.setGravity(this.labelViewModel.labelModel.gravity);
    }

    protected Object OnScript(int n, Object object) {
        String string = null;
        switch (n) {
            case -16777209: {
                string = this.labelViewModel.formid;
                break;
            }
            case -16777208: {
                String string2 = (String)object;
                this.labelViewModel.labelModel.setAttribute(string2);
                break;
            }
            case -16777207: {
                int n2 = (Integer)object;
                if (n2 == 1) {
                    this.updateView();
                    break;
                }
                if (n2 != 2) break;
                this.updateQuestionNumber();
                break;
            }
        }
        return string;
    }
}

