/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.list;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import java.util.ArrayList;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFButtonViewModel;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFListButtonView;
import oz.viewer.ui.df.mvvm.views.list.DFListInterface;
import oz.viewer.ui.df.mvvm.views.list.DFListView;
import oz.viewer.ui.df.mvvm.views.list.DFListView$ItemInfo;
import oz.viewer.ui.df.mvvm.views.list.DFListViewModel;

public class DFListAdapter
extends BaseAdapter
implements View.OnClickListener {
    public static final int ID_BUTTON1 = 123456;
    public static final int ITEM_TYPE_VISIBLE = 0;
    public static final int ITEM_TYPE_INVISIBLE = 1;
    public static final int ITEM_TYPE_COUNT = 2;
    public static final int ITEM_SIZE_TYPE_FIXED = 0;
    public static final int ITEM_SIZE_TYPE_DYNAMIC = 1;
    private boolean mIsAllowEmpty;
    private boolean mIsShowEmptyButton;
    private boolean mIsMultiSelectable;
    private boolean mIsVoice;
    private int mItemWidth;
    private ArrayList mItems;
    private DFListView$ItemInfo mEmptyItem;
    private String mPlaceHolder;
    private DFListView mParentView;
    private boolean mIsEndInput;
    private int mViewType;
    private int mItemViewType;
    private int mItemViewTextAlign;
    private boolean mShowItemTextNumber;
    private boolean mIsPopupMode;
    private boolean isRadioButtonShowEnableOnly;
    private boolean isAllowDuplicatedRadioItem;
    private int maxSelectableNumber;
    private Context mContext;
    public DFButtonViewModel mButtonViewModel;
    private DFListInterface mListInterface;

    public DFListAdapter(Context context, DFListViewModel dFListViewModel, DFButtonViewModel dFButtonViewModel, DFListInterface dFListInterface) {
        this.mContext = context;
        this.mListInterface = dFListInterface;
        this.setModel(dFListViewModel, dFButtonViewModel);
    }

    private void restoreSelection(DFListViewModel dFListViewModel) {
        if (this.mItems != null) {
            for (int j = 0; j < this.mItems.size(); ++j) {
                DFListView$ItemInfo dFListView$ItemInfo = (DFListView$ItemInfo)this.mItems.get(j);
                if (this.isAllowDuplicatedRadioItem && dFListView$ItemInfo.selected) {
                    for (int k = 0; k < dFListViewModel.listModel.items.size(); ++k) {
                        DFListView$ItemInfo dFListView$ItemInfo2 = (DFListView$ItemInfo)dFListViewModel.listModel.items.get(k);
                        if (!dFListView$ItemInfo.item.equals(dFListView$ItemInfo2.item)) continue;
                        dFListView$ItemInfo2.selected = true;
                    }
                }
                ((DFListView$ItemInfo)dFListViewModel.listModel.items.get((int)j)).selected = ((DFListView$ItemInfo)this.mItems.get((int)j)).selected;
            }
        }
    }

    public void setModel(DFListViewModel dFListViewModel, DFButtonViewModel dFButtonViewModel) {
        this.mButtonViewModel = dFButtonViewModel;
        this.mIsEndInput = dFListViewModel.listModel.isEndInput;
        this.restoreSelection(dFListViewModel);
        this.mItems = dFListViewModel.listModel.items;
        if (this.mItems == null) {
            this.mItems = new ArrayList();
        }
        this.mIsAllowEmpty = dFListViewModel.listModel.isAllowEmpty;
        this.mIsShowEmptyButton = dFListViewModel.listModel.isShowEmptyButton;
        this.mIsMultiSelectable = dFListViewModel.listModel.isMultiselectable;
        this.mPlaceHolder = dFListViewModel.listModel.placeHolder;
        this.maxSelectableNumber = dFListViewModel.listModel.maxSelectableNumber;
        if (this.mItems.isEmpty() || this.mIsShowEmptyButton) {
            this.initEmptyItem(dFListViewModel.listModel.emptyItem);
        }
        this.mViewType = dFListViewModel.listModel.viewType;
        this.mItemViewType = dFListViewModel.listModel.itemViewType;
        this.mItemViewTextAlign = dFListViewModel.listModel.itemViewTextAlign;
        this.mShowItemTextNumber = dFListViewModel.listModel.showItemTextNumber;
        this.mIsPopupMode = dFListViewModel.listModel.isPopupMode;
        this.isRadioButtonShowEnableOnly = dFListViewModel.listModel.isRadioButtonShowEnableOnly;
        this.isAllowDuplicatedRadioItem = dFListViewModel.listModel.isAllowDuplicatedRadioItem;
        this.maxSelectableNumber = dFListViewModel.listModel.maxSelectableNumber;
        this.updateRadioButtons();
    }

    public void setParentView(DFListView dFListView) {
        this.mParentView = dFListView;
    }

    private void initEmptyItem(String string) {
        this.mEmptyItem = new DFListView$ItemInfo();
        this.mEmptyItem.item = string;
        this.mEmptyItem.duplicated = false;
        this.mEmptyItem.displayNumber = 0;
    }

    public void setItemWidth(int n) {
        this.mItemWidth = n;
    }

    public int getItemWidth() {
        return this.mItemWidth;
    }

    public void setIsVoice(boolean bl) {
        this.mIsVoice = bl;
    }

    public void setSelectedItems(String string) {
        this.clearSelectAll();
        if (string != null && !string.isEmpty() && !string.equals("-1")) {
            String[] stringArray = string.split(",");
            for (int j = 0; j < stringArray.length; ++j) {
                try {
                    for (int k = 0; k < this.mItems.size(); ++k) {
                        if (!((DFListView$ItemInfo)this.mItems.get((int)k)).item.equals(stringArray[j])) continue;
                        this.touchItem((DFListView$ItemInfo)this.mItems.get(k), false);
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void addSelectionItem(int n) {
        if (n >= 0 && n < this.mItems.size()) {
            ((DFListView$ItemInfo)this.mItems.get((int)n)).selected = true;
        }
    }

    public void setSelectionItem(int n) {
        this.clearSelectAll();
        this.addSelectionItem(n);
    }

    public String getSelectedString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < this.mItems.size(); ++j) {
            DFListView$ItemInfo dFListView$ItemInfo = (DFListView$ItemInfo)this.mItems.get(j);
            if (!dFListView$ItemInfo.selected) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(j);
        }
        return stringBuffer.toString();
    }

    public boolean isMultiSelectable() {
        return this.mIsMultiSelectable;
    }

    public int getItemViewType(int n) {
        int n2 = 0;
        DFListView$ItemInfo dFListView$ItemInfo = (DFListView$ItemInfo)this.getItem(n);
        if (dFListView$ItemInfo != null && dFListView$ItemInfo.displayNumber < 0) {
            n2 = 1;
        }
        return n2;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getCount() {
        return this.mItems.size() + (this.mEmptyItem != null ? 1 : 0);
    }

    public Object getItem(int n) {
        if (this.mEmptyItem != null && n == 0) {
            if (this.getSelectedItemCountExceptTarget(null) == 0) {
                this.mEmptyItem.selected = true;
            }
            return this.mEmptyItem;
        }
        if (this.mEmptyItem != null) {
            return this.mItems.get(n - 1);
        }
        return this.mItems.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        int n2 = this.getItemViewType(n);
        if (view == null) {
            view = this.createItemView(n2);
        }
        view.setTag((Object)n);
        this.updateItemView(n, n2, view);
        return view;
    }

    public View createItemView(int n) {
        LinearLayout linearLayout = null;
        if (n == 0 || this.mViewType == DFListView.DF_LISTVIEW_TYPE_HORIZONTAL) {
            int n2 = DFUtils.toDP(this.mContext, 5.0f);
            int n3 = DFUtils.toDP(this.mContext, 20.0f);
            linearLayout = new LinearLayout(this.mContext);
            linearLayout.setOrientation(0);
            linearLayout.setPadding(0, n2, n3, n2);
            linearLayout.setGravity(16);
            DFListButtonView dFListButtonView = new DFListButtonView(this.mContext, this.mButtonViewModel);
            if (this.mViewType == DFListView.DF_LISTVIEW_TYPE_HORIZONTAL && this.mItemViewType == 1) {
                dFListButtonView.setEllipsize();
            }
            dFListButtonView.setId(123456);
            dFListButtonView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mItemWidth, -2));
            dFListButtonView.setOnClickListener(this);
            dFListButtonView.setTag(linearLayout);
            linearLayout.addView((View)dFListButtonView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            if (n == 1) {
                linearLayout.setVisibility(8);
            } else {
                linearLayout.setMinimumHeight(DFUtils.toDP(this.mContext, 70.0f));
            }
        } else if (n == 1) {
            linearLayout = new LinearLayout(this.mContext);
        }
        return linearLayout;
    }

    public void updateItemView(int n, int n2, View view) {
        DFListView$ItemInfo dFListView$ItemInfo = this.getItemFromView(view);
        if (dFListView$ItemInfo != null && n2 == 0) {
            DFListButtonView dFListButtonView = (DFListButtonView)view.findViewById(123456);
            if (this.mItemViewType == 0 && dFListButtonView.getLayoutParams().width != this.mItemWidth) {
                dFListButtonView.getLayoutParams().width = this.mItemWidth;
            }
            if (dFListView$ItemInfo == this.mEmptyItem) {
                dFListButtonView.setText(dFListView$ItemInfo.item);
            } else if (this.mShowItemTextNumber) {
                dFListButtonView.setText(String.format("%d) %s", dFListView$ItemInfo.displayNumber, dFListView$ItemInfo.item));
            } else {
                dFListButtonView.setText(String.format("%s", dFListView$ItemInfo.item));
            }
            dFListButtonView.setEnabled(dFListView$ItemInfo.isEnable(this.maxSelectableNumber == 0));
            dFListButtonView.setSelected(dFListView$ItemInfo.selected, this.mIsVoice);
        }
    }

    private int objToPostion(Object object) {
        int n = -1;
        if (object != null) {
            n = (Integer)object;
        }
        return n;
    }

    private DFListView$ItemInfo getItemFromObj(Object object) {
        DFListView$ItemInfo dFListView$ItemInfo = null;
        int n = this.objToPostion(object);
        if (n >= 0 && n < this.getCount()) {
            dFListView$ItemInfo = (DFListView$ItemInfo)this.getItem(n);
        }
        return dFListView$ItemInfo;
    }

    private DFListView$ItemInfo getItemFromView(View view) {
        if (view != null) {
            return this.getItemFromObj(view.getTag());
        }
        return null;
    }

    private void clearSelectAll() {
        for (int j = 0; j < this.mItems.size(); ++j) {
            if (!((DFListView$ItemInfo)this.mItems.get((int)j)).visible) continue;
            ((DFListView$ItemInfo)this.mItems.get((int)j)).selected = false;
        }
    }

    private int getSelectedItemCountExceptTarget(DFListView$ItemInfo dFListView$ItemInfo) {
        int n = 0;
        for (int j = 0; j < this.mItems.size(); ++j) {
            DFListView$ItemInfo dFListView$ItemInfo2 = (DFListView$ItemInfo)this.mItems.get(j);
            if (dFListView$ItemInfo2 == dFListView$ItemInfo || !dFListView$ItemInfo2.selected || dFListView$ItemInfo2.displayNumber <= 0) continue;
            ++n;
        }
        return n;
    }

    public void touchItem(DFListView$ItemInfo dFListView$ItemInfo, boolean bl) {
        if (dFListView$ItemInfo != null) {
            boolean bl2 = true;
            boolean bl3 = true;
            if (dFListView$ItemInfo == this.mEmptyItem) {
                this.clearSelectAll();
                dFListView$ItemInfo.selected = true;
            } else {
                int n = this.getSelectedItemCountExceptTarget(dFListView$ItemInfo);
                boolean bl4 = bl3 = !dFListView$ItemInfo.selected;
                if (!bl3 && !this.mIsAllowEmpty && n == 0) {
                    bl2 = false;
                } else if (this.mIsShowEmptyButton && n == 0) {
                    this.clearSelectAll();
                    bl2 = true;
                }
                if (!this.mIsMultiSelectable && n > 0) {
                    this.clearSelectAll();
                    bl3 = true;
                }
            }
            if (bl2) {
                dFListView$ItemInfo.selected = bl3;
                if (this.mEmptyItem != null && dFListView$ItemInfo != this.mEmptyItem) {
                    if (this.getSelectedItemCountExceptTarget(null) > 0) {
                        this.mEmptyItem.selected = false;
                    } else if (this.getSelectedItemCountExceptTarget(null) == 0) {
                        this.mEmptyItem.selected = true;
                    }
                }
                if (!this.mIsPopupMode) {
                    this.mParentView.script(12, null);
                    if (!this.mIsEndInput) {
                        this.mParentView.script(14, this.mParentView.script(-16777211, null).toString());
                    }
                }
                this.mListInterface.OnClick();
                this.mListInterface.OnValueChanged();
                this.notifyDataSetInvalidated();
                this.updateRadioButtons();
                if (this.mParentView.mListViewModel.listModel.viewType == DFListView.DF_LISTVIEW_TYPE_HORIZONTAL) {
                    this.mParentView.mHorizonListView.makeItems();
                }
            } else {
                if (!this.mIsPopupMode) {
                    this.mParentView.script(12, null);
                    if (!this.mIsEndInput) {
                        this.mParentView.script(14, this.mParentView.script(-16777211, null).toString());
                    }
                }
                this.mListInterface.OnClick();
            }
            if (bl && !this.mIsPopupMode && !this.mIsMultiSelectable) {
                this.mParentView.callEventInputComplete();
            }
        }
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case 123456: {
                DFListView$ItemInfo dFListView$ItemInfo = this.getItemFromView((View)view.getTag());
                this.touchItem(dFListView$ItemInfo, true);
                break;
            }
        }
    }

    public int getMaxSelectableNumber() {
        return this.maxSelectableNumber;
    }

    public void updateRadioButtons() {
        int n = this.maxSelectableNumber;
        if (n > 0) {
            DFListView$ItemInfo dFListView$ItemInfo;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.mItems.size(); ++n2) {
                dFListView$ItemInfo = (DFListView$ItemInfo)this.mItems.get(n2);
                if (!dFListView$ItemInfo.selected) continue;
                ++n3;
            }
            if (n <= n3) {
                DFListView$ItemInfo dFListView$ItemInfo2;
                int n4;
                n2 = 0;
                for (n4 = 0; n4 < this.mItems.size(); ++n4) {
                    dFListView$ItemInfo2 = (DFListView$ItemInfo)this.mItems.get(n4);
                    dFListView$ItemInfo2.mEnableFromMaxCount = false;
                }
                for (n4 = 0; n4 < this.mItems.size(); ++n4) {
                    dFListView$ItemInfo2 = (DFListView$ItemInfo)this.mItems.get(n4);
                    if (dFListView$ItemInfo2.selected && dFListView$ItemInfo2.isEnable(true)) {
                        dFListView$ItemInfo2.mEnableFromMaxCount = true;
                        ++n2;
                    }
                    if (n <= n2) break;
                }
                this.notifyDataSetChanged();
            } else {
                for (n2 = 0; n2 < this.mItems.size(); ++n2) {
                    dFListView$ItemInfo = (DFListView$ItemInfo)this.mItems.get(n2);
                    dFListView$ItemInfo.mEnableFromMaxCount = dFListView$ItemInfo.isEnable(true);
                }
            }
        }
    }
}

