/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.list;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import oz.viewer.ui.df.DFManager;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.DFViewCreatorImpl;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFButtonViewModel;
import oz.viewer.ui.df.mvvm.views.list.DFHorizontalListView;
import oz.viewer.ui.df.mvvm.views.list.DFListAdapter;
import oz.viewer.ui.df.mvvm.views.list.DFListInterface;
import oz.viewer.ui.df.mvvm.views.list.DFListView$1;
import oz.viewer.ui.df.mvvm.views.list.DFListView$DFItemListView;
import oz.viewer.ui.df.mvvm.views.list.DFListView$ItemInfo;
import oz.viewer.ui.df.mvvm.views.list.DFListViewModel;
import oz.viewer.ui.df.mvvm.views.popup.DFListPopupButton;
import oz.viewer.ui.df.mvvm.views.popup.DFListPopupView;
import oz.viewer.ui.df.view.DFInflaterView;
import oz.viewer.ui.df.view.DFLayoutView;
import oz.viewer.ui.df.view.DFLayoutView$OnEventListener;

public class DFListView
extends DFLayoutView
implements View.OnClickListener {
    public DFListViewModel mListViewModel;
    public DFButtonViewModel mButtonViewModel;
    private DFListAdapter mAdapter;
    private DFListView _This = this;
    private DFListPopupView popupView;
    private DFListPopupButton mPopupButton;
    private DFManager manager;
    public ListView mVerticalListView;
    public DFHorizontalListView mHorizonListView;
    private DFListInterface mListInterface;
    public static int DF_LISTVIEW_TYPE_VERTICAL = 0;
    public static int DF_LISTVIEW_TYPE_HORIZONTAL = 1;

    public DFListView(Context context, DFListViewModel dFListViewModel, DFListInterface dFListInterface) {
        super(context);
        this.mListViewModel = dFListViewModel;
        this.mButtonViewModel = new DFButtonViewModel(dFListViewModel.buttonModel);
        this.mListInterface = dFListInterface;
        this.mAdapter = new DFListAdapter(this.getContext(), this.mListViewModel, this.mButtonViewModel, this.mListInterface);
        this.initView(context);
    }

    public void initAttribute() {
        this.mAdapter.setModel(this.mListViewModel, this.mButtonViewModel);
    }

    public void setManager(DFManager dFManager) {
        this.manager = dFManager;
    }

    public DFManager getManager() {
        return this.manager;
    }

    public void initView(Context context) {
        this.setPaddingContents();
        if (this.mListViewModel.listModel.isPopupMode) {
            this.addPopupButton();
        } else {
            this.addListView();
        }
    }

    private void setPopupButtonText(String string) {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        int n = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_POPUPBUTTON_FONT_COLOR));
        if (string.isEmpty()) {
            this.mPopupButton.setText(this.mListViewModel.listModel.placeHolder);
            n = DFUtils.getPlaceHolderColor(n);
        } else {
            this.mPopupButton.setText(string);
        }
        this.mPopupButton.setTextColor(n);
    }

    private void addPopupButton() {
        this.mPopupButton = new DFListPopupButton(this.getContext());
        this.mPopupButton.setSingleLine();
        this.mPopupButton.setMinimumHeight(100);
        this.mPopupButton.setEllipsize(TextUtils.TruncateAt.END);
        this.setPopupButtonText(this.getSelectedString());
        this.mPopupButton.setOnClickListener(new DFListView$1(this));
        this.addView((View)this.mPopupButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
    }

    private void addListView() {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        linearLayout.addView((View)this.makeListView());
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
    }

    private ViewGroup makeListView() {
        this.mAdapter.setParentView(this);
        if (this.mListViewModel.listModel.viewType == DF_LISTVIEW_TYPE_VERTICAL) {
            this.mVerticalListView = new DFListView$DFItemListView(this, this.getContext());
            this.mVerticalListView.setAdapter((ListAdapter)this.mAdapter);
            this.mVerticalListView.setDividerHeight(0);
            this.mVerticalListView.setPadding(0, 0, 0, DFUtils.toDP(this.getContext(), DFViewCreatorImpl.COMPONENT_BOTTOM_MARGIN));
            this.mVerticalListView.setClipToPadding(false);
            return this.mVerticalListView;
        }
        if (this.mListViewModel.listModel.viewType == DF_LISTVIEW_TYPE_HORIZONTAL) {
            this.mHorizonListView = new DFHorizontalListView(this.getContext());
            this.mHorizonListView.setAdapter(this.mAdapter);
            return this.mHorizonListView;
        }
        return null;
    }

    public View getListView() {
        if (this.mListViewModel.listModel.viewType == DF_LISTVIEW_TYPE_VERTICAL) {
            if (this.mAdapter != null) {
                return this.mVerticalListView;
            }
        } else if (this.mListViewModel.listModel.viewType == DF_LISTVIEW_TYPE_HORIZONTAL) {
            return this.mHorizonListView;
        }
        return null;
    }

    public String getSelectedValue() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < this.mListViewModel.listModel.items.size(); ++j) {
            DFListView$ItemInfo dFListView$ItemInfo = (DFListView$ItemInfo)this.mListViewModel.listModel.items.get(j);
            if (!dFListView$ItemInfo.selected) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            boolean bl = false;
            int n = 0;
            if (this.mListViewModel.listModel.isAllowDuplicatedRadioItem && dFListView$ItemInfo.duplicated) {
                for (n = 0; n < j; ++n) {
                    DFListView$ItemInfo dFListView$ItemInfo2 = (DFListView$ItemInfo)this.mListViewModel.listModel.items.get(n);
                    if (!dFListView$ItemInfo.item.equals(dFListView$ItemInfo2.item)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                stringBuffer.append(n);
                continue;
            }
            stringBuffer.append(j);
        }
        return stringBuffer.toString().isEmpty() ? "-1" : stringBuffer.toString();
    }

    public String getSelectedString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < this.mListViewModel.listModel.items.size(); ++j) {
            DFListView$ItemInfo dFListView$ItemInfo = (DFListView$ItemInfo)this.mListViewModel.listModel.items.get(j);
            if (!dFListView$ItemInfo.selected) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(dFListView$ItemInfo.item);
        }
        return stringBuffer.toString().isEmpty() ? "" : stringBuffer.toString();
    }

    public void onClick(View view) {
    }

    public int getListViewHeightBasedOnChildren() {
        int n = 0;
        int n2 = View.MeasureSpec.makeMeasureSpec((int)this.getListView().getWidth(), (int)Integer.MIN_VALUE);
        View view = null;
        int n3 = 0;
        for (int j = 0; j < this.mAdapter.getCount(); ++j) {
            view = this.mAdapter.getView(j, view, (ViewGroup)this.getListView());
            View view2 = view.findViewById(123456);
            boolean bl = DFUtils.isMobile(this.getContext());
            Point point = DFUtils.getScreenSize((Activity)this.getContext());
            int n4 = bl ? point.x : (int)((float)point.x * 0.9f);
            int n5 = n4 - DFUtils.toDP(this.getContext(), DFInflaterView.CONTENTS_TAB_SPACE) * 2 - DFUtils.toDP(this.getContext(), 30.0f);
            view2.getLayoutParams().width = -2;
            view.measure(0, 0);
            int n6 = view2.getMeasuredWidth();
            view2.getLayoutParams().width = n5;
            if (n6 > n5) {
                n6 = n5;
                view.measure(0, 0);
            }
            if (n3 < n6) {
                n3 = n6;
            }
            n += view.getMeasuredHeight();
        }
        n += DFUtils.toDP(this.getContext(), 30.0f);
        this.mAdapter.setItemWidth(n3);
        if (this.mListViewModel.listModel.viewType == DF_LISTVIEW_TYPE_VERTICAL) {
            return n + this.mVerticalListView.getDividerHeight() * (this.mAdapter.getCount() - 1);
        }
        return this.mHorizonListView.getListViewHeight();
    }

    public int updateSizeChanged(int n, int n2) {
        int n3 = n - DFUtils.toDP(this.getContext(), 50.0f);
        this.mAdapter.setItemWidth(n3);
        int n4 = this.getListViewHeightBasedOnChildren();
        if (this.mListViewModel.listModel.viewType == DF_LISTVIEW_TYPE_VERTICAL) {
            this.mVerticalListView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n, n4));
        } else {
            this.mHorizonListView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.mHorizonListView.updateItemView();
        }
        int n5 = this.mAdapter.getItemWidth();
        if (n5 == 0 || n5 > n3) {
            this.mAdapter.setItemWidth(n3);
        }
        this.mAdapter.notifyDataSetInvalidated();
        return n4;
    }

    public void callEventInputComplete() {
        this.executeEvent(2, null);
    }

    public int[] layout_measure(int n, int n2) {
        if (this.getVisibility() != 8) {
            this.mListViewModel.listModel.itemWidth = n;
            if (!this.mListViewModel.listModel.isPopupMode) {
                int n3;
                if (this.mListViewModel.listModel.viewType == DF_LISTVIEW_TYPE_VERTICAL) {
                    this.mVerticalListView.measure(0, 0);
                    n3 = this.updateSizeChanged(this.mListViewModel.listModel.itemWidth, n2);
                } else {
                    this.mHorizonListView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                    if (this.mListViewModel.listModel.itemViewType == 0) {
                        this.getListViewHeightBasedOnChildren();
                    }
                    this.mHorizonListView.makeItems();
                    this.mHorizonListView.measure(n, 0);
                    n3 = this.mHorizonListView.getListViewHeight();
                }
                return new int[]{n, n3};
            }
            return new int[]{n, DFUtils.toDP(this.getContext(), 80.0f)};
        }
        return new int[]{0, 0};
    }

    protected Object OnScript(int n, Object object) {
        Object object2 = null;
        switch (n) {
            case -16777211: {
                object2 = this.getSelectedValue();
                break;
            }
            case -16777210: {
                if (this.mListViewModel.listModel.viewType != DF_LISTVIEW_TYPE_VERTICAL) break;
                if (object instanceof Integer) {
                    this.mAdapter.setSelectionItem((Integer)object);
                } else {
                    this.mAdapter.setSelectedItems(object.toString());
                }
                this.mAdapter.notifyDataSetChanged();
                break;
            }
            case -16777209: {
                object2 = this.mListViewModel.formid;
                break;
            }
            case -16777206: {
                object2 = this.mListViewModel.listModel.isEndInput;
                break;
            }
            case -16777208: {
                String string = (String)object;
                this.mListViewModel.listModel.setAttribute(string);
                break;
            }
            case -16777207: {
                int n2 = (Integer)object;
                if (n2 != 1) break;
                this.updateView();
                break;
            }
            case 12: {
                this.executeEvent(12, null);
                break;
            }
            case 13: {
                this.executeEvent(13, null);
                break;
            }
            case 14: {
                this.executeEvent(14, (String)object);
                break;
            }
            case 31: {
                Boolean bl = (Boolean)object;
                if (bl.booleanValue()) {
                    this.setPopupButtonText(this.getSelectedString());
                    if (!this.mListViewModel.listModel.isEndInput) {
                        this.executeEvent(14, this.OnScript(-16777211, null));
                    }
                }
                this.executeEvent(n, null);
                break;
            }
        }
        return object2;
    }

    public DFListViewModel getViewModel() {
        return this.mListViewModel;
    }

    public void updateView() {
        if (this.getListView() != null) {
            this.initAttribute();
            this.executeEvent(15, null);
        }
    }

    static /* synthetic */ DFListPopupView access$000(DFListView dFListView) {
        return dFListView.popupView;
    }

    static /* synthetic */ DFListPopupView access$002(DFListView dFListView, DFListPopupView dFListPopupView) {
        dFListView.popupView = dFListPopupView;
        return dFListView.popupView;
    }

    static /* synthetic */ void access$100(DFListView dFListView, int n, Object object) {
        dFListView.executeEvent(n, object);
    }

    static /* synthetic */ DFListView access$200(DFListView dFListView) {
        return dFListView._This;
    }

    static /* synthetic */ DFLayoutView$OnEventListener access$300(DFListView dFListView) {
        return dFListView.mEventListener;
    }

    static /* synthetic */ DFManager access$400(DFListView dFListView) {
        return dFListView.manager;
    }

    static /* synthetic */ ViewGroup access$500(DFListView dFListView) {
        return dFListView.makeListView();
    }
}

