/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.numeric;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.DecimalFormat;
import java.util.Arrays;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.clearbutton.DFClearButton$Builder;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFButtonViewModel;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFUpDownButtonView;
import oz.viewer.ui.df.mvvm.views.numeric.DFNumericConstants;
import oz.viewer.ui.df.mvvm.views.numeric.DFNumericView$1;
import oz.viewer.ui.df.mvvm.views.numeric.DFNumericView$2;
import oz.viewer.ui.df.mvvm.views.numeric.DFNumericViewModel;
import oz.viewer.ui.df.mvvm.views.text.DFSingleLineDrawable;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFNumericView
extends DFLayoutView
implements TextWatcher,
View.OnClickListener,
View.OnFocusChangeListener,
TextView.OnEditorActionListener {
    public DFNumericViewModel viewModel;
    private DFUpDownButtonView minusButton;
    private DFUpDownButtonView plusButton;
    private Button resetButton;
    private EditText mEditText;
    private String mText;
    private DecimalFormat _numberFormat;
    private View.OnClickListener mOnClickListener;
    private TextView.OnEditorActionListener mOnEditorActionListener;
    private View.OnFocusChangeListener mOnFocusChangeListener;
    private boolean isChangeAttribute = false;
    private ViewTreeObserver.OnGlobalLayoutListener gListener = new DFNumericView$2(this);

    public DFNumericView(Context context, DFNumericViewModel dFNumericViewModel, TextWatcher textWatcher, View.OnClickListener onClickListener, TextView.OnEditorActionListener onEditorActionListener, View.OnFocusChangeListener onFocusChangeListener) {
        super(context);
        this.viewModel = dFNumericViewModel;
        this.mOnClickListener = onClickListener;
        this.mOnEditorActionListener = onEditorActionListener;
        this.mOnFocusChangeListener = onFocusChangeListener;
        this.initView();
    }

    private void initView() {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setOrientation(0);
        linearLayout2.setGravity(16);
        linearLayout2.setPadding(DFUtils.toDP(this.getContext(), 20.0f), DFUtils.toDP(this.getContext(), 10.0f), DFUtils.toDP(this.getContext(), 10.0f), DFUtils.toDP(this.getContext(), 10.0f));
        DFButtonViewModel dFButtonViewModel = new DFButtonViewModel(this.viewModel.buttonModel);
        dFButtonViewModel.model.resDrawable = DFUtils.getImageDrawable(this.getContext(), 21);
        int n = DFUtils.toDP(this.getContext(), 18.0f);
        this.minusButton = new DFUpDownButtonView(this.getContext(), dFButtonViewModel);
        this.minusButton.setImageViewSize(n, -2);
        this.minusButton.setInnerLayoutGravity(17);
        this.minusButton.setOnClickListener(this);
        dFButtonViewModel.model.resDrawable = DFUtils.getImageDrawable(this.getContext(), 22);
        this.plusButton = new DFUpDownButtonView(this.getContext(), dFButtonViewModel);
        this.plusButton.setImageViewSize(n);
        this.plusButton.setInnerLayoutGravity(17);
        this.plusButton.setOnClickListener(this);
        this.mEditText = new EditText(this.getContext());
        this.mEditText.addTextChangedListener((TextWatcher)this);
        this.mEditText.setOnTouchListener((View.OnTouchListener)new DFNumericView$1(this));
        this.mEditText.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mEditText.getViewTreeObserver().addOnGlobalLayoutListener(this.gListener);
        this.mEditText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.resetButton = new DFClearButton$Builder((ViewGroup)linearLayout2).setOnClickListener(this).setSizeDP(22).setLayoutMarginLeftDP(16).create();
        int n2 = DFUtils.toDP(this.getContext(), 50.0f);
        int n3 = DFUtils.toDP(this.getContext(), 10.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.setMargins(n3, 0, n3, 0);
        linearLayout2.addView((View)this.minusButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n2, n2));
        linearLayout2.addView((View)this.mEditText, (ViewGroup.LayoutParams)layoutParams);
        linearLayout2.addView((View)this.plusButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n2, n2));
        linearLayout2.addView((View)this.resetButton);
        linearLayout.addView((View)linearLayout2);
        this.addView((View)linearLayout);
        this.updateView();
    }

    private void adjustText() {
        String string = this.mEditText.getText().toString();
        if (!this.viewModel.numericModel.isAllowEmpty && string.isEmpty() || string.equals(".") || string.equals("-")) {
            string = this.viewModel.value;
        }
        if (string.isEmpty()) {
            this.viewModel.value = string;
            return;
        }
        if (Double.parseDouble(string) > this.viewModel.numericModel.maxValue) {
            this.viewModel.value = this.viewModel.numericModel.maxValue % 1.0 != 0.0 ? Double.toString(this.viewModel.numericModel.maxValue) : Integer.toString((int)this.viewModel.numericModel.maxValue);
        } else if (Double.parseDouble(string) < this.viewModel.numericModel.minValue) {
            this.viewModel.value = this.viewModel.minValueString;
        } else {
            double d2 = Double.parseDouble(string);
            double d3 = d2 % 1.0;
            if (d3 != 0.0) {
                String string2 = string;
                string2 = string2.replaceAll("-", "");
                if ((string2 = string2.replaceAll("^0{2,}", "")).startsWith(".")) {
                    string2 = "0".concat(string2);
                }
                if (string.startsWith("-")) {
                    string2 = "-".concat(string2);
                }
                while (string2.endsWith("0")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                this.viewModel.value = string2;
            } else {
                this.viewModel.value = Integer.toString((int)d2);
            }
        }
    }

    private void setNumberFormat() {
        String[] stringArray;
        int[] nArray = new int[4];
        String[] stringArray2 = DFNumericConstants.split(this.mText, ".");
        if (stringArray2.length > 1) {
            nArray[0] = stringArray2[1].length();
        }
        if ((stringArray = DFNumericConstants.split(Double.toString(this.viewModel.numericModel.increment), ".")).length > 1) {
            nArray[1] = stringArray[1].length();
        }
        String[] stringArray3 = DFNumericConstants.split(Double.toString(this.viewModel.numericModel.maxValue), ".");
        if (stringArray.length > 1) {
            nArray[2] = stringArray3[1].length();
        }
        String[] stringArray4 = DFNumericConstants.split(Double.toString(this.viewModel.numericModel.minValue), ".");
        if (stringArray.length > 1) {
            nArray[3] = stringArray4[1].length();
        }
        Arrays.sort(nArray);
        int n = nArray[3];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0.");
        for (int j = 0; j < n; ++j) {
            stringBuffer.append("#");
        }
        this._numberFormat = new DecimalFormat(stringBuffer.toString());
    }

    private void plusMinusAction(boolean bl) {
        double d2;
        this.adjustText();
        this.mText = this.viewModel.getValidValue();
        if (this.viewModel.numericModel.isAllowEmpty && "".equals(this.mText)) {
            this.mText = "0";
        }
        if (this.mText.isEmpty() && this.viewModel.value != null) {
            this.mText = this.viewModel.getValidValue();
        }
        if (this.viewModel.numericModel.maxValue < (d2 = Double.parseDouble(this.mText))) {
            d2 = this.viewModel.numericModel.maxValue;
        } else if (this.viewModel.numericModel.minValue > d2) {
            d2 = this.viewModel.numericModel.minValue;
        }
        double d3 = this.checkMaxMinValue(d2 + (bl ? this.viewModel.numericModel.increment : -this.viewModel.numericModel.increment));
        this.mText = this._numberFormat.format(d3);
        this.setEditText(this.mText);
        this.mEditText.setSelection(this.mEditText.getText().length());
    }

    private double checkMaxMinValue(double d2) {
        if (this.viewModel.numericModel.maxValue <= d2) {
            if (this.plusButton != null) {
                this.plusButton.setEnabled(false);
            }
            d2 = this.viewModel.numericModel.maxValue;
        } else if (this.plusButton != null) {
            this.plusButton.setEnabled(true);
        }
        if (this.viewModel.numericModel.minValue >= d2) {
            if (this.minusButton != null) {
                this.minusButton.setEnabled(false);
            }
            d2 = this.viewModel.numericModel.minValue;
        } else if (this.minusButton != null) {
            this.minusButton.setEnabled(true);
        }
        return d2;
    }

    private void resetBtnClicked(View view) {
        this.setEditText("");
        this.minusButton.setEnabled(true);
        view.setClickable(false);
    }

    private void setEditText(String string) {
        this.mEditText.setText((CharSequence)string);
    }

    public void onClick(View view) {
        if (view == this.minusButton) {
            this.executeEvent(12, null);
            this.plusMinusAction(false);
        } else if (view == this.plusButton) {
            this.executeEvent(12, null);
            this.plusMinusAction(true);
        } else if (view == this.resetButton) {
            this.executeEvent(12, null);
            this.resetBtnClicked(view);
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        if (this.isChangeAttribute) {
            return;
        }
        if (this.viewModel.numericModel.isAllowEmpty) {
            if (n == 0 && n2 == charSequence.length() && n3 == 0) {
                this.resetButton.setClickable(false);
            } else if (!this.resetButton.isClickable()) {
                this.resetButton.setClickable(true);
            }
        }
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        if (this.isChangeAttribute) {
            return;
        }
        String string = charSequence.toString();
        if (!this.viewModel.numericModel.isEndInput && !this.viewModel.value.equals(string)) {
            this.executeEvent(14, string);
        }
    }

    public void performFocusChange(View view, boolean bl) {
        this.onFocusChange(view, bl);
    }

    public void afterTextChanged(Editable editable) {
    }

    public void onFocusChange(View view, boolean bl) {
        if (!bl) {
            double d2;
            this.adjustText();
            this.mText = this.viewModel.getValidValue();
            if (this.viewModel.numericModel.isAllowEmpty && "".equals(this.mText)) {
                this.mText = "0";
            }
            if (this.mText.isEmpty() && this.viewModel.value != null) {
                this.mText = this.viewModel.getValidValue();
            }
            if (this.viewModel.numericModel.maxValue < (d2 = Double.parseDouble(this.mText))) {
                d2 = this.viewModel.numericModel.maxValue;
            } else if (this.viewModel.numericModel.minValue > d2) {
                d2 = this.viewModel.numericModel.minValue;
            }
            this.mText = this._numberFormat.format(d2);
            this.setEditText(this.mText);
        }
        this.mOnFocusChangeListener.onFocusChange(view, bl);
        if (bl) {
            this.executeEvent(12, null);
        }
    }

    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
        if (n == 6) {
            InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(textView.getWindowToken(), 0);
        }
        this.mOnEditorActionListener.onEditorAction(textView, n, keyEvent);
        return false;
    }

    protected Object OnScript(int n, Object object) {
        Object object2 = null;
        switch (n) {
            case -16777208: {
                String string = (String)object;
                this.viewModel.numericModel.setAttribute(string);
                break;
            }
            case -16777207: {
                int n2 = (Integer)object;
                if (n2 != 1) break;
                this.updateView();
                break;
            }
            case -16777211: {
                this.adjustText();
                object2 = this.viewModel.value;
                break;
            }
            case -16777209: {
                object2 = this.viewModel.formid;
                break;
            }
            case -16777206: {
                object2 = this.viewModel.numericModel.isEndInput;
                break;
            }
            case -16777212: {
                this.mEditText.clearFocus();
                break;
            }
            case -16777210: {
                this.viewModel.value = (String)object;
                this.updateView();
            }
        }
        return object2;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    private void changeBorderStyle(boolean bl) {
        int n;
        int n2;
        if (bl) {
            n2 = this.viewModel.numericModel.focusBorderColor;
            n = DFUtils.toDP(this.getContext(), this.viewModel.numericModel.focusBorderThick > 0 ? (float)this.viewModel.numericModel.focusBorderThick : 1.0f);
        } else {
            n2 = this.viewModel.numericModel.buttonColor;
            n = DFUtils.toDP(this.getContext(), 1.0f);
        }
        this.mEditText.setBackground((Drawable)new DFSingleLineDrawable(0, n2, n, true));
    }

    public void updateView() {
        if (!this.isChangeAttribute) {
            this.isChangeAttribute = true;
            this.mText = this.viewModel.value;
            if (this.viewModel.numericModel.isAllowEmpty) {
                this.mEditText.setText((CharSequence)this.mText);
            } else if ("".equals(this.mText)) {
                this.mEditText.setText((CharSequence)"0");
            } else {
                this.mEditText.setText((CharSequence)this.mText);
            }
            int n = this.viewModel.numericModel.fontColor;
            this.mEditText.setTextSize((float)this.viewModel.numericModel.fontSize);
            this.mEditText.setGravity(17);
            this.mEditText.setFocusableInTouchMode(true);
            this.mEditText.setTextColor(n);
            this.mEditText.setFocusable(false);
            this.mEditText.setInputType(12290);
            this.changeBorderStyle(this.hasHighlight);
            this.mEditText.setHint((CharSequence)this.viewModel.numericModel.placeholder);
            this.mEditText.setHintTextColor(DFUtils.getPlaceHolderColor(n));
            this.mEditText.setMinWidth(DFUtils.toDP(this.getContext(), 150.0f));
            this.setNumberFormat();
            if (this.viewModel.numericModel.isAllowEmpty) {
                this.resetButton.setVisibility(0);
            } else {
                this.resetButton.setVisibility(4);
            }
            this.isChangeAttribute = false;
        }
    }

    static /* synthetic */ EditText access$000(DFNumericView dFNumericView) {
        return dFNumericView.mEditText;
    }
}

