/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.numeric;

import android.content.Context;
import org.json.JSONObject;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.model.dfbutton.DFButtonModel;
import oz.viewer.ui.df.mvvm.model.numeric.DFNumericModel;

public class DFNumericViewModel {
    public DFNumericModel numericModel;
    public DFButtonModel buttonModel;
    public String formid;
    public String value;
    public String minValueString;
    public Context context;

    public DFNumericViewModel(Context context) {
        this.context = context;
        this.numericModel = new DFNumericModel();
        this.buttonModel = new DFButtonModel();
    }

    public DFNumericViewModel(DFNumericModel dFNumericModel, DFButtonModel dFButtonModel) {
        this.numericModel = dFNumericModel;
        this.buttonModel = dFButtonModel;
        this.updateMinValueString();
    }

    private void updateMinValueString() {
        this.minValueString = this.numericModel.minValue > (double)((int)this.numericModel.minValue) ? Integer.toString((int)this.numericModel.minValue) : Double.toString(this.numericModel.minValue);
    }

    public String getValidValue() {
        String string;
        if (!"".equals(this.value) && !this.value.matches(string = "^[-]?[0-9.]+$")) {
            this.value = this.minValueString;
        }
        return this.value;
    }

    public void setAttribute(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.setAttribute(jSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAttribute(JSONObject jSONObject) {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        this.formid = jSONObject.optString("formid");
        this.value = jSONObject.optString("number_text");
        this.numericModel.setAttribute(jSONObject);
        this.numericModel.fontSize = (Integer)DFStyleManager.getInstance().getStyle(DFUtils.getFontSizeKey(this.context, DFStyleManager.IC_NUMERICUPDOWN_FONT_SIZE_NORMAL, DFStyleManager.IC_NUMERICUPDOWN_FONT_SIZE_SMALL));
        this.buttonModel.selectBorderColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_NUMERICUPDOWN_BUTTON_COLOR));
        this.buttonModel.unselectBorderColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_NUMERICUPDOWN_BUTTON_COLOR));
        this.buttonModel.radius = 6.0f;
        this.buttonModel.selectBackgroundColor = DFUtils.getARGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_NUMERICUPDOWN_BUTTON_BACKGROUND_COLOR));
        this.buttonModel.unselectBackgroundColor = DFUtils.getARGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_NUMERICUPDOWN_BUTTON_BACKGROUND_COLOR));
        this.buttonModel.itembuttonFontColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_NUMERICUPDOWN_FONT_COLOR));
        this.buttonModel.selectBorderThick = 2.0f;
        this.buttonModel.unselectBorderThick = 1.0f;
        this.updateMinValueString();
    }
}

