/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.popup;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.df.DFManager;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.model.confirmbutton.DFConfirmButtonModel;
import oz.viewer.ui.df.mvvm.model.label.DFLabelModel;
import oz.viewer.ui.df.mvvm.views.confirmbutton.DFConfirmButtonView;
import oz.viewer.ui.df.mvvm.views.confirmbutton.DFConfirmButtonViewModel;
import oz.viewer.ui.df.mvvm.views.label.DFContentLabelView;
import oz.viewer.ui.df.mvvm.views.label.DFLabelViewModel;
import oz.viewer.ui.df.mvvm.views.popup.DFBasePopupView$1;
import oz.viewer.ui.df.mvvm.views.popup.DFBasePopupView$2;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFBasePopupView
extends DFLayoutView {
    public DFLayoutView parentView;
    public DFManager manager = null;
    protected LinearLayout mRoot = null;
    protected LinearLayout mContents = null;
    protected LinearLayout mBottom = null;
    protected DFConfirmButtonView btnCancel;
    protected DFConfirmButtonView btnOK;
    protected int questionnumber;
    protected String question;
    protected String description;
    protected int contextSize;
    protected int displayAreaType;

    public DFBasePopupView(Context context) {
        super(context);
        this.setClickable(true);
        this.mRoot = new LinearLayout(this.getContext());
        this.mRoot.setOrientation(1);
        int n = DFUtils.toDP(this.getContext(), 40.0f);
        int n2 = DFUtils.toDP(this.getContext(), 65.0f);
        this.mRoot.setPadding(n, n2, n, n2);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.bottomMargin = DFUtils.toDP(this.getContext(), 20.0f);
        this.addView((View)this.mRoot, (ViewGroup.LayoutParams)layoutParams);
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        int n3 = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_BACKGROUND_COLOR));
        this.setBackgroundColor(n3);
    }

    public void updateSizeChanged(int n, int n2) {
        if (this.mRoot != null) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mRoot.getLayoutParams();
            layoutParams.gravity = 17;
            layoutParams.width = n;
            if (n2 == 0) {
                layoutParams.height = -2;
            } else {
                layoutParams.height = -1;
                layoutParams.topMargin = 0;
            }
            this.mRoot.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    protected void makePopupLayout() {
        if (this.mContents != null) {
            this.mContents.removeAllViews();
            this.mContents = null;
        }
        this.mContents = new LinearLayout(this.getContext());
        this.mContents.setOrientation(1);
        ScrollView scrollView = new ScrollView(this.getContext());
        scrollView.addView((View)this.mContents, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        scrollView.setFillViewport(true);
        this.mRoot.addView((View)scrollView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        this.mContents.addView((View)this.makeQuestion());
        this.mContents.addView((View)this.makeDescription());
        this.makeButtonLayout();
    }

    protected void resizePopupLayout() {
        if (this.manager != null) {
            int n = this.manager.getConnector().getContentSize();
            if (n == 0 || this.displayAreaType == 0) {
                n = -1;
            }
            n = DFUtils.calcContentSize(this.getContext(), this.manager.getConnector().getDisplayArea(), n, this.manager.getConnector().getContentSize());
            this.updateSizeChanged(n, this.manager.getConnector().getContentVerticalAlign());
        }
    }

    protected DFContentLabelView makeQuestion() {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        DFLabelModel dFLabelModel = new DFLabelModel();
        dFLabelModel.setType(1, false, false);
        dFLabelModel.textSize = (Integer)DFStyleManager.getInstance().getStyle(DFUtils.getFontSizeKey(this.getContext(), DFStyleManager.CONTENTS_QUESTION_FONT_SIZE_NORMAL, DFStyleManager.CONTENTS_QUESTION_FONT_SIZE_SMALL));
        dFLabelModel.gravity = DFUtils.getTextGravity((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_QUESTION_TEXT_ALIGNMENT));
        dFLabelModel.textColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_QUESTION_FONT_COLOR));
        dFLabelModel.style = DFUtils.getTextTypeFace((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_QUESTION_FONT_STYLE));
        dFLabelModel.number = this.questionnumber;
        dFLabelModel.text = this.question;
        dFLabelModel.requiredTextColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_REQUIRED_TEXT_COLOR));
        dFLabelModel.optionalTextColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_OPTIONAL_TEXT_COLOR));
        DFLabelViewModel dFLabelViewModel = new DFLabelViewModel(dFLabelModel);
        DFContentLabelView dFContentLabelView = new DFContentLabelView(this.getContext(), dFLabelViewModel);
        dFContentLabelView.updateView();
        return dFContentLabelView;
    }

    protected DFContentLabelView makeDescription() {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        DFLabelModel dFLabelModel = new DFLabelModel();
        dFLabelModel.textSize = (Integer)DFStyleManager.getInstance().getStyle(DFUtils.getFontSizeKey(this.getContext(), DFStyleManager.CONTENTS_DESCRIPTION_FONT_SIZE_NORMAL, DFStyleManager.CONTENTS_DESCRIPTION_FONT_SIZE_SMALL));
        dFLabelModel.gravity = DFUtils.getTextGravity((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_DESCRIPTION_TEXT_ALIGNMENT));
        dFLabelModel.textColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DESCRIPTION_FONT_COLOR));
        dFLabelModel.style = DFUtils.getTextTypeFace((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_DESCRIPTION_FONT_STYLE));
        dFLabelModel.text = this.description;
        dFLabelModel.requiredTextColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_REQUIRED_TEXT_COLOR));
        dFLabelModel.optionalTextColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_OPTIONAL_TEXT_COLOR));
        DFLabelViewModel dFLabelViewModel = new DFLabelViewModel(dFLabelModel);
        DFContentLabelView dFContentLabelView = new DFContentLabelView(this.getContext(), dFLabelViewModel);
        int n = DFUtils.toDP(this.getContext(), 20.0f);
        int n2 = DFUtils.toDP(this.getContext(), 10.0f);
        dFContentLabelView.setPadding(n, n2, 0, 0);
        return dFContentLabelView;
    }

    protected void makeButtonLayout() {
        if (this.mBottom != null) {
            this.mBottom.removeAllViews();
            this.mBottom = null;
        }
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        float f2 = ((Integer)dFStyleManager.getStyle(DFUtils.getFontSizeKey(this.getContext(), DFStyleManager.POPUP_CANCELBUTTON_FONT_SIZE_NORMAL, DFStyleManager.POPUP_CANCELBUTTON_FONT_SIZE_SMALL))).intValue();
        DFConfirmButtonModel dFConfirmButtonModel = new DFConfirmButtonModel();
        dFConfirmButtonModel.text = OZAndroidResource.getResource(60015);
        dFConfirmButtonModel.radius = DFUtils.toDP(this.getContext(), ((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_CANCELBUTTON_CORNER_RADIUS)).intValue());
        dFConfirmButtonModel.textColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_CANCELBUTTON_FONT_COLOR));
        dFConfirmButtonModel.backgroundColor = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.POPUP_CANCELBUTTON_BACKGROUND_COLOR));
        dFConfirmButtonModel.sizeType = (Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.PROGRESSBUTTON_SIZE_TYPE);
        DFConfirmButtonViewModel dFConfirmButtonViewModel = new DFConfirmButtonViewModel(dFConfirmButtonModel);
        dFConfirmButtonViewModel.confirmModel.textSize = (int)f2;
        this.btnCancel = new DFConfirmButtonView(this.getContext(), dFConfirmButtonViewModel);
        this.btnCancel.setOnTouchListener(new DFBasePopupView$1(this));
        f2 = ((Integer)dFStyleManager.getStyle(DFUtils.getFontSizeKey(this.getContext(), DFStyleManager.POPUP_CONFIRMBUTTON_FONT_SIZE_NORMAL, DFStyleManager.POPUP_CONFIRMBUTTON_FONT_SIZE_SMALL))).intValue();
        DFConfirmButtonModel dFConfirmButtonModel2 = new DFConfirmButtonModel();
        dFConfirmButtonModel2.text = OZAndroidResource.getResource(60014);
        dFConfirmButtonModel2.radius = DFUtils.toDP(this.getContext(), ((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_CONFIRMBUTTON_CORNER_RADIUS)).intValue());
        dFConfirmButtonModel2.textColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.POPUP_CONFIRMBUTTON_FONT_COLOR));
        dFConfirmButtonModel2.backgroundColor = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.POPUP_CONFIRMBUTTON_BACKGROUND_COLOR));
        dFConfirmButtonModel2.sizeType = (Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.PROGRESSBUTTON_SIZE_TYPE);
        DFConfirmButtonViewModel dFConfirmButtonViewModel2 = new DFConfirmButtonViewModel(dFConfirmButtonModel2);
        dFConfirmButtonViewModel2.confirmModel.textSize = (int)f2;
        this.btnOK = new DFConfirmButtonView(this.getContext(), dFConfirmButtonViewModel2);
        this.btnOK.setOnTouchListener(new DFBasePopupView$2(this));
        this.mBottom = new LinearLayout(this.getContext());
        this.mBottom.setOrientation(0);
        this.mBottom.setGravity(17);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 0);
        layoutParams.gravity = 80;
        layoutParams.height = DFUtils.toDP(this.getContext(), 100.0f);
        this.addView((View)this.mBottom, (ViewGroup.LayoutParams)layoutParams);
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(-2, -2);
        int n = DFUtils.toDP(this.getContext(), 5.0f);
        layoutParams2.setMargins(n, n, n, n);
        this.mBottom.addView((View)this.btnCancel, (ViewGroup.LayoutParams)layoutParams2);
        this.mBottom.addView((View)this.btnOK, (ViewGroup.LayoutParams)layoutParams2);
    }

    protected void performCancel() {
        if (this.parentView != null) {
            this.parentView.script(31, false);
        }
    }

    protected void performOK() {
        if (this.parentView != null) {
            this.parentView.script(31, true);
        }
    }
}

