/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.popup;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import oz.viewer.ui.df.DFManager;
import oz.viewer.ui.df.mvvm.views.list.DFHorizontalListView;
import oz.viewer.ui.df.mvvm.views.list.DFListView;
import oz.viewer.ui.df.mvvm.views.list.DFListViewModel;
import oz.viewer.ui.df.mvvm.views.popup.DFBasePopupView;

public class DFListPopupView
extends DFBasePopupView {
    private DFListViewModel viewModel;

    public DFListPopupView(Context context, DFListView dFListView, DFManager dFManager) {
        super(context);
        this.setClickable(true);
        this.parentView = dFListView;
        this.viewModel = dFListView.getViewModel();
        this.manager = dFManager;
        this.questionnumber = this.viewModel.questionnumber;
        this.question = this.viewModel.question;
        this.description = this.viewModel.description;
    }

    public void makePopupLayout(ViewGroup viewGroup) {
        this.makePopupLayout();
        int n = this.updateListItems(viewGroup);
        this.mContents.addView((View)viewGroup, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, n));
        this.resizePopupLayout();
    }

    public int updateListItems(ViewGroup viewGroup) {
        int n = 0;
        if (this.viewModel.listModel.viewType == DFListView.DF_LISTVIEW_TYPE_VERTICAL) {
            n = ((DFListView)this.parentView).updateSizeChanged(this.viewModel.listModel.itemWidth, 0);
            ((DFListView)this.parentView).updateView();
        } else {
            viewGroup.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            if (this.viewModel.listModel.itemViewType == 0) {
                ((DFListView)this.parentView).getListViewHeightBasedOnChildren();
            }
            ((DFListView)this.parentView).updateView();
            ((DFHorizontalListView)viewGroup).makeItems();
            viewGroup.measure(this.getMeasuredWidth(), 0);
            n = ((DFHorizontalListView)viewGroup).getListViewHeight();
        }
        return n;
    }
}

