/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.text;

import android.content.Context;
import org.json.JSONObject;
import oz.viewer.ui.df.mvvm.model.text.DFTextModel;

public class DFTextViewModel {
    public DFTextModel textModel;
    public String formid;
    public String value;
    Context context;

    public DFTextViewModel(DFTextModel dFTextModel) {
        this.textModel = dFTextModel;
        this.textModel.returnKeyType = 0 != this.textModel.returnKeyType ? this.textModel.returnKeyType : 0;
    }

    public DFTextViewModel(Context context) {
        this.context = context;
        this.textModel = new DFTextModel();
        this.textModel.returnKeyType = 0 != this.textModel.returnKeyType ? this.textModel.returnKeyType : 0;
    }

    public int getReturnKeyType() {
        return this.textModel.isMultiLine ? 0 : this.textModel.returnKeyType;
    }

    boolean isNormalType() {
        return this.textModel.textInputMode == 1;
    }

    boolean isNumericKeyboard() {
        return this.isNormalType() && this.textModel.keyboardType == 2;
    }

    int getRealKeyboardTypePassword() {
        int n = 129;
        if (this.isNumericKeyboard()) {
            n = 12418;
        }
        return n;
    }

    int getRealKeyboardType() {
        int n = 0;
        switch (this.textModel.keyboardType) {
            case 0: 
            case 10: 
            case 12: 
            case 13: {
                n = 1;
                break;
            }
            case 1: 
            case 11: {
                n = 145;
                break;
            }
            case 2: {
                n = 12290;
                break;
            }
            case 4: {
                n = 33;
                break;
            }
            case 5: {
                n = 3;
                break;
            }
            case 6: {
                n = 17;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    public void setAttribute(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.setAttribute(jSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAttribute(JSONObject jSONObject) {
        this.formid = jSONObject.optString("formid");
        this.value = jSONObject.optString("text_text");
        this.textModel.setAttribute(jSONObject);
    }
}

