/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.voice;

import android.content.ContentValues;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.voice.DFVoiceView$1;
import oz.viewer.ui.df.mvvm.views.voice.DFVoiceView$2;
import oz.viewer.ui.df.mvvm.views.voice.DFVoiceView$3;
import oz.viewer.ui.df.mvvm.views.voice.DFVoiceView$4;
import oz.viewer.ui.df.mvvm.views.voice.DFVoiceView$5;
import oz.viewer.ui.df.mvvm.views.voice.DFVoiceView$TimeThread;
import oz.viewer.ui.df.mvvm.views.voice.DFVoiceViewModel;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFVoiceView
extends DFLayoutView
implements View.OnClickListener {
    public DFVoiceViewModel viewModel;
    private Button leftBtn;
    private Button rightBtn;
    private Button centerBtn;
    private SeekBar voiceProgress;
    private LinearLayout timeLayout;
    private TextView timeView;
    private TextView limitTimeView;
    private TextView textAfterInput;
    private MediaRecorder recorder;
    private MediaPlayer player;
    boolean isStart = false;
    private DFVoiceView$TimeThread timeThread = null;
    private String filename;
    static ArrayList tmpFileList = new ArrayList();
    private int currentMode;
    private int possibleMode;

    public DFVoiceView(Context context, DFVoiceViewModel dFVoiceViewModel) {
        super(context);
        this.viewModel = dFVoiceViewModel;
        this.initView();
    }

    public void initView() {
        this.setProperty();
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        this.leftBtn = new Button(this.getContext());
        this.leftBtn.setOnClickListener((View.OnClickListener)this);
        this.leftBtn.setGravity(17);
        this.centerBtn = new Button(this.getContext());
        this.centerBtn.setOnClickListener((View.OnClickListener)this);
        this.centerBtn.setGravity(17);
        this.rightBtn = new Button(this.getContext());
        this.rightBtn.setOnClickListener((View.OnClickListener)this);
        this.rightBtn.setGravity(17);
        int n = DFUtils.toDP(this.getContext(), 15.0f);
        int n2 = DFUtils.toDP(this.getContext(), 31.0f);
        int n3 = DFUtils.toDP(this.getContext(), 35.0f);
        int n4 = DFUtils.toDP(this.getContext(), 100.0f);
        int n5 = DFUtils.toDP(this.getContext(), 50.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(n4, n4);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(n5, n5);
        LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.setMargins(n, 0, n, 0);
        layoutParams2.setMargins(n, 0, n, 0);
        layoutParams3.setMargins(0, 0, 0, n3);
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setOrientation(0);
        linearLayout2.addView((View)this.leftBtn, (ViewGroup.LayoutParams)layoutParams2);
        linearLayout2.addView((View)this.centerBtn, (ViewGroup.LayoutParams)layoutParams);
        linearLayout2.addView((View)this.rightBtn, (ViewGroup.LayoutParams)layoutParams2);
        linearLayout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        int n6 = DFUtils.toDP(this.getContext(), 8.0f);
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(1);
        gradientDrawable.setColor(-1);
        gradientDrawable.setSize(n6, n6);
        this.voiceProgress = new SeekBar(this.getContext());
        this.voiceProgress.setIndeterminate(false);
        this.voiceProgress.setThumb((Drawable)gradientDrawable);
        this.voiceProgress.setProgressTintList(ColorStateList.valueOf((int)-1277634344));
        this.voiceProgress.setThumbOffset(0);
        this.voiceProgress.setOnTouchListener((View.OnTouchListener)new DFVoiceView$1(this));
        this.voiceProgress.setProgress(0);
        this.voiceProgress.setMax(100);
        LinearLayout.LayoutParams layoutParams4 = new LinearLayout.LayoutParams(-1, -2);
        layoutParams4.setMargins(0, 0, 0, n2);
        this.voiceProgress.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.textAfterInput = new TextView(this.getContext());
        LinearLayout.LayoutParams layoutParams5 = new LinearLayout.LayoutParams(-1, -2);
        layoutParams5.setMargins(n, 0, n, n);
        linearLayout.addView((View)this.textAfterInput, (ViewGroup.LayoutParams)layoutParams5);
        linearLayout.addView((View)linearLayout2);
        linearLayout.addView((View)this.voiceProgress);
        this.timeView = new TextView(this.getContext());
        this.limitTimeView = new TextView(this.getContext());
        this.timeView.setTextColor(-1);
        this.limitTimeView.setTextColor(-1);
        this.updateProgress(0);
        this.timeLayout = new LinearLayout(this.getContext());
        this.timeLayout.setOrientation(0);
        this.timeLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.timeLayout.setGravity(17);
        this.timeLayout.addView((View)this.timeView);
        this.timeLayout.addView((View)this.limitTimeView);
        linearLayout.addView((View)this.timeLayout);
        this.addView((View)linearLayout);
        this.updateView();
    }

    public void updateView() {
        this.leftBtn.setBackground(this.viewModel.voiceModel.clearDrawable);
        this.setCenterButtonResource(this.viewModel.voiceModel.recordDrawable);
        this.rightBtn.setBackground(this.viewModel.voiceModel.stopDrawable);
        int n = this.viewModel.voiceModel.fontSize;
        int n2 = this.viewModel.voiceModel.fontColor;
        this.textAfterInput.setText((CharSequence)this.viewModel.voiceModel.textAfterInput);
        this.textAfterInput.setTextColor(n2);
        this.textAfterInput.setTextSize((float)n);
        if (this.viewModel.value == null || this.viewModel.value != null && this.viewModel.value.length == 0) {
            this.textAfterInput.setVisibility(4);
            this.possibleMode = 1;
            this.setCenterButtonResource(this.viewModel.voiceModel.recordDrawable);
            this.hideSideButton();
        } else {
            this.textAfterInput.setVisibility(0);
            this.possibleMode = 4;
            this.setCenterButtonResource(this.viewModel.voiceModel.playDrawable);
            if (this.viewModel.voiceModel.isReadOnly) {
                this.hideSideButton();
            } else {
                this.showOnlyLeftButton();
            }
            try {
                String string = this.getContext().getExternalFilesDir(null).toString() + "OZVoiceRecorder_backup.m4a";
                File file = new File(string);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(this.viewModel.value);
                fileOutputStream.close();
                tmpFileList.add(file.getAbsolutePath());
                this.player = new MediaPlayer();
                this.player.setAudioStreamType(3);
                this.player.setDataSource(this.getContext(), Uri.fromFile((File)file));
                this.player.prepare();
                this.updateProgress(1, this.player.getDuration());
                this.player.release();
                this.player = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.hideProgress();
    }

    private void setProperty() {
        this.filename = this.getContext().getExternalFilesDir(null).toString() + System.currentTimeMillis() + ".m4a";
    }

    private void branchCenterButton() {
        switch (this.possibleMode) {
            case 1: {
                this.executeEvent(12, null);
                this.performRecordBtnClick();
                break;
            }
            case 2: {
                this.performRecordPauseBtnClick();
                break;
            }
            case 4: {
                this.executeEvent(12, null);
                this.performPlayBtnClick();
            }
        }
    }

    private void performResetBtnClick() {
        this.textAfterInput.setVisibility(4);
        if (this.currentMode == 4) {
            this.stopPlayer();
        }
        this.viewModel.value = null;
        this.hideSideButton();
        this.updateProgress(0);
        this.setCenterButtonResource(this.viewModel.voiceModel.recordDrawable);
        this.possibleMode = 1;
        this.currentMode = 3;
        if (!this.viewModel.voiceModel.isEndInput) {
            this.executeEvent(14, this.OnScript(-16777211, null));
        }
    }

    private void performRecordBtnClick() {
        if (!this.isStart) {
            this.isStart = true;
            if (this.recorder == null) {
                this.recorder = new MediaRecorder();
                if (this.viewModel.voiceModel.recordTimeLimit > 0) {
                    this.showProgress();
                    this.recorder.setMaxDuration(this.viewModel.voiceModel.recordTimeLimit * 1000);
                } else {
                    this.voiceProgress.setVisibility(4);
                    this.timeLayout.setVisibility(0);
                    this.limitTimeView.setVisibility(8);
                    this.recorder.setMaxDuration(0);
                }
                this.timeView.setVisibility(0);
                this.timeView.setText((CharSequence)"00:00");
                this.recorder.setOnInfoListener((MediaRecorder.OnInfoListener)new DFVoiceView$2(this));
                this.recorder.setOnErrorListener((MediaRecorder.OnErrorListener)new DFVoiceView$3(this));
                ContentValues contentValues = new ContentValues(3);
                contentValues.put("title", "");
                this.recorder.setAudioSource(1);
                this.recorder.setOutputFormat(2);
                if (Build.VERSION.SDK_INT >= 10) {
                    this.recorder.setAudioEncoder(3);
                } else {
                    this.recorder.setAudioEncoder(1);
                }
                this.recorder.setOutputFile(this.filename);
                try {
                    this.recorder.prepare();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timeThread = new DFVoiceView$TimeThread(this);
                this.recorder.start();
                this.timeThread.start();
            } else {
                this.recorderResume();
                this.timeThread.resumeTime();
            }
            if (Build.VERSION.SDK_INT < 24) {
                this.centerBtn.setVisibility(4);
            }
            this.setCenterButtonResource(this.viewModel.voiceModel.pauseDrawable);
            this.possibleMode = 2;
            this.currentMode = 1;
            this.updateRightButton(true);
        }
    }

    private void performRecordPauseBtnClick() {
        if (this.currentMode == 1) {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    this.recorderPause();
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(300L);
                        this.recorderPause();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.isStart = false;
                this.timeThread.pauseTime();
                this.setCenterButtonResource(this.viewModel.voiceModel.recordDrawable);
                this.possibleMode = 1;
                this.currentMode = 2;
            }
        } else if (this.currentMode == 4) {
            this.timeThread.pauseTime();
            this.pausePlayer();
            this.setCenterButtonResource(this.viewModel.voiceModel.playDrawable);
            this.possibleMode = 4;
            this.currentMode = 2;
        }
    }

    private void recorderPause() {
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                Method method = this.recorder.getClass().getMethod("pause", new Class[0]);
                method.invoke((Object)this.recorder, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void recorderResume() {
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                Method method = this.recorder.getClass().getMethod("resume", new Class[0]);
                method.invoke((Object)this.recorder, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void performRecordStopBtnClick() {
        this.textAfterInput.setVisibility(0);
        if (this.currentMode == 1 || this.currentMode == 2) {
            if (this.recorder != null) {
                try {
                    this.recorder.stop();
                    this.recorder.reset();
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(300L);
                        this.recorder.stop();
                        this.recorder.reset();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.isStart = false;
                this.timeThread.end();
                this.saveVoice();
                if (Build.VERSION.SDK_INT < 24) {
                    this.centerBtn.setVisibility(0);
                }
                if (this.viewModel.value != null) {
                    this.showOnlyLeftButton();
                    this.recorder = null;
                }
            }
            if (this.player != null) {
                this.stopPlayer();
                this.showOnlyLeftButton();
            }
        } else if (this.currentMode == 4) {
            this.stopPlayer();
            this.showOnlyLeftButton();
        }
        this.setCenterButtonResource(this.viewModel.voiceModel.playDrawable);
        this.possibleMode = 4;
        this.currentMode = 3;
        if (!this.viewModel.voiceModel.isEndInput) {
            this.executeEvent(14, this.OnScript(-16777211, null));
        }
    }

    private void performPlayBtnClick() {
        try {
            String string = this.getContext().getExternalFilesDir(null).toString() + "OZVoiceRecorder_backup.m4a";
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.viewModel.value);
            fileOutputStream.close();
            tmpFileList.add(file.getAbsolutePath());
            if (this.player == null) {
                this.player = new MediaPlayer();
                this.player.setAudioStreamType(3);
                this.player.setDataSource(this.getContext(), Uri.fromFile((File)file));
                this.player.prepare();
                this.updateProgress(1, this.player.getDuration());
                this.player.start();
                this.player.setOnCompletionListener((MediaPlayer.OnCompletionListener)new DFVoiceView$4(this));
                this.timeThread = new DFVoiceView$TimeThread(this);
                this.timeThread.start();
            } else {
                this.timeThread.resumeTime();
                this.player.start();
            }
            this.showProgress();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Toast.makeText((Context)this.getContext(), (CharSequence)"voice.recorder.playerror", (int)0).show();
        }
        this.showOnlyRightButton();
        this.setCenterButtonResource(this.viewModel.voiceModel.pauseDrawable);
        this.possibleMode = 2;
        this.currentMode = 4;
    }

    private void setCenterButtonResource(Drawable drawable2) {
        this.centerBtn.setBackground(drawable2);
    }

    private void updateLeftButton(boolean bl) {
        if (bl) {
            this.leftBtn.setVisibility(0);
        } else {
            this.leftBtn.setVisibility(4);
        }
    }

    private void updateRightButton(boolean bl) {
        if (bl) {
            this.rightBtn.setVisibility(0);
        } else {
            this.rightBtn.setVisibility(4);
        }
    }

    private void showOnlyLeftButton() {
        this.updateLeftButton(true);
        this.updateRightButton(false);
    }

    private void showOnlyRightButton() {
        this.updateLeftButton(false);
        this.updateRightButton(true);
    }

    private void hideSideButton() {
        this.updateLeftButton(false);
        this.updateRightButton(false);
    }

    private void showProgress() {
        this.voiceProgress.setVisibility(0);
        this.timeLayout.setVisibility(0);
        this.limitTimeView.setVisibility(0);
    }

    private void hideProgress() {
        this.voiceProgress.setVisibility(4);
        this.timeLayout.setVisibility(4);
        this.limitTimeView.setVisibility(4);
    }

    private void pausePlayer() {
        if (this.player != null && this.player.isPlaying()) {
            this.player.pause();
        }
    }

    private void stopPlayer() {
        if (this.player != null) {
            if (this.player.isPlaying()) {
                this.player.stop();
            }
            this.player.release();
            this.player = null;
        }
        if (this.timeThread != null) {
            this.timeThread.end();
        }
        this.hideProgress();
    }

    public void clearTempFile() {
        if (tmpFileList != null) {
            for (int j = 0; j < tmpFileList.size(); ++j) {
                new File((String)tmpFileList.get(j)).delete();
            }
            tmpFileList.clear();
            tmpFileList = new ArrayList();
        }
    }

    public void saveVoice() {
        this.saveVoice(0);
    }

    public void saveVoice(int n) {
        if (this.isStart) {
            try {
                this.recorder.stop();
            }
            catch (Exception exception) {
                if (n < 3) {
                    this.postDelayed(new DFVoiceView$5(this, n), 100L);
                    return;
                }
                this.performRecordStopBtnClick();
            }
        }
        if (this.recorder != null) {
            this.recorder.release();
        }
        this.recorder = null;
        this.isStart = false;
        this.timeThread.end();
        this.hideProgress();
        try {
            File file = new File(this.filename);
            if (file.exists()) {
                this.viewModel.value = this.getBytes(new FileInputStream(this.filename));
                file.delete();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.viewModel.value = null;
            fileNotFoundException.printStackTrace();
        }
        this.postInvalidate();
    }

    private byte[] getBytes(InputStream inputStream) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[10000];
        try {
            while ((n = bufferedInputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
        catch (Throwable throwable) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void updateProgress(int n) {
        this.updateProgress(n, 0);
    }

    private void updateProgress(int n, int n2) {
        this.timeView.setText((CharSequence)"00:00");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("ECT"));
        if (n == 0) {
            long l = this.viewModel.voiceModel.recordTimeLimit * 1000 + 1;
            this.voiceProgress.setMax((int)l);
            this.voiceProgress.setProgress(0);
            Date date = new Date(l);
            this.limitTimeView.setText((CharSequence)(" / " + (this.viewModel.voiceModel.recordTimeLimit >= 3600 ? "60:00" : simpleDateFormat.format(date))));
        } else if (n == 1) {
            long l = n2 + 1;
            this.voiceProgress.setMax((int)l);
            this.voiceProgress.setProgress(0);
            Date date = new Date(l);
            this.limitTimeView.setText((CharSequence)(" / " + simpleDateFormat.format(date)));
        }
    }

    public void onClick(View view) {
        if (view == this.leftBtn) {
            this.performResetBtnClick();
        } else if (view == this.centerBtn) {
            this.branchCenterButton();
        } else if (view == this.rightBtn) {
            this.performRecordStopBtnClick();
        }
    }

    protected Object OnScript(int n, Object object) {
        Object object2 = null;
        switch (n) {
            case -16777208: {
                String string = (String)object;
                this.viewModel.voiceModel.setAttribute(string);
                break;
            }
            case -16777207: {
                int n2 = (Integer)object;
                if (n2 != 1) break;
                this.updateView();
                break;
            }
            case -16777211: {
                if (this.currentMode == 2) {
                    this.saveVoice();
                }
                object2 = this.viewModel.Base64Encode(this.viewModel.value);
                break;
            }
            case -16777209: {
                object2 = this.viewModel.formid;
                break;
            }
            case -16777206: {
                object2 = this.viewModel.voiceModel.isEndInput;
                break;
            }
            case -16777213: {
                if (this.currentMode == 1 || this.currentMode == 2) {
                    this.performRecordStopBtnClick();
                    break;
                }
                if (this.currentMode != 4) break;
                this.stopPlayer();
            }
        }
        return object2;
    }

    static /* synthetic */ void access$000(DFVoiceView dFVoiceView) {
        dFVoiceView.performRecordStopBtnClick();
    }

    static /* synthetic */ void access$100(DFVoiceView dFVoiceView, Drawable drawable2) {
        dFVoiceView.setCenterButtonResource(drawable2);
    }

    static /* synthetic */ int access$202(DFVoiceView dFVoiceView, int n) {
        dFVoiceView.possibleMode = n;
        return dFVoiceView.possibleMode;
    }

    static /* synthetic */ int access$302(DFVoiceView dFVoiceView, int n) {
        dFVoiceView.currentMode = n;
        return dFVoiceView.currentMode;
    }

    static /* synthetic */ void access$400(DFVoiceView dFVoiceView, int n, Object object) {
        dFVoiceView.executeEvent(n, object);
    }

    static /* synthetic */ void access$500(DFVoiceView dFVoiceView) {
        dFVoiceView.showOnlyLeftButton();
    }

    static /* synthetic */ DFVoiceView$TimeThread access$600(DFVoiceView dFVoiceView) {
        return dFVoiceView.timeThread;
    }

    static /* synthetic */ MediaPlayer access$700(DFVoiceView dFVoiceView) {
        return dFVoiceView.player;
    }

    static /* synthetic */ MediaPlayer access$702(DFVoiceView dFVoiceView, MediaPlayer mediaPlayer) {
        dFVoiceView.player = mediaPlayer;
        return dFVoiceView.player;
    }

    static /* synthetic */ void access$800(DFVoiceView dFVoiceView) {
        dFVoiceView.hideProgress();
    }

    static /* synthetic */ SeekBar access$1300(DFVoiceView dFVoiceView) {
        return dFVoiceView.voiceProgress;
    }

    static /* synthetic */ TextView access$1400(DFVoiceView dFVoiceView) {
        return dFVoiceView.timeView;
    }
}

