/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFBadgeLabelView$1;

public class DFBadgeLabelView
extends LinearLayout {
    private static final int DP_LR_MARGIN = 5;
    private Drawable mBackground;
    private TextView mTextView;

    public DFBadgeLabelView(Context context) {
        super(context);
        this.init();
    }

    public void setText(String string) {
        this.mTextView.setText((CharSequence)string);
    }

    public void init() {
        this.setOrientation(0);
        this.setWillNotDraw(false);
        this.setGravity(3);
        this.setBackground(null);
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        this.mTextView = new TextView(this.getContext());
        this.mTextView.setOnTouchListener((View.OnTouchListener)new DFBadgeLabelView$1(this));
        this.mTextView.setMinWidth(DFUtils.toDP(this.getContext(), 40.0f));
        this.setAttribute();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.topMargin = DFUtils.toDP(this.getContext(), 5.0f);
        layoutParams.bottomMargin = DFUtils.toDP(this.getContext(), 8.0f);
        layoutParams.rightMargin = DFUtils.toDP(this.getContext(), 8.0f);
        layoutParams.leftMargin = DFUtils.toDP(this.getContext(), 5.0f);
        this.addView((View)this.mTextView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setAttribute() {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        this.mTextView.setTextSize((float)((Integer)dFStyleManager.getStyle(DFUtils.getFontSizeKey(this.getContext(), DFStyleManager.CONTENTS_TITLE_FONT_SIZE_NORMAL, DFStyleManager.CONTENTS_TITLE_FONT_SIZE_SMALL))).intValue());
        this.mTextView.setTextColor(DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_TITLE_FONT_COLOR)));
        this.mTextView.setTypeface(this.mTextView.getTypeface(), DFUtils.getTextTypeFace((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_TITLE_FONT_STYLE)));
        this.mTextView.setGravity(DFUtils.getTextGravity((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_TITLE_TEXT_ALIGNMENT)));
        this.mTextView.setClickable(false);
        this.mTextView.setSingleLine();
        this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
    }

    private Drawable createBackground(int n, int n2) {
        float f2 = ((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.CONTENTS_TITLE_CORNER_RADIUS)).intValue();
        f2 = f2 < 0.0f ? (float)n2 / 2.0f : f2;
        f2 = DFUtils.toDP(this.getContext(), f2);
        RoundRectShape roundRectShape = new RoundRectShape(new float[]{f2, f2, f2, f2, f2, f2, f2, f2}, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.getPaint().setAntiAlias(true);
        shapeDrawable.getPaint().setColor(DFUtils.getARGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.CONTENTS_TITLE_BACKGROUND_COLOR)));
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.setBounds(0, 0, n, n2);
        return shapeDrawable;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mBackground = n == 0 || n2 == 0 ? null : this.createBackground(n, n2);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBackground != null) {
            this.mBackground.draw(canvas);
        }
        super.onDraw(canvas);
    }
}

