/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFConfirmButton$1;

public class DFConfirmButton
extends LinearLayout {
    private static final String STRING_OK = "OK";
    private static final int DP_LR_MARGIN = 5;
    private Drawable mBackground;
    private String mButtonText;
    private TextView mTextView;
    private int mRadius;

    public DFConfirmButton(Context context, String string) {
        super(context);
        this.mButtonText = string;
        this.init();
    }

    public void setText(String string) {
        this.mTextView.setText((CharSequence)string);
    }

    public void init() {
        this.setOrientation(0);
        this.setWillNotDraw(false);
        this.setGravity(17);
        this.setBackground(null);
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        this.mTextView = new TextView(this.getContext());
        this.mTextView.setTextColor(DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.PROGRESSBUTTON_FONT_COLOR)));
        this.mTextView.setTextSize((float)((Integer)dFStyleManager.getStyle(DFUtils.getFontSizeKey(this.getContext(), DFStyleManager.PROGRESSBUTTON_FONT_SIZE_NORMAL, DFStyleManager.PROGRESSBUTTON_FONT_SIZE_SMALL))).intValue());
        this.mTextView.setText((CharSequence)(this.mButtonText.isEmpty() ? STRING_OK : this.mButtonText));
        this.mTextView.setTypeface(null, 1);
        this.mTextView.setClickable(false);
        this.mTextView.setSingleLine();
        this.mTextView.setOnTouchListener((View.OnTouchListener)new DFConfirmButton$1(this));
        this.mRadius = (Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.PROGRESSBUTTON_CORNER_RADIUS);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.rightMargin = DFUtils.toDP(this.getContext(), 5.0f);
        layoutParams.leftMargin = DFUtils.toDP(this.getContext(), 5.0f);
        this.addView((View)this.mTextView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setRadius(int n) {
        this.mRadius = n;
    }

    private Drawable createBackground(int n, int n2) {
        float f2 = this.mRadius;
        f2 = f2 < 0.0f ? (float)n2 / 2.0f : f2;
        RoundRectShape roundRectShape = new RoundRectShape(new float[]{f2, f2, f2, f2, f2, f2, f2, f2}, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.getPaint().setAntiAlias(true);
        shapeDrawable.getPaint().setColor(DFUtils.getARGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.PROGRESSBUTTON_BACKGROUND_COLOR)));
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.setBounds(0, 0, n, n2);
        return shapeDrawable;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n == 0 || n2 == 0) {
            this.mBackground = null;
        } else if (this.mBackground == null || n2 != n4) {
            this.mBackground = this.createBackground(n, n2);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBackground != null) {
            this.mBackground.draw(canvas);
        }
        super.onDraw(canvas);
    }
}

