/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import org.json.JSONObject;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFInflaterViewMaker$ViewCreator;
import oz.viewer.ui.df.view.DFLayoutRootView;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFInflaterViewMaker {
    public static final int TYPE_ROOT = 256;
    public static final int TYPE_ROOT_TITLE = 257;
    public static final int TYPE_BUNDLE = 512;
    public static final int TYPE_TITLE_QUESTION = 4097;
    public static final int TYPE_TITLE_DESCRIPTION = 4098;
    public static final int TYPE_DIVIDER = 8193;
    public static final int TYPE_CONTENT_VIEW = 12289;
    public static final int TYPE_BOTTOM_CONFIRM = 16385;
    private final DFInflaterViewMaker$ViewCreator mCreator;
    private int contentWidth;
    private int contentHeight;
    private boolean isNotList;
    public boolean mIsGroup;
    public int mChildCount;
    public boolean mShowRootTitle;
    public boolean canConfirmNext;

    public DFInflaterViewMaker(DFInflaterViewMaker$ViewCreator dFInflaterViewMaker$ViewCreator) {
        this.mCreator = dFInflaterViewMaker$ViewCreator;
    }

    public void updateContentSize(int n, int n2) {
        this.contentWidth = n;
        this.contentHeight = n2;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public void setIsNotList(boolean bl) {
        this.isNotList = bl;
    }

    public boolean isNotList() {
        return this.isNotList;
    }

    public void setCanConfirmNext(boolean bl) {
        this.canConfirmNext = bl;
    }

    public DFLayoutView createView(Context context, int n, JSONObject jSONObject) {
        DFLayoutView dFLayoutView = null;
        switch (n) {
            case 256: {
                dFLayoutView = new DFLayoutRootView(context);
                break;
            }
            case 257: {
                dFLayoutView = this.getRootTitleView(context, jSONObject);
                break;
            }
            case 512: {
                break;
            }
            case 4097: {
                dFLayoutView = this.getQuestionView(context, jSONObject);
                break;
            }
            case 4098: {
                dFLayoutView = this.getDescriptionView(context, jSONObject);
                break;
            }
            case 8193: {
                dFLayoutView = this.getDividerView(context, jSONObject);
                break;
            }
            case 12289: {
                dFLayoutView = this.getContentView(context, jSONObject);
                break;
            }
            case 16385: {
                dFLayoutView = this.getConfirmView(context, jSONObject);
            }
        }
        return dFLayoutView;
    }

    private DFLayoutView getRootTitleView(Context context, JSONObject jSONObject) {
        if (this.mShowRootTitle) {
            return this.mCreator.makeRootTitle(context, this, jSONObject);
        }
        return null;
    }

    private DFLayoutView getQuestionView(Context context, JSONObject jSONObject) {
        return this.mCreator.makeQuestion(context, this, jSONObject);
    }

    private DFLayoutView getDescriptionView(Context context, JSONObject jSONObject) {
        return this.mCreator.makeDescription(context, this, jSONObject);
    }

    private DFLayoutView getDividerView(Context context, JSONObject jSONObject) {
        return this.mCreator.makeDiver(context, this, jSONObject);
    }

    private DFStyleManager style() {
        return DFStyleManager.getInstance();
    }

    private int getConfirmTextType(int n) {
        int n2 = DFStyleManager.PROGRESSBUTTON_TEXT_DONE;
        switch (n) {
            case 0: {
                if (this.isNotList || !this.canConfirmNext) {
                    n2 = DFStyleManager.PROGRESSBUTTON_TEXT_DONE;
                    break;
                }
                n2 = DFStyleManager.PROGRESSBUTTON_TEXT_INPUTCOMP;
                break;
            }
            case 1: {
                n2 = DFStyleManager.PROGRESSBUTTON_TEXT_STATEMENT;
                break;
            }
            case 2: {
                n2 = DFStyleManager.PROGRESSBUTTON_TEXT_WELCOME;
                break;
            }
            case 3: {
                n2 = DFStyleManager.PROGRESSBUTTON_TEXT_THANKYOU;
                break;
            }
            case 4: {
                n2 = this.isNotList || !this.canConfirmNext ? DFStyleManager.PROGRESSBUTTON_TEXT_DONE : DFStyleManager.PROGRESSBUTTON_TEXT_INPUTCOMP;
            }
        }
        return n2;
    }

    private DFLayoutView getConfirmView(Context context, JSONObject jSONObject) {
        int n = this.getConfirmTextType(jSONObject.optInt("dftype"));
        float f2 = ((Integer)this.style().getStyle(DFUtils.getFontSizeKey(context, DFStyleManager.PROGRESSBUTTON_FONT_SIZE_NORMAL, DFStyleManager.PROGRESSBUTTON_FONT_SIZE_SMALL))).intValue();
        return this.mCreator.makeConfirmButton(context, this, this.style().getStyle(n).toString(), f2);
    }

    private DFLayoutView getContentView(Context context, JSONObject jSONObject) {
        DFLayoutView dFLayoutView = null;
        int n = jSONObject.optInt("comptype");
        switch (n) {
            case 53: {
                dFLayoutView = this.mCreator.makeCheck(context, this, jSONObject);
                break;
            }
            case 54: {
                dFLayoutView = this.mCreator.makeText(context, this, jSONObject);
                break;
            }
            case 55: {
                dFLayoutView = this.mCreator.makeCombo(context, this, jSONObject);
                break;
            }
            case 57: {
                try {
                    jSONObject.put("contentWidth", this.contentWidth);
                    jSONObject.put("contentHeight", this.contentHeight);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                dFLayoutView = this.mCreator.makeSign(context, this, jSONObject);
                break;
            }
            case 58: {
                dFLayoutView = this.mCreator.makeVoice(context, this, jSONObject);
                break;
            }
            case 59: {
                dFLayoutView = this.mCreator.makeDate(context, this, jSONObject);
                break;
            }
            case 60: {
                dFLayoutView = this.mCreator.makeNumber(context, this, jSONObject);
                break;
            }
            case 81: {
                dFLayoutView = this.mCreator.makeRadioGroup(context, this, jSONObject);
                break;
            }
            case 82: {
                dFLayoutView = this.mCreator.makeImage(context, this, jSONObject);
                break;
            }
            case 87: {
                dFLayoutView = this.mCreator.makeToggle(context, this, jSONObject);
                break;
            }
            case 89: {
                dFLayoutView = this.mCreator.makeAttachment(context, this, jSONObject);
            }
        }
        return dFLayoutView;
    }
}

