/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.util.StateSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.util.drawable.FitBitmapDrawable;
import oz.util.view.animatable.AnimatableFrameLayout;
import oz.util.view.animatable.AnimatableScrollView;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.DFUtils$EmptyStringException;
import oz.viewer.ui.df.view.BubbleTextLayout;
import oz.viewer.ui.df.view.DFContentLayout;
import oz.viewer.ui.df.view.DFLayoutHelper$1;
import oz.viewer.ui.df.view.DFLayoutHelper$DISPLAY_AREA;
import oz.viewer.ui.df.view.DFLayoutHelper$PROGRESSBAR_POSITION;
import oz.viewer.ui.df.view.DFLayoutRootTitleView;
import oz.viewer.ui.df.view.DFLayoutRootTitleView_Badge;
import oz.viewer.ui.df.view.DFLayoutRootTitleView_DefaultStyle;
import oz.viewer.ui.df.view.DFMicBtnView;
import oz.viewer.ui.df.view.DFProgressbar;
import oz.viewer.ui.df.view.DFRootFrameLayout;

public class DFLayoutHelper {
    public static final int SP_TITLE = 16;
    public static final int DP_DISMISS_BTN_SIZE = 30;
    public static final int DP_DISMISS_BTN_TOP_RIGHT_MARGIN = 10;
    public static final int DP_BOTTOM_BTN_SIZE = 50;
    public static final int DP_BOTTOM_BAR_PADDING = 10;
    public static final int DP_LEFT_RIGHT_PADDING = 20;
    public static final int DP_TOP_BOTTOM_PADDING = 10;
    public static final int DP_CONTENT_BASE_ROOT_LEFT_RIGHT_PADDING = 40;
    public static final int DP_MIC_LAYOUT_SIZE = 120;
    public static final int DP_DRAWABLE_BTN_PREV_NEXT_RAD = 6;
    public static final int DP_PROGRESS_MARGIN = 20;
    public static final int DP_DEVIDER_HEIGHT = 30;
    public static final int DF_TITLE_SHAPETYPE_NORMAL = 0;
    public static final int DF_TITLE_SHAPETYPE_BADGE = 1;
    private static DFLayoutHelper$DISPLAY_AREA mDisplayArea;
    private static int contextSize;
    private static int contextVerticalAling;
    private static DFLayoutHelper$PROGRESSBAR_POSITION mProgrssBarPosition;
    private static final int DP_BOTTOM_STROKE = 1;
    private static final int COLOR_BOTTOM_STROKE;
    private static final int COLOR_MIC_BG;
    private static final int COLOR_TINT_BTN_PRESSED;
    private static final int DP_PREV_NEXT_BORDER_WIDTH = 1;
    private static final int COLOR_PREV_NEXT_BTN_BG;
    private static final int COLOR_PREV_NEXT_BTN_PRESSED;
    private static final int COLOR_PREV_NEXT_BTN_DISABLED;
    private static final int COLOR_PREV_NEXT_BTN_STROKE;

    private static void setDisplayArea(int n) {
        switch (n) {
            case 0: {
                mDisplayArea = DFLayoutHelper$DISPLAY_AREA.FULLSCREEN;
                break;
            }
            case 1: {
                mDisplayArea = DFLayoutHelper$DISPLAY_AREA.CENTER;
                break;
            }
            case 2: {
                mDisplayArea = DFLayoutHelper$DISPLAY_AREA.BOTTOM;
                break;
            }
            default: {
                mDisplayArea = DFLayoutHelper$DISPLAY_AREA.CENTER;
            }
        }
    }

    public static void setContextSize(int n) {
        contextSize = n;
    }

    public static int getContextVerticalAling() {
        return contextVerticalAling;
    }

    public static Dialog createDialog(Context context, int n, int n2, int n3, int n4, String string, boolean bl, int n5, int n6, int n7) {
        DFLayoutHelper.setDisplayArea(n7);
        DFLayoutHelper.setContextSize(n3);
        contextVerticalAling = n4;
        mProgrssBarPosition = DFLayoutHelper$PROGRESSBAR_POSITION.TOP;
        if ((n6 == 1 || n6 == 2) && (bl && (n5 == 0 || n5 == 1) || !bl && n5 == 2)) {
            mProgrssBarPosition = DFLayoutHelper$PROGRESSBAR_POSITION.BOTTOM;
        }
        FrameLayout frameLayout = DFLayoutHelper.createRoot(context);
        frameLayout.addView(DFLayoutHelper.createBackgroundView(context), new ViewGroup.LayoutParams(-1, -1));
        frameLayout.addView((View)DFLayoutHelper.createContentLayout(context));
        frameLayout.addView(DFLayoutHelper.createContentBottomLayout(context));
        DFLayoutHelper.appendTopBar(context, (ViewGroup)frameLayout);
        DFLayoutHelper.appendBottomBar(context, (ViewGroup)frameLayout);
        DFLayoutHelper.appendDismiss(context, frameLayout);
        FrameLayout frameLayout2 = DFLayoutHelper.createDummyRoot(context);
        frameLayout2.addView((View)frameLayout);
        DFLayoutHelper.updateDFLayout(context, (View)frameLayout, n, n2);
        Dialog dialog = DFLayoutHelper.createEmptyDialog(context);
        dialog.getWindow().getDecorView().setMinimumHeight(n2);
        DFLayoutHelper.roundedDailogView(context, (View)frameLayout);
        DFLayoutHelper.alignCenterDialog(context, (View)frameLayout, n, n2);
        frameLayout.setElevation(20.0f);
        dialog.setContentView((View)frameLayout2);
        return dialog;
    }

    public static void roundedDailogView(Context context, View view) {
        view.setOutlineProvider((ViewOutlineProvider)new DFLayoutHelper$1());
        view.setClipToOutline(true);
    }

    public static void alignCenterDialog(Context context, View view, int n, int n2) {
        Point point = DFUtils.getScreenSize((Activity)context);
        int n3 = (point.x - n) / 2;
        int n4 = (point.y - n2) / 2;
        view.setX((float)n3);
        view.setY((float)n4);
    }

    public static void updateDFLayoutNoReal(View view, int n, int n2) {
        if (view != null && view.getId() != 65536) {
            view = view.findViewById(65536);
        }
        if (view != null) {
            view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
            View view2 = view.findViewById(8192);
            if (view2.getMeasuredHeight() == 0) {
                view2.measure(0, 0);
            }
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            layoutParams.bottomMargin = view2.getMeasuredHeight();
            view.findViewById(4096).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void updateDFLayout(Context context, View view, int n, int n2) {
        View view2;
        if (view != null && view.getId() != 65536) {
            view = view.findViewById(65536);
        }
        if (view != null && view.getParent() != null && (view2 = view.findViewById(104857)) != null) {
            view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
            DFLayoutHelper.updateDFLayoutNoReal(view, n, n2);
        }
    }

    private static View createContentBottomLayout(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setId(8192);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 80));
        return frameLayout;
    }

    private static void appendDismiss(Context context, FrameLayout frameLayout) {
        View view = new View(context);
        view.setId(4353);
        Drawable drawable2 = DFUtils.getMakeDrawable(context, DFLayoutHelper.createBtnDrawable(context, 9), DFStyleManager.COMMON_IS_USE_DIALOG_CLOSE_BUTTON_COLOR, DFStyleManager.COMMON_DIALOG_CLOSE_BUTTON_COLOR, DFStyleManager.COMMON_DIALOG_CLOSE_BUTTON_IMAGE);
        view.setBackground(drawable2);
        int n = DFUtils.toDP(context, 30.0f);
        ViewGroup viewGroup = (ViewGroup)frameLayout.findViewById(65536);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n, n, 53);
        viewGroup.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    private static int getAreaGravity() {
        int n = 17;
        if (mDisplayArea == DFLayoutHelper$DISPLAY_AREA.BOTTOM) {
            n = 80;
        }
        return n;
    }

    private static Dialog createEmptyDialog(Context context) {
        Dialog dialog = new Dialog(context, 16973834);
        dialog.setCanceledOnTouchOutside(false);
        dialog.setCancelable(false);
        Window window = dialog.getWindow();
        window.setSoftInputMode(16);
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.gravity = DFLayoutHelper.getAreaGravity();
        layoutParams.flags &= 0xFFFFFFFD;
        window.setAttributes(layoutParams);
        ColorDrawable colorDrawable = new ColorDrawable(-16777216);
        if (DFUtils.isMobile(context)) {
            colorDrawable.setAlpha(255);
        } else {
            colorDrawable.setAlpha(180);
        }
        window.setBackgroundDrawable((Drawable)colorDrawable);
        return dialog;
    }

    private static FrameLayout createDummyRoot(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setId(104856);
        frameLayout.setFocusable(true);
        frameLayout.setFocusableInTouchMode(true);
        return frameLayout;
    }

    private static FrameLayout createRoot(Context context) {
        DFRootFrameLayout dFRootFrameLayout = new DFRootFrameLayout(context);
        dFRootFrameLayout.setId(65536);
        dFRootFrameLayout.setFocusable(true);
        dFRootFrameLayout.setFocusableInTouchMode(true);
        return dFRootFrameLayout;
    }

    private static View createBackgroundView(Context context) {
        View view = new View(context);
        view.setId(104857);
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        boolean bl = (Boolean)dFStyleManager.getStyle(DFStyleManager.COMMON_IS_USE_BACKGROUND_COLOR);
        if (bl) {
            int n = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.COMMON_BACKGROUND_COLOR));
            view.setBackgroundColor(n);
        } else {
            String string = (String)dFStyleManager.getStyle(DFStyleManager.COMMON_BACKGROUND_IMAGE);
            if (!string.isEmpty()) {
                view.setBackground(DFUtils.getImageDrawable(context, 0));
            } else {
                view.setBackground(DFUtils.getImageDrawable(context, 0));
            }
        }
        return view;
    }

    private static ViewGroup createContentLayout(Context context) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setId(4096);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout.addView((View)frameLayout);
        return linearLayout;
    }

    public static ViewGroup createContentBaseLayout(Context context) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setPadding(0, 0, 0, 0);
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setOrientation(1);
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        DFContentLayout dFContentLayout = new DFContentLayout(context);
        dFContentLayout.setOrientation(1);
        dFContentLayout.setGravity(17);
        dFContentLayout.setId(4882);
        dFContentLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout2.addView((View)dFContentLayout);
        return linearLayout;
    }

    private static LinearLayout createTopbarLayout(Context context) {
        int n = DFUtils.toDP(context, 20.0f);
        int n2 = DFUtils.toDP(context, 10.0f);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setId(4352);
        linearLayout.setOrientation(0);
        linearLayout.setGravity(19);
        linearLayout.setPadding(n, n2, n, n2);
        return linearLayout;
    }

    private static TextView createDisplayName(Context context) {
        TextView textView = new TextView(context);
        textView.setId(4355);
        textView.setSingleLine();
        textView.setEllipsize(TextUtils.TruncateAt.END);
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        textView.setTextSize((float)((Integer)dFStyleManager.getStyle(DFUtils.getFontSizeKey(context, DFStyleManager.CONTENTS_DISPLAYNAME_FONT_SIZE_NORMAL, DFStyleManager.CONTENTS_DISPLAYNAME_FONT_SIZE_SMALL))).intValue());
        textView.setTextColor(DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_DISPLAYNAME_FONT_COLOR)));
        textView.setTypeface(textView.getTypeface(), DFUtils.getTextTypeFace((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_DISPLAYNAME_FONT_STYLE)));
        textView.setGravity(DFUtils.getTextGravity((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_DISPLAYNAME_TEXT_ALIGNMENT)));
        return textView;
    }

    public static DFLayoutRootTitleView createTitle(Context context) {
        DFLayoutRootTitleView dFLayoutRootTitleView = null;
        int n = (Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.CONTENTS_TITLE_SHAPE_TYPE);
        if (n == 0) {
            dFLayoutRootTitleView = new DFLayoutRootTitleView_DefaultStyle(context);
        } else if (n == 1) {
            dFLayoutRootTitleView = new DFLayoutRootTitleView_Badge(context);
        }
        return dFLayoutRootTitleView;
    }

    private static DFMicBtnView createMICBtn(Context context) {
        DFMicBtnView dFMicBtnView = new DFMicBtnView(context);
        dFMicBtnView.setId(5121);
        return dFMicBtnView;
    }

    private static BubbleTextLayout createBubble(Context context) {
        BubbleTextLayout bubbleTextLayout = new BubbleTextLayout(context);
        bubbleTextLayout.setId(5122);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 81);
        bubbleTextLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        bubbleTextLayout.setMaximumSize(2);
        return bubbleTextLayout;
    }

    private static int getContextSizeForParam(Context context) {
        if (contextSize > 0) {
            return DFUtils.toPx(context, contextSize);
        }
        return -1;
    }

    private static void appendTopBar(Context context, ViewGroup viewGroup) {
        Object object;
        FrameLayout frameLayout = (FrameLayout)viewGroup.findViewById(4096);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setGravity(17);
        frameLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        TextView textView = DFLayoutHelper.createDisplayName(context);
        int n = DFUtils.toDP(context, 20.0f);
        int n2 = DFUtils.toDP(context, 10.0f);
        textView.setPadding(n, n2, n * 2, n2);
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(DFLayoutHelper.getContextSizeForParam(context), -2, 0.0f));
        LinearLayout linearLayout2 = DFLayoutHelper.createTopbarLayout(context);
        linearLayout2.setOrientation(0);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2, 0.0f);
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)layoutParams);
        DFLayoutRootTitleView dFLayoutRootTitleView = DFLayoutHelper.createTitle(context);
        int n3 = (Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.CONTENTS_TITLE_SHAPE_TYPE);
        if (dFLayoutRootTitleView != null) {
            dFLayoutRootTitleView.setId(4354);
            if (n3 == 1) {
                dFLayoutRootTitleView.setTitleMargin(n, n2, n, n2);
                linearLayout2.setGravity(17);
                linearLayout2.addView((View)dFLayoutRootTitleView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(DFLayoutHelper.getContextSizeForParam(context), -1, 0.0f));
            } else {
                linearLayout2.addView((View)dFLayoutRootTitleView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 0.0f));
            }
        }
        frameLayout.addView((View)DFLayoutHelper.createBubble(context));
        LinearLayout linearLayout3 = new LinearLayout(context);
        linearLayout3.setOrientation(1);
        linearLayout3.setId(4356);
        linearLayout3.setPadding(n, n2, n, n2);
        linearLayout.addView((View)linearLayout3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(DFLayoutHelper.getContextSizeForParam(context), -2, 0.0f));
        boolean bl = (Boolean)DFStyleManager.getInstance().getStyle(DFStyleManager.COMMON_IS_FIXED_GROUP_HEADER);
        if (bl) {
            object = new LinearLayout(context);
            object.setId(4359);
            int n4 = DFUtils.toDP(context, ((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.COMMON_FIXED_SEPERATOR_THICK)).intValue());
            int n5 = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.COMMON_FIXED_SEPERATOR_COLOR));
            object.setBackgroundColor(n5);
            linearLayout.addView((View)object, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(DFLayoutHelper.getContextSizeForParam(context), n4));
            object.setVisibility(8);
        }
        object = new AnimatableScrollView(context);
        object.setId(4608);
        object.setFillViewport(true);
        AnimatableFrameLayout animatableFrameLayout = ((AnimatableScrollView)object).getContentView();
        animatableFrameLayout.setId(4864);
        linearLayout.addView((View)object, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        if (viewGroup != null && viewGroup instanceof DFRootFrameLayout) {
            ((DFRootFrameLayout)viewGroup).mSV = object;
        }
        ViewGroup viewGroup2 = DFLayoutHelper.createContentBaseLayout(context);
        ((AnimatableScrollView)object).addChildInContentView((View)viewGroup2, DFLayoutHelper.getContextVerticalAling());
    }

    private static Drawable createBottomBarDrawable(Context context) {
        ShapeDrawable shapeDrawable = new ShapeDrawable();
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.getPaint().setColor(DFUtils.getARGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.PROGRESSBAR_BACKGROUND_COLOR)));
        ShapeDrawable shapeDrawable2 = new ShapeDrawable();
        shapeDrawable2.getPaint().setStrokeWidth((float)DFUtils.toDP(context, 1.0f));
        shapeDrawable2.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable2.getPaint().setColor(COLOR_BOTTOM_STROKE);
        return new LayerDrawable(new Drawable[]{shapeDrawable});
    }

    private static Drawable createMicDrawable(Context context) {
        int n = DFUtils.toDP(context, 100.0f);
        RoundRectShape roundRectShape = new RoundRectShape(new float[]{n, n, n, n, n, n, n, n}, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.getPaint().setColor(COLOR_MIC_BG);
        return new LayerDrawable(new Drawable[]{shapeDrawable});
    }

    private static BitmapDrawable getBitmapDrawableFromRes(Context context, int n) {
        return (BitmapDrawable)DFUtils.getImageDrawable(context, n);
    }

    private static Drawable createButtonDrawable(Context context, int n, float f2) {
        return DFLayoutHelper.createButtonDrawable(context, DFLayoutHelper.getBitmapDrawableFromRes(context, n), f2);
    }

    private static Drawable createButtonDrawable(Context context, BitmapDrawable bitmapDrawable, float f2) {
        return new FitBitmapDrawable(bitmapDrawable.getBitmap(), f2);
    }

    private static Drawable createBtnDrawable(Context context, int n) {
        BitmapDrawable bitmapDrawable = DFLayoutHelper.getBitmapDrawableFromRes(context, n);
        BitmapDrawable bitmapDrawable2 = new BitmapDrawable(context.getResources(), bitmapDrawable.getBitmap());
        Drawable drawable2 = DFLayoutHelper.createButtonDrawable(context, bitmapDrawable, 0.5f);
        Drawable drawable3 = DFLayoutHelper.createButtonDrawable(context, bitmapDrawable2, 0.5f);
        drawable3.setTint(COLOR_TINT_BTN_PRESSED);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{drawable2});
        LayerDrawable layerDrawable2 = new LayerDrawable(new Drawable[]{drawable3});
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)layerDrawable2);
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)layerDrawable);
        return stateListDrawable;
    }

    private static Drawable createBtnDrawable(Context context, int n, int n2) {
        Drawable drawable2 = DFLayoutHelper.createBtnDrawable(context, n);
        Drawable drawable3 = DFLayoutHelper.createBtnDrawable(context, n2);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{0x10100A1}, drawable2);
        stateListDrawable.addState(new int[]{-16842913}, drawable3);
        return stateListDrawable;
    }

    private static Drawable createPrevNextBtnDrawable(Context context, boolean bl) {
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        String string;
        String string2;
        StateListDrawable stateListDrawable = new StateListDrawable();
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        boolean bl2 = false;
        if (bl) {
            string2 = (String)dFStyleManager.getStyle(DFStyleManager.PROGRESSBAR_ENABLE_PREV_BUTTON_IMAGE);
            string = (String)dFStyleManager.getStyle(DFStyleManager.PROGRESSBAR_DISABLE_PREV_BUTTON_IMAGE);
            if (!string2.isEmpty() && !string.isEmpty()) {
                try {
                    drawable4 = DFUtils.getDrawableFromURL(context, string2);
                    drawable3 = drawable4.getConstantState().newDrawable().mutate();
                    drawable3.setColorFilter((ColorFilter)new PorterDuffColorFilter(Color.argb((int)70, (int)70, (int)70, (int)70), PorterDuff.Mode.SRC_ATOP));
                    drawable2 = DFUtils.getDrawableFromURL(context, string);
                    stateListDrawable.addState(new int[]{16842910, -16842919}, drawable4);
                    stateListDrawable.addState(new int[]{16842910, 16842919}, drawable3);
                    stateListDrawable.addState(new int[]{-16842910}, drawable2);
                    bl2 = true;
                }
                catch (DFUtils$EmptyStringException dFUtils$EmptyStringException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            string2 = (String)dFStyleManager.getStyle(DFStyleManager.PROGRESSBAR_ENABLE_NEXT_BUTTON_IMAGE);
            string = (String)dFStyleManager.getStyle(DFStyleManager.PROGRESSBAR_DISABLE_NEXT_BUTTON_IMAGE);
            if (!string2.isEmpty() && !string.isEmpty()) {
                try {
                    drawable4 = DFUtils.getDrawableFromURL(context, string2);
                    drawable3 = drawable4.getConstantState().newDrawable().mutate();
                    drawable3.setColorFilter((ColorFilter)new PorterDuffColorFilter(Color.argb((int)70, (int)70, (int)70, (int)70), PorterDuff.Mode.SRC_ATOP));
                    drawable2 = DFUtils.getDrawableFromURL(context, string);
                    stateListDrawable.addState(new int[]{16842910, -16842919}, drawable4);
                    stateListDrawable.addState(new int[]{16842910, 16842919}, drawable3);
                    stateListDrawable.addState(new int[]{-16842910}, drawable2);
                    bl2 = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (!bl2) {
            int n = bl ? 5 : 7;
            string = DFLayoutHelper.createButtonDrawable(context, n, 0.4f);
            int n2 = bl ? DFUtils.toDP(context, 6.0f) : 0;
            int n3 = !bl ? DFUtils.toDP(context, 6.0f) : 0;
            drawable2 = new RoundRectShape(new float[]{n2, n2, n3, n3, n3, n3, n2, n2}, null, null);
            ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)drawable2);
            ShapeDrawable shapeDrawable2 = new ShapeDrawable((Shape)drawable2);
            ShapeDrawable shapeDrawable3 = new ShapeDrawable((Shape)drawable2);
            ShapeDrawable shapeDrawable4 = new ShapeDrawable((Shape)drawable2);
            shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
            shapeDrawable.getPaint().setColor(COLOR_PREV_NEXT_BTN_BG);
            shapeDrawable2.getPaint().setStyle(Paint.Style.STROKE);
            shapeDrawable2.getPaint().setStrokeWidth((float)DFUtils.toDP(context, 1.0f));
            shapeDrawable2.getPaint().setColor(COLOR_PREV_NEXT_BTN_STROKE);
            shapeDrawable3.getPaint().setStyle(Paint.Style.FILL);
            shapeDrawable3.getPaint().setColor(COLOR_PREV_NEXT_BTN_PRESSED);
            shapeDrawable4.getPaint().setStyle(Paint.Style.FILL);
            shapeDrawable4.getPaint().setColor(COLOR_PREV_NEXT_BTN_DISABLED);
            LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{shapeDrawable, shapeDrawable2, string});
            LayerDrawable layerDrawable2 = new LayerDrawable(new Drawable[]{shapeDrawable3, shapeDrawable2, string});
            LayerDrawable layerDrawable3 = new LayerDrawable(new Drawable[]{shapeDrawable4, shapeDrawable2, string});
            stateListDrawable.addState(new int[]{16842910, -16842919}, (Drawable)layerDrawable2);
            stateListDrawable.addState(new int[]{16842910, 16842919}, (Drawable)layerDrawable);
            stateListDrawable.addState(new int[]{-16842910}, (Drawable)layerDrawable3);
        }
        return stateListDrawable;
    }

    private static void appendBottomBar(Context context, ViewGroup viewGroup) {
        FrameLayout frameLayout = (FrameLayout)viewGroup.findViewById(8192);
        int n = DFUtils.toDP(context, 10.0f);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setPadding(n, n, n, n);
        linearLayout2.setBackground(DFLayoutHelper.createBottomBarDrawable(context));
        linearLayout2.setOrientation(0);
        linearLayout2.setGravity(19);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        Button button = new Button(context);
        button.setId(8448);
        button.setBackground(DFLayoutHelper.createBtnDrawable(context, 1, 2));
        DFProgressbar dFProgressbar = new DFProgressbar(context, mProgrssBarPosition);
        dFProgressbar.setId(8451);
        dFProgressbar.setPadding(0, 0, 0, 0);
        Button button2 = new Button(context);
        button2.setId(8452);
        button2.setBackground(DFLayoutHelper.createPrevNextBtnDrawable(context, true));
        Button button3 = new Button(context);
        button3.setId(8453);
        button3.setBackground(DFLayoutHelper.createPrevNextBtnDrawable(context, false));
        int n2 = DFUtils.toDP(context, 50.0f);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(n2, n2);
        linearLayout2.addView((View)button, (ViewGroup.LayoutParams)layoutParams2);
        int n3 = DFUtils.toDP(context, 120.0f);
        LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(n3, -2);
        layoutParams3.gravity = 17;
        layoutParams3.weight = 1.0f;
        LinearLayout.LayoutParams layoutParams4 = new LinearLayout.LayoutParams(n2, n2);
        layoutParams4.gravity = 17;
        layoutParams4.weight = 1.0f;
        LinearLayout linearLayout3 = new LinearLayout(context);
        linearLayout3.setBackground(DFLayoutHelper.createMicDrawable(context));
        linearLayout3.addView((View)DFLayoutHelper.createMICBtn(context), (ViewGroup.LayoutParams)layoutParams4);
        LinearLayout linearLayout4 = new LinearLayout(context);
        linearLayout4.addView((View)linearLayout3, (ViewGroup.LayoutParams)layoutParams3);
        if (mProgrssBarPosition == DFLayoutHelper$PROGRESSBAR_POSITION.TOP) {
            linearLayout2.addView(new View(context), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 1, 1.0f));
            linearLayout2.addView((View)button2, (ViewGroup.LayoutParams)layoutParams2);
            linearLayout2.addView((View)button3, (ViewGroup.LayoutParams)layoutParams2);
            FrameLayout frameLayout2 = new FrameLayout(context);
            frameLayout2.addView((View)linearLayout2);
            frameLayout2.addView((View)linearLayout4, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
            LinearLayout.LayoutParams layoutParams5 = new LinearLayout.LayoutParams(-1, -2);
            layoutParams5.setMargins(0, 0, 0, 0);
            dFProgressbar.setLayoutParams((ViewGroup.LayoutParams)layoutParams5);
            linearLayout.addView((View)dFProgressbar);
            linearLayout.addView((View)frameLayout2);
        } else if (mProgrssBarPosition == DFLayoutHelper$PROGRESSBAR_POSITION.BOTTOM) {
            LinearLayout.LayoutParams layoutParams6 = new LinearLayout.LayoutParams(-2, -2, 3.0f);
            layoutParams6.setMargins(DFUtils.toDP(context, 20.0f), 0, DFUtils.toDP(context, 20.0f), 0);
            dFProgressbar.setLayoutParams((ViewGroup.LayoutParams)layoutParams6);
            linearLayout2.addView((View)dFProgressbar);
            linearLayout2.addView((View)button2, (ViewGroup.LayoutParams)layoutParams2);
            linearLayout2.addView((View)button3, (ViewGroup.LayoutParams)layoutParams2);
            FrameLayout frameLayout3 = new FrameLayout(context);
            frameLayout3.addView((View)linearLayout2);
            frameLayout3.addView((View)linearLayout4, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
            linearLayout.addView((View)frameLayout3);
        }
        frameLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    static {
        COLOR_BOTTOM_STROKE = Color.argb((int)51, (int)0, (int)0, (int)0);
        COLOR_MIC_BG = Color.argb((int)153, (int)255, (int)255, (int)255);
        COLOR_TINT_BTN_PRESSED = Color.argb((int)255, (int)136, (int)136, (int)136);
        COLOR_PREV_NEXT_BTN_BG = Color.argb((int)128, (int)255, (int)255, (int)255);
        COLOR_PREV_NEXT_BTN_PRESSED = Color.argb((int)128, (int)208, (int)208, (int)208);
        COLOR_PREV_NEXT_BTN_DISABLED = Color.argb((int)128, (int)148, (int)148, (int)148);
        COLOR_PREV_NEXT_BTN_STROKE = Color.argb((int)51, (int)0, (int)0, (int)0);
    }
}

