/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import oz.viewer.ui.df.DFUtils;

public class DFRoundRectFrameLayout
extends FrameLayout {
    public static final float DEFAULT_RAD_DP = 6.0f;
    private static final int DEFAULT_RECT_COLOR = 0x33FFFFFF;
    private static final int DEFAULT_RECT_BORDER_COLOR = -855638017;
    private static final float DEFAULT_RECT_BORDER_WIDTH = 1.0f;
    private ImageView mImageView;
    private float mRadDP;
    private int mRectColor;
    private int mRectBorderColor;
    private float mRectBorderWidth;

    public DFRoundRectFrameLayout(Context context) {
        super(context);
    }

    public DFRoundRectFrameLayout(Context context, int n) {
        super(context);
        this.init();
        if (n != 0) {
            this.mImageView.setImageResource(n);
        }
    }

    public void setImageResource(int n) {
        this.mImageView.setBackgroundResource(n);
    }

    public void setImageResource(Drawable drawable2) {
        if (drawable2 != null) {
            this.mImageView.setBackground(drawable2);
        }
    }

    public DFRoundRectFrameLayout(Context context, Drawable drawable2) {
        super(context);
        this.init();
        this.setImageResource(drawable2);
    }

    public DFRoundRectFrameLayout(Context context, Drawable drawable2, float f2) {
        super(context);
        this.init(f2);
        this.setImageResource(drawable2);
    }

    public DFRoundRectFrameLayout(Context context, Drawable drawable2, int n, int n2, int n3) {
        super(context);
        this.init(n, n2, n3);
        this.setImageResource(drawable2);
    }

    private void init() {
        this.init(6.0f);
    }

    private void init(float f2) {
        this.init(f2, 0x33FFFFFF, -855638017, 1.0f);
    }

    private void init(int n, int n2, int n3) {
        this.init(0.0f, n, n2, n3);
    }

    private void init(float f2, int n, int n2, float f3) {
        this.addImageView();
        this.setRad(f2);
        this.setRectColor(n);
        this.setBorderColor(n2);
        this.setBorderWidth(f3);
        this.initExtra();
        this.applyRect();
    }

    public ImageView getImageView() {
        return this.mImageView;
    }

    protected ImageView.ScaleType getScaleType() {
        return ImageView.ScaleType.CENTER;
    }

    public void addImageView() {
        this.mImageView = new ImageView(this.getContext());
        this.mImageView.setScaleType(this.getScaleType());
        this.addImageView(this.mImageView);
    }

    protected void addImageView(ImageView imageView) {
        this.addView((View)imageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
    }

    protected void initExtra() {
    }

    public void setRad(float f2) {
        this.mRadDP = f2;
    }

    public float getRad() {
        return this.mRadDP;
    }

    public void setRectColor(int n) {
        this.mRectColor = n;
    }

    protected int getRectColor() {
        return this.mRectColor;
    }

    public void setBorderColor(int n) {
        this.mRectBorderColor = n;
    }

    protected int getBorderColor() {
        return this.mRectBorderColor;
    }

    public void setBorderWidth(float f2) {
        this.mRectBorderWidth = f2;
    }

    protected float getBorderWidth() {
        return this.mRectBorderWidth;
    }

    public void applyRect() {
        this.getBackgroundView().setBackground(this.createDrawable());
    }

    protected View getBackgroundView() {
        return this;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mImageView.setEnabled(bl);
    }

    protected Drawable createDrawable() {
        return DFRoundRectFrameLayout.getGDNormalFrame(this.getContext(), this.mRectColor, this.mRectBorderColor, this.mRectBorderWidth, this.mRadDP);
    }

    protected static GradientDrawable getGDNormalFrame(Context context, int n, int n2, float f2, float f3) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(n);
        gradientDrawable.setStroke(DFUtils.toDP(context, f2), n2);
        gradientDrawable.setCornerRadius((float)DFUtils.toDP(context, f3));
        return gradientDrawable;
    }
}

