/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFLottieCheckView;
import oz.viewer.ui.df.view.DFRoundRectFrameLayout;

public class DFSelectItemView
extends DFRoundRectFrameLayout {
    private static final int DP_PADDING = 12;
    private static final int SP_TEXT_SIZE = 20;
    private boolean mHasImage;
    private LinearLayout mLayout;
    private TextView mTextView;
    private int mRectSelectedColor;
    private float mRectBorderSelectedWidth;
    private int mRectBorderSelectedColor;
    private DFLottieCheckView mCheckView;

    public DFSelectItemView(Context context) {
        super(context, null);
        this.mHasImage = false;
    }

    public DFSelectItemView(Context context, int n) {
        super(context, n);
        this.mHasImage = true;
    }

    public DFSelectItemView(Context context, Drawable drawable2) {
        super(context, drawable2);
        this.mHasImage = true;
    }

    public DFSelectItemView(Context context, Drawable drawable2, float f2) {
        super(context, drawable2, f2);
        this.mHasImage = true;
    }

    public DFSelectItemView(Context context, Drawable drawable2, float f2, int n, int n2) {
        super(context);
        drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(n2)), PorterDuff.Mode.SRC_ATOP));
        this.initEtcItemView(drawable2, f2, n, n2, -1);
    }

    public DFSelectItemView(Context context, Drawable drawable2, float f2, int n, int n2, int n3) {
        super(context);
        this.initEtcItemView(drawable2, f2, n, n2, n3);
        int n4 = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.IC_IMAGEPICKER_GALLERYBUTTON_FONT_COLOR));
        this.mTextView.setTextColor(n4);
    }

    private void initEtcItemView(Drawable drawable2, float f2, int n, int n2, int n3) {
        this.mHasImage = true;
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        int n4 = 1;
        if (f2 >= 0.0f) {
            this.setRad(f2);
        }
        if (n3 != -1) {
            n4 = (Integer)dFStyleManager.getStyle(n3);
        }
        this.addImageView();
        this.setImageResource(drawable2);
        int n5 = DFUtils.getARGB((Integer)dFStyleManager.getStyle(n));
        this.setRectColor(n5);
        this.setBorderColor(DFUtils.getRGB((Integer)dFStyleManager.getStyle(n2)));
        this.setBorderWidth(n4);
        this.setRectSelectColor(n5 == 0 ? 0x33FFFFFF : DFUtils.getDisableColor(DFUtils.getARGB((Integer)dFStyleManager.getStyle(n))));
        this.setBorderSelectedColor(DFUtils.getRGB((Integer)dFStyleManager.getStyle(n2)));
        this.setBorderSelectedWidth(n4);
        this.applyRect();
    }

    protected void addImageView(ImageView imageView) {
        this.mLayout = new LinearLayout(this.getContext());
        this.mLayout.setOrientation(0);
        this.mLayout.setGravity(19);
        int n = DFUtils.toDP(this.getContext(), 12.0f);
        this.mLayout.setPadding(n, n, n, n);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.mLayout.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
        this.mTextView = new TextView(this.getContext());
        this.mTextView.setTextSize(20.0f);
        this.mTextView.setTextColor(DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.IC_ITEMBUTTON_FONT_COLOR)));
        this.mCheckView = new DFLottieCheckView(this.getContext());
        this.mLayout.addView((View)this.mTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 10.0f));
        this.mLayout.addView((View)this.mCheckView);
        this.addView((View)this.mLayout);
        this.updateMargin();
    }

    public void setRectSelectColor(int n) {
        this.mRectSelectedColor = n;
    }

    public void setBorderSelectedColor(int n) {
        this.mRectBorderSelectedColor = n;
    }

    public void setBorderSelectedWidth(float f2) {
        this.mRectBorderSelectedWidth = f2;
    }

    public void setImageViewSize(int n) {
        this.setImageViewSize(n, n);
    }

    public void setImageViewSize(int n, int n2) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.getImageView().getLayoutParams();
        if (n > 0) {
            layoutParams.width = n;
        }
        if (n2 > 0) {
            layoutParams.height = n2;
        }
        this.requestLayout();
    }

    private void updateMargin() {
        int n;
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.getImageView().getLayoutParams();
        layoutParams.rightMargin = this.mHasImage && this.mTextView.getText().length() > 0 ? (n = DFUtils.toDP(this.getContext(), 12.0f)) : 0;
    }

    protected void initExtra() {
        super.initExtra();
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        int n = DFUtils.getARGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_SELECT_BACKGROUND_COLOR));
        int n2 = DFUtils.getARGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_UNSELECT_BACKGROUND_COLOR));
        int n3 = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_BORDER_COLOR));
        int n4 = (Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_SELECT_BORDER_THICK);
        int n5 = (Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_UNSELECT_BORDER_THICK);
        this.setRectColor(n2);
        this.setRectSelectColor(n);
        this.setBorderColor(n3);
        this.setBorderSelectedColor(n3);
        this.setBorderWidth(n5);
        this.setBorderSelectedWidth(n4);
    }

    protected Drawable createDrawable() {
        Drawable drawable2 = this.createSelectedDrawable();
        Drawable drawable3 = this.createDeselectedDrawable();
        Drawable drawable4 = this.createDisabledDrawable();
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{-16842910}, drawable4);
        stateListDrawable.addState(new int[]{16842919}, drawable2);
        stateListDrawable.addState(new int[]{-16842913}, drawable3);
        stateListDrawable.addState(new int[]{0x10100A1}, drawable2);
        return stateListDrawable;
    }

    protected Drawable createDeselectedDrawable() {
        return super.createDrawable();
    }

    protected Drawable createSelectedDrawable() {
        return DFSelectItemView.getGDNormalFrame(this.getContext(), this.mRectSelectedColor, this.mRectBorderSelectedColor, this.mRectBorderSelectedWidth, this.getRad());
    }

    protected Drawable createDisabledDrawable() {
        GradientDrawable gradientDrawable = (GradientDrawable)this.createDeselectedDrawable();
        return gradientDrawable;
    }

    public void setInnerLayoutGravity(int n) {
        this.mLayout.setGravity(n);
    }

    public void setText(String string) {
        this.mTextView.setText((CharSequence)string);
        this.updateMargin();
    }

    public void setTextColor(int n) {
        this.mTextView.setTextColor(n);
    }

    public void setTextSize(float f2) {
        this.mTextView.setTextSize(f2);
    }

    public void setGravity(int n) {
        this.mTextView.setGravity(n);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mTextView.setEnabled(bl);
        this.updateTextViewColor();
    }

    private void updateTextViewColor() {
        int n = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.IC_ITEMBUTTON_FONT_COLOR));
        int n2 = DFUtils.getPlaceHolderColor(n);
        this.mTextView.setTextColor(this.mTextView.isEnabled() ? n : n2);
    }

    public void setSelected(boolean bl, boolean bl2) {
        if (bl && bl2 && this.mCheckView != null) {
            this.mCheckView.requestPlay();
        } else {
            this.mCheckView.requestPause();
        }
        super.setSelected(bl);
        if (!this.mTextView.isEnabled()) {
            int n;
            DFStyleManager dFStyleManager = DFStyleManager.getInstance();
            int n2 = DFUtils.getARGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_SELECT_BACKGROUND_COLOR));
            int n3 = DFUtils.getARGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_UNSELECT_BACKGROUND_COLOR));
            int n4 = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_BORDER_COLOR));
            int n5 = (Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_SELECT_BORDER_THICK);
            int n6 = (Integer)dFStyleManager.getStyle(DFStyleManager.IC_ITEMBUTTON_UNSELECT_BORDER_THICK);
            int n7 = this.isSelected() ? n2 : n3;
            int n8 = Color.alpha((int)n7);
            int n9 = 0;
            if (n8 == 0) {
                n9 = n8;
            } else {
                n = DFUtils.getPlaceHolderColor(n7);
                n9 = Color.argb((int)n8, (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n));
            }
            n = DFUtils.getPlaceHolderColor(n4);
            float f2 = this.isSelected() ? (float)n5 : (float)n6;
            this.setRectColor(n9);
            this.setRectSelectColor(n9);
            this.setBorderColor(n);
            this.setBorderSelectedColor(n);
            this.setBorderWidth(f2);
            this.setBorderSelectedWidth(f2);
            this.applyRect();
        }
    }

    public void setOnlyUseImageButton(boolean bl) {
        if (bl) {
            if (this.mCheckView != null) {
                this.mTextView.setVisibility(0);
                this.mCheckView.setVisibility(0);
            }
        } else if (this.mCheckView != null) {
            this.mTextView.setVisibility(8);
            this.mCheckView.setVisibility(8);
        }
    }

    public void setUseCheckView(boolean bl) {
        if (this.mCheckView != null) {
            this.mCheckView.setVisibility(bl ? 0 : 8);
        }
    }
}

